<?php // Tips Settings

for ( $i = 0; $i < 4; $i++ ) {
	$level_tips_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_tips',
		'type'     => 'switch',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_tips_enabled', '=', true ),
		'default'  => true
	);

	$subscription_tips_fields[] = array(
		'id'       => 'wpjobster_subscription_tips_level' . $i,
		'type'     => 'switch',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_tips_enabled', '=', true ),
		'default'  => true
	);
}

$feature_tip_settings_array = array(
	'title'      => __( 'Tips', 'wpjobster' ),
	'desc'       => __( 'Tips Settings', 'wpjobster' ),
	'id'         => 'tips-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(
			array(
				'id'       => 'wpjobster_tips_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enable tips', 'wpjobster' ),
				'subtitle' => __( 'This will add the possibility for buyers to add tips for sellers.', 'wpjobster' ),
				'default'  => true,
			),
		),

/* LEVEL */

		array(
			array(
				'id'       => 'level-tips-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			)

		), $level_tips_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-tips-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
		), $subscription_tips_fields
	)
);