<?php // Authentication Settings

$general_authentication_settings_array = array(
	'title'      => __( 'Authentication', 'wpjobster' ),
	'desc'       => __( 'Authentication Settings', 'wpjobster' ),
	'id'         => 'authentication-settings',
	'subsection' => true,
	'fields'     => array(

/* JOB */

		array(
			'id'       => 'user-authentication-job-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Job', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_continue_button_not_loggefin',
			'type'     => 'select',
			'title'    => __( 'Continue button on Job page for Not Loggedin Users', 'wpjobster' ),
			'subtitle' => __( 'Set if you want the Continue button from the Job page should open Login or Register popup', 'wpjobster' ),
			'options'  => array(
				'login-link'    => __( 'Login', 'wpjobster' ),
				'register-link' => __( 'Register', 'wpjobster' ),
			),
			'default'  => 'login-link'
		),

/* LOGIN */

		array(
			'id'       => 'user-authentication-login-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Login', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_login_hints',
			'type'     => 'switch',
			'title'    => __( 'Enable login hints', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the hints on login & registration pages.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_user_2fa',
			'type'     => 'switch',
			'title'    => __( 'Enable 2FA on login page', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the field for 2FA on login page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_user_login_reCaptcha',
			'type'     => 'switch',
			'title'    => __( 'Enable reCAPTCHA v2 on login page', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the field for reCaptcha on login page.', 'wpjobster' ),
			'desc'     => __( 'Go to General Settings and fill in the <b>reCAPTCHA v2 API key</b> and the <b>reCAPTCHA v2 API secret</b> fields.', 'wpjobster' ),
			'default'  => false,
		),

/* REGISTER */

		array(
			'id'       => 'user-authentication-register-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Register', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_shoutout_offer_number',
			'type'     => 'switch',
			'title'    => __( 'Enable shoutout offer on registration page', 'wpjobster' ),
			'subtitle' => __( 'Activating this option, together with the creation of the user account, a job will also be created, to which the user will be redirected after registration, to complete all the information and publish it.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_phone_number',
			'type'     => 'switch',
			'title'    => __( 'Enable user phone number on registration page', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the field for phone number on registration page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_phone_number_mandatory',
			'type'     => 'switch',
			'title'    => __( 'Phone number mandatory on registration', 'wpjobster' ),
			'subtitle' => __( 'Phone number mandatory on registration page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_user_company',
			'type'     => 'switch',
			'title'    => __( 'Enable user company on registration page', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the field for company on registration page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_register_tos_and_privacy',
			'type'     => 'select',
			'title'    => __( 'TOS and Privacy Policy on registration page', 'wpjobster' ),
			'subtitle' => __( 'Don\'t forget to check and update the Terms of Service and Privacy Policy pages with your own terms! You can find them in the Page Assignments section.', 'wpjobster' ),
			'options'  => array(
				'disabled' => __( 'Disabled', 'wpjobster' ),
				'text'     => __( 'Text Notice', 'wpjobster' ),
				'checkbox' => __( 'Required Checkbox', 'wpjobster' )
			),
			'default'  => 'disabled'
		),
		array(
			'id'       => 'wpjobster_enable_user_register_reCaptcha',
			'type'     => 'switch',
			'title'    => __( 'Enable reCAPTCHA v2 on register page', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the field for reCaptcha on register page.', 'wpjobster' ),
			'desc'     => __( 'Go to General Settings and fill in the <b>reCAPTCHA v2 API key</b> and the <b>reCAPTCHA v2 API secret</b> fields.', 'wpjobster' ),
			'default'  => false,
		),
	)
);