<?php // Cron Settings

$general_cron_settings_array = [
	'title'      => __( 'Cron', 'wpjobster' ),
	'desc'       => __( 'Cron Settings', 'wpjobster' ),
	'id'         => 'cron-settings',
	'subsection' => true,
	'fields'     => [
		[
			'id'          => 'wpj_update_exchange_rates_cron_enabled',
			'type'        => 'switch',
			'title'       => __( 'Currency exchange update', 'wpjobster' ),
			'subtitle'    => __( 'The currency exchange update cron is a scheduled task designed to automatically update the currency exchange values on the website once a day.', 'wpjobster' ),
			'description' => __( 'To run this cron, the "Enable Open Exchange Rates API" options must be enabled.', 'wpjobster' ),
			'default'     => true
		],
		[
			'id'       => 'wpj_inactive_expired_requests_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Mark request as inactive', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and marks as inactive all requests that filled the deadline or end date field, and this date has expired.', 'wpjobster' ),
			'default'  => true
		],

/* USER */

		[
			'id'       => 'user-crons-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'User', 'wpjobster' ),
			'indent'   => true
		],
		[
			'id'       => 'wpj_update_user_level_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'User level upgrade & downgrade', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and updates the user\'s level, increasing or decreasing it depending on the eligibility settings.', 'wpjobster' ),
			'description' => __( 'To run this cron, the "Automatically upgrade levels" or "Automatically downgrade levels" option must be enabled.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_vacation_check_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Vacation mode', 'wpjobster' ),
			'subtitle' => __( 'This cron runs twice a day and updates the user\'s vacation mode according to what is set in the start date and end date.', 'wpjobster' ),
			'default'  => true
		],

/* PAYMENT TYPE */

		[
			'id'       => 'payment-type-crons-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Payment type', 'wpjobster' ),
			'indent'   => true
		],
		[
			'id'          => 'wpj_check_subscription_cron_enabled',
			'type'        => 'switch',
			'title'       => __( 'Subscription charge & update', 'wpjobster' ),
			'subtitle'    => __( 'This cron runs once a day and withdraws the user\'s credits corresponding to the subscription and updates the user\'s options according to the paid subscription. This cron only runs for subscriptions bought with credits.', 'wpjobster' ),
			'description' => __( 'To run this cron, Subscriptions must be enabled.', 'wpjobster' ),
			'default'     => true
		],
		[
			'id'          => 'wpj_check_featured_cron_enabled',
			'type'        => 'switch',
			'title'       => __( 'Featured job update', 'wpjobster' ),
			'subtitle'    => __( 'This cron runs twice a day and updates the jobs that have featured, marking as featured those that are in line and marking as normal those whose promotion period has expired.', 'wpjobster' ),
			'description' => __( 'To run this cron, Featured must be enabled.', 'wpjobster' ),
			'default'     => true
		],

/* ORDER */

		[
			'id'       => 'order-crons-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Order', 'wpjobster' ),
			'indent'   => true
		],
		[
			'id'       => 'wpj_order_cleared_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Mark orders as cleared', 'wpjobster' ),
			'subtitle' => __( 'This cron runs twice a day and marks as cleared orders that are more than X days since they were marked as completed, where X number of days is set in the "Clearing Period" option.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_order_completed_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Mark orders as completed', 'wpjobster' ),
			'subtitle' => __( 'This cron runs twice a day and marks as complete all orders that have been delivered but have not been marked as complete by the buyer, only if more than X hours have passed since delivery, where the number of hours X is set in the "Auto-mark transaction as completed" option.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_order_expired_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Mark orders as expired', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and cancels and marks as expired all orders that have not been paid and more than X days have passed since the first payment attempt, where the number of days X is set in the "Auto-close pending payment" option.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_order_failed_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Mark orders as closed', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and marks as closed all orders that have the payment status marked as failed.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_autoreject_order_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Mark orders as rejected', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and marks as cancelled, all orders that are more than 24 hours from the payment date, and the seller has not responded in any way. Also at this time, the buyer receives his money back and also receives an email in which he is informed that his order has been rejected.', 'wpjobster' ),
			'description' => __( 'To run this cron, the "Require seller to confirm order" options must be enabled.', 'wpjobster' ),
			'default'  => true
		],

/* NOTIFY */

		[
			'id'       => 'notify-crons-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Notify', 'wpjobster' ),
			'indent'   => true
		],
		[
			'id'       => 'wpj_buyer_cart_notify_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Buyer cart', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and sends emails to buyers, notifying them that there are jobs for which they visited the checkout page but did not complete the payment. These notifications are sent X time per job, where the X number is given by the "Buyer cart notify number" option.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_order_expire_soon_notify_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Order expires soon', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and sends an email to the seller, notifying him that the delivery time is about to expire. This email is sent if there are less than 24 hours until the delivery time expires.', 'wpjobster' ),
			'default'  => true
		],
		[
			'id'       => 'wpj_pending_payment_expire_soon_notify_cron_enabled',
			'type'     => 'switch',
			'title'    => __( 'Pending payment expires soon', 'wpjobster' ),
			'subtitle' => __( 'This cron runs once a day and sends an email to the buyer, notifying them that orders for which they haven\'t completed the payment are expiring soon. This email is sent if there are less than 24 hours left until the time to complete the order payment expires.', 'wpjobster' ),
			'default'  => true
		]
	]
];