<?php // Job Settings

$general_job_settings_array = array(
	'title'      => __( 'Job', 'wpjobster' ),
	'desc'       => __( 'Job Settings', 'wpjobster' ),
	'id'         => 'job-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_admin_approve_job',
			'type'     => 'switch',
			'title'    => __( 'Admin approves each job', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option, the administrator will check and approve each posted job before it is made public.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_preferred_image_uploader',
			'type'     => 'select',
			'title'    => __( 'Preferred job image uploader', 'wpjobster' ),
			'subtitle' => __( 'Image upload form style', 'wpjobster' ),
			'options'  => array(
				'dropzone'        => __( 'DropzoneJS', 'wpjobster' ),
				'html5fileupload' => __( 'HTML5 File Upload', 'wpjobster' ),
			),
			'default'  => 'dropzone',
		),
		array(
			'id'       => 'wpjobster_default_sort_by_job',
			'type'     => 'select',
			'title'    => __( 'Default jobs listing order', 'wpjobster' ),
			'subtitle' => __( 'Here you can choose which sort type to be selected by default for pages where the user can choose (like category or search).', 'wpjobster' ),
			'options'  => array(
				'auto'          => __( 'Auto', 'wpjobster' ),
				'new'           => __( 'Newest', 'wpjobster' ),
				'old'           => __( 'Oldest', 'wpjobster' ),
				'rating'        => __( 'Rating', 'wpjobster' ),
				'reviews'       => __( 'Reviews', 'wpjobster' ),
				'views'         => __( 'Views', 'wpjobster' ),
				'price_lowest'  => __( 'Price lowest', 'wpjobster' ),
				'price_highest' => __( 'Price highest', 'wpjobster' ),
				'distance'      => __( 'Distance', 'wpjobster' )
			),
			'default'  => 'auto',
		),

/* FEATURES */
		array(
			'id'       => 'job-features-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Features', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_checkout_extra_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable extra on payment page', 'wpjobster' ),
			'subtitle' => __( 'This will let logged in users to add or remove job extra on checkout page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_job_attachments_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable job preview', 'wpjobster' ),
			'subtitle' => __( 'Allow your users to upload sample files for their job, downloadable by everyone from the single job page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_job_views',
			'type'     => 'switch',
			'title'    => __( 'Enable views', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option will display on the job page, the total number of views of the job.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_job_view_interval_number',
			'type'     => 'text',
			'title'    => __( 'Count interval number', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_job_views', '=', true ),
			'default'  => 1,
		),
		array(
			'id'       => 'wpjobster_job_view_interval_type',
			'type'     => 'select',
			'title'    => __( 'Count interval type', 'wpjobster' ),
			'options'  => array(
				'minutes' => __( 'minutes', 'wpjobster' ),
				'hours'   => __( 'hours', 'wpjobster' ),
				'days'    => __( 'days', 'wpjobster' ),
				'weeks'   => __( 'weeks', 'wpjobster' ),
				'months'  => __( 'months', 'wpjobster' ),
				'years'   => __( 'years', 'wpjobster' )
			),
			'default'  => 'minutes',
			'required' => array( 'wpjobster_enable_job_views', '=', true )
		),
		array(
			'id'       => 'wpjobster_job_share_promt_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable share prompt', 'wpjobster' ),
			'subtitle' => __( 'Displays a pop-up for sharing the job created on social networks, after a seller posts a job.', 'wpjobster' ),
			'description' => __( 'Plugin Easy Social Share Buttons for WordPress must be active', 'wpjobster' ),
			'default'  => true,
		),

/* CATEGORIES */
		array(
			'id'       => 'job-categories-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Categories', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_display_job_empty_categories',
			'type'     => 'switch',
			'title'    => __( 'Display empty categories', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option, categories without jobs will appear in the category list.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_display_job_category_description',
			'type'     => 'select',
			'title'    => __( 'Display category description', 'wpjobster' ),
			'subtitle' => __( 'Show or not the description of the category on the category page.', 'wpjobster' ),
			'options'  => array(
				'yes'                    => __( 'Yes', 'wpjobster' ),
				'only_for_categories'    => __( 'Only for categories', 'wpjobster' ),
				'only_for_subcategories' => __( 'Only for subcategories', 'wpjobster' ),
				'no'                     => __( 'No', 'wpjobster' ),
			),
			'default'  => 'yes',
		),

/* COVER */
		array(
			'id'       => 'job-cover-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Cover', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_job_cover',
			'type'     => 'switch',
			'title'    => __( 'Enable cover image for jobs', 'wpjobster' ),
			'subtitle' => __( 'Allows sellers to upload a cover image for the posted job', 'wpjobster' ),
			'default'  => true
		),
		array(
			'id'       => 'wpjobster_max_job_cover_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max cover upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'required' => array( 'wpjobster_enable_job_cover', '=', true ),
			'default'  => 10,
		),
		array(
			'id'       => 'wpjobster_min_cover_img_upload_width',
			'type'     => 'text',
			'title'    => __( 'Cover image minimum upload width', 'wpjobster' ),
			'subtitle' => __( 'in PX', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_job_cover', '=', true ),
			'default'  => 980,
		),
		array(
			'id'       => 'wpjobster_min_cover_img_upload_height',
			'type'     => 'text',
			'title'    => __( 'Cover image minimum upload height', 'wpjobster' ),
			'subtitle' => __( 'in PX', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_job_cover', '=', true ),
			'default'  => 180,
		),

/* IMAGES */
		array(
			'id'       => 'job-images-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Images', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_mandatory_pics_for_jbs',
			'type'     => 'switch',
			'title'    => __( 'Mandatory to upload pictures for jobs', 'wpjobster' ),
			'subtitle' => __( 'Enable this option to prevent sellers from posting jobs without at least one image.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_default_nr_of_pics',
			'type'     => 'text',
			'title'    => __( 'Max amount of pictures', 'wpjobster' ),
			'subtitle' => __( 'Maximum number of uploaded images per job', 'wpjobster' ),
			'default'  => 10,
		),
		array(
			'id'       => 'wpjobster_max_img_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max image upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 10,
		),
		array(
			'id'       => 'wpjobster_min_img_upload_width',
			'type'     => 'text',
			'title'    => __( 'Min image upload width', 'wpjobster' ),
			'subtitle' => __( 'in PX', 'wpjobster' ),
			'default'  => 720,
		),
		array(
			'id'       => 'wpjobster_min_img_upload_height',
			'type'     => 'text',
			'title'    => __( 'Min image upload height', 'wpjobster' ),
			'subtitle' => __( 'in PX', 'wpjobster' ),
			'default'  => 405,
		),

/* AUDIO */
		array(
			'id'       => 'job-audio-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Audio', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_audio',
			'type'     => 'switch',
			'title'    => __( 'Enable audio files', 'wpjobster' ),
			'subtitle' => __( 'Allows sellers to upload audio files when posting a job.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_mandatory_audio_for_jbs',
			'type'     => 'switch',
			'title'    => __( 'Mandatory to upload audio for jobs', 'wpjobster' ),
			'subtitle' => __( 'Enable this option to prevent sellers from posting jobs without at least one audio file.', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpjobster_audio', '=', true )
		),
		array(
			'id'       => 'wpjobster_max_uploads_audio',
			'type'     => 'text',
			'title'    => __( 'Max audio files number', 'wpjobster' ),
			'subtitle' => __( 'Maximum number of uploaded files per job', 'wpjobster' ),
			'default'  => 5,
			'required' => array( 'wpjobster_audio', '=', true )
		),
		array(
			'id'       => 'wpjobster_max_audio_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max audio file size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'required' => array( 'wpjobster_audio', '=', true ),
			'default'  => 10,
		),

/* LOCATION */
		array(
			'id'       => 'job-location-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Location', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_lets_meet',
			'type'     => 'switch',
			'title'    => __( 'Enable let\'s meet', 'wpjobster' ),
			'subtitle' => __( 'Jobs where the users need to meet in person.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_location',
			'type'     => 'switch',
			'title'    => __( 'Enable locations', 'wpjobster' ),
			'subtitle' => __( 'Enable locations for jobs', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_location_distance',
			'type'     => 'switch',
			'title'    => __( 'Enable distance', 'wpjobster' ),
			'subtitle' => __( 'Seller can type how much he can travel for a job where he needs to meet the buyer.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_location_display_map',
			'type'     => 'switch',
			'title'    => __( 'Display location google map', 'wpjobster' ),
			'subtitle' => __( 'The map will be displayed on the job page, under the description.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_location_display_map_user_choice',
			'type'     => 'switch',
			'title'    => __( 'Let the user choose to hide map', 'wpjobster' ),
			'subtitle' => __( 'Let the user choose whether to display the map or not on his job.', 'wpjobster' ),
			'default'  => false,
		),

/* DELIVERY & SHIPPING */
		array(
			'id'       => 'job-delivery-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Delivery & Shipping', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_delivery_time',
			'type'     => 'switch',
			'title'    => __( 'Enable delivery time', 'wpjobster' ),
			'subtitle' => __( 'If disabled, the seller won\'t be able to choose delivery time or instant, the timer on the transaction page won\'t show up and the buyer won\'t be able to force cancel if order not delivered in time.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_job_max_delivery_days',
			'type'     => 'text',
			'title'    => __( 'Max delivery days', 'wpjobster' ),
			'subtitle' => __( 'The maximum number allowed for choosing the delivery time.', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_delivery_time', '=', true ),
			'default'  => 30,
		),
		array(
			'id'       => 'wpjobster_enable_instant_delivery',
			'type'     => 'switch',
			'title'    => __( 'Enable instant delivery file', 'wpjobster' ),
			'subtitle' => __( 'By activating this option, sellers have the opportunity to post jobs with instant delivery.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_shipping',
			'type'     => 'switch',
			'title'    => __( 'Enable shipping', 'wpjobster' ),
			'subtitle' => __( 'Allows sellers to add a separate price for delivery,', 'wpjobster' ),
			'default'  => true,
		),

/* TEXT */
		array(
			'id'       => 'job-text-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Text', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_job_description_type',
			'type'     => 'select',
			'title'    => __( 'Description editor type', 'wpjobster' ),
			'subtitle' => __( 'The style of the description field on the post new job page', 'wpjobster' ),
			'options'  => array(
				'simple'  => __( 'Simple', 'wpjobster' ),
				'wysiwyg' => __( 'WYSIWYG', 'wpjobster' ),
				'tinymce' => __( 'TinyMCE', 'wpjobster' ),
			),
			'default'  => 'simple',
		),
		array(
			'id'       => 'wpjobster_view_more_description_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable "Read More" for description', 'wpjobster' ),
			'subtitle' => __( 'If this option is activated, initially, only part of the description will be seen on the job page, the rest being displayed when pressing the "Read more" button', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_buyer_instructions_job_enabled',
			'type'     => 'switch',
			'title'    => __( 'Display buyer instructions on job page:', 'wpjobster' ),
			'subtitle' => __( 'If this option is activated, the information entered in the "Instructions to buyer" field will be displayed on the job page.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_job_instructions_responsive_enabled',
			'type'     => 'switch',
			'title'    => __( 'Display responsive tooltip instructions:', 'wpjobster' ),
			'subtitle' => __( 'If this option is enabled, instructions will be displayed on the new job posting page for mobile and tablet devices.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_tos_type',
			'type'     => 'select',
			'title'    => __( 'Terms of service agreement', 'wpjobster' ),
			'subtitle' => __( 'Choose whether to require or not the terms of service agreement when posting a new job and how to display it', 'wpjobster' ),
			'options'  => array(
				'disabled'     => __( 'Disabled', 'wpjobster' ),
				'link'         => __( 'Checkbox and Link', 'wpjobster' ),
				'show_on_page' => __( 'Checkbox and Full Content', 'wpjobster' )
			),
			'default'  => 'show_on_page',
		),

/* REVIEWS */
		array(
			'id'       => 'job-review-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Reviews', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_job_min_rating',
			'type'     => 'text',
			'title'    => __( 'Min rating number', 'wpjobster' ),
			'subtitle' => __( 'The minimum number of reviews to display the job rating.', 'wpjobster' ),
			'default'  => 3,
		),
		array(
			'id'       => 'wpjobster_job_author_reviews_number',
			'type'     => 'text',
			'title'    => __( 'Author reviews number on job page', 'wpjobster' ),
			'subtitle' => __( 'Number of author reviews displayed on the job presentation page', 'wpjobster' ),
			'default'  => 12,
		),
	)
);