<?php // Level Settings

$general_level_settings_array = array(
	'title'      => __( 'Level', 'wpjobster' ),
	'desc'       => __( 'Level Settings', 'wpjobster' ),
	'id'         => 'user-level-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_default_level_nr',
			'type'     => 'text',
			'title'    => __( 'Default user level', 'wpjobster' ),
			'subtitle' => __( 'Set a value up to 3 max.', 'wpjobster' ),
			'default'  => 0,
		),
		array(
			'id'       => 'wpjobster_auto_upgrade_user_level',
			'type'     => 'switch',
			'title'    => __( 'Automatically upgrade levels', 'wpjobster' ),
			'subtitle' => __( 'Do you want to automatically upgrade the levels?', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_auto_downgrade_user_level',
			'type'     => 'switch',
			'title'    => __( 'Automatically downgrade levels', 'wpjobster' ),
			'subtitle' => __( 'Do you want to automatically downgrade the levels?', 'wpjobster' ),
			'default'  => true,
		),

/* ELIGIBILITY */
		array(
			'id'       => 'level-eligibility-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Eligibility Settings', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_level0_recheck_interval',
			'type'     => 'text',
			'title'    => __( 'Recheck period for upgrade (months)', 'wpjobster' ),
			'desc'     => __( 'Level 0', 'wpjobster' ),
			'subtitle' => __( 'How often should we check again if user levels need to be updated?', 'wpjobster' ),
			'default'  => 1,
		),
		array(
			'id'       => 'wpjobster_level1_recheck_interval',
			'type'     => 'text',
			'title'    => '',
			'desc'     => __( 'Level 1', 'wpjobster' ),
			'default'  => 1,
		),
		array(
			'id'       => 'wpjobster_level2_recheck_interval',
			'type'     => 'text',
			'title'    => '',
			'desc'     => __( 'Level 2', 'wpjobster' ),
			'default'  => 2,
		),
		array(
			'id'       => 'wpjobster_level1_min',
			'type'     => 'text',
			'title'    => sprintf( __( 'Required amount for upgrade (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'desc'     => __( 'Level 1', 'wpjobster' ),
			'subtitle' => __( 'The minumum amount the user should have sold in the previous month.', 'wpjobster' ),
			'default'  => 50,
		),
		array(
			'id'       => 'wpjobster_level2_min',
			'type'     => 'text',
			'title'    => '',
			'desc'     => __( 'Level 2', 'wpjobster' ),
			'default'  => 200,
		),
		array(
			'id'       => 'wpjobster_level1_upgrade_rating',
			'type'     => 'text',
			'title'    => __( 'Required ratings for upgrade (%)', 'wpjobster' ),
			'desc'     => __( 'Level 1', 'wpjobster' ),
			'subtitle' => __( 'Percentage of rating needed in order to upgrade the level.', 'wpjobster' ),
			'default'  => 90,
		),
		array(
			'id'       => 'wpjobster_level2_upgrade_rating',
			'type'     => 'text',
			'title'    => '',
			'desc'     => __( 'Level 2', 'wpjobster' ),
			'default'  => 95
		),
	)
);