<?php // General Settings

ob_start( ); do_action( 'wpjobster_display_license_status_text' );
$license_status = ob_get_contents(); ob_end_clean();

ob_start( ); do_action( 'wpjobster_display_license_action_button' );
$license_action = ob_get_contents(); ob_end_clean();

$general_settings_array = array(
	'title'  => __( 'General Settings', 'wpjobster' ),
	'id'     => 'general-main-settings',
	'icon'   => 'el el-home',
	'fields' => array(
		array(
			'id'       => 'wpjobster_enable_beta_versions',
			'type'     => 'switch',
			'title'    => __( 'Beta versions', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option will opt you in to receive pre-release update notifications. You can opt-out at any time. Pre-release updates do not install automatically, you will still have the opportunity to ignore update notifications.', 'wpjobster' ),
			'desc'     => __( 'Recommended only for development installations. Won\'t install automatically.', 'wpjobster' ),
			'default'  => false,
		),

/* KEYS */
		array(
			'id'       => 'keys-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Keys', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_license_key',
			'type'     => 'text',
			'title'    => __( 'Theme license key', 'wpjobster' ),
			'subtitle' => $license_status ? $license_status : __( 'The license key you find in your WPJobster account.', 'wpjobster' ),
			'default'  => get_option( 'wpjobster_license_key' )
		),
		array(
			'id'         => 'wpjobster_license_key_action',
			'type'       => 'raw',
			'title'      => __( 'Activate or Deactivate license key', 'wpjobster' ),
			'subtitle'   => __( 'Save the license before pressing the activation button.', 'wpjobster' ),
			'full_width' => false,
			'content'    => $license_action,
			'required'   => array( 'wpjobster_license_key', '!=', '' )
		),
		array(
			'id'       => 'openexchangerates_appid',
			'type'     => 'text',
			'title'    => __( 'OpenExchange app ID', 'wpjobster' ),
			'subtitle' => __( 'If you don\'t have one, please visit openexchangerates.org and sign up for any of the plans. The smallest plan is good enough as long as it offers at least 100 API Requests per month.', 'wpjobster' ),
			'desc'     => '<a href="https://openexchangerates.org/signup/free" target="_blank">' . __( 'Sign Up for a free Open Exchange Rates account', 'wpjobster' ) . '</a>'
		),
		array(
			'id'       => 'wpjobster_google_maps_api_key',
			'type'     => 'text',
			'title'    => __( 'Google places API key', 'wpjobster' ),
			'subtitle' => __( 'Needed for the Google Maps on the site. If you don\'t use job locations/maps or have very few visitors, it is not required.', 'wpjobster' ),
			'desc'     => '<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">' . __( 'Register a free API Key here', 'wpjobster' ) . '</a>'
		),
		array(
			'id'       => 'wpjobster_tomtom_search_api_key',
			'type'     => 'text',
			'title'    => __( 'TomTom search API key', 'wpjobster' ),
			'subtitle' => __( 'Needed for the TomTom Search Locations on the site. If you don\'t use job locations and TomTom as API provider it is not required.', 'wpjobster' ),
			'desc'     => '<a href="https://developer.tomtom.com/search-api" target="_blank">' . __( 'Register a free API Key here', 'wpjobster' ) . '</a>'
		),
		array(
			'id'       => 'wpjobster_ip_key_db',
			'type'     => 'text',
			'title'    => __( 'IPI info DB key', 'wpjobster' ),
			'subtitle' => __( 'Needed for the country detection for new users registering on the site. If empty, the country may not be filled automatically by IP.', 'wpjobster' ),
			'desc'     => '<a href="https://www.ipinfodb.com/register" target="_blank">' . __( 'Register a free API Key here', 'wpjobster' ) . '</a>'
		),
		array(
			'id'       => 'wpjobster_recaptcha_api_key',
			'type'     => 'text',
			'title'    => __( 'reCAPTCHA v2 API key', 'wpjobster' ),
			'subtitle' => __( 'It is required for authentication and registration with google reCaptcha verification, if this option is enabled.', 'wpjobster' ),
			'desc'     => '<a href="https://www.google.com/recaptcha/admin#list" target="_blank">' . __( 'Register a free API Key here', 'wpjobster' ) . '</a>'
		),
		array(
			'id'       => 'wpjobster_recaptcha_api_secret',
			'type'     => 'text',
			'title'    => __( 'reCAPTCHA v2 API secret', 'wpjobster' ),
			'subtitle' => __( 'It is required for authentication and registration with google reCaptcha verification, if this option is enabled.', 'wpjobster' ),
			'desc'     => '<a href="https://www.google.com/recaptcha/admin#list" target="_blank">' . __( 'Register a free API Key here', 'wpjobster' ) . '</a>'
		),

/* DISPLAY */
		array(
			'id'       => 'display-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Display', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_jobs_order',
			'type'     => 'select',
			'title'    => __( 'Job listing order', 'wpjobster' ),
			'subtitle' => __( 'This is the automatic sort type, when the page has no sort type (like homepage) or nothing is selected by the user.', 'wpjobster' ),
			'options'  => array(
				'new'  => __( 'Newest First', 'wpjobster' ),
				'old'  => __( 'Oldest First', 'wpjobster' ),
				'rand' => __( 'Random', 'wpjobster' )
			)
		),
		array(
			'id'       => 'wpj_posts_load_type',
			'type'     => 'select',
			'title'    => __( 'Posts load type', 'wpjobster' ),
			'options'  => array(
				'load_more'  => __( 'Load more button', 'wpjobster' ),
				'pagination' => __( 'Pagination', 'wpjobster' )
			),
			'default'  => 'load_more'
		),
		array(
			'id'       => 'wpjobster_enable_auto-load',
			'type'     => 'switch',
			'title'    => __( 'Enable auto-load posts', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option will automatically load more posts without the user having to press the \'Load more\' button.', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpj_posts_load_type', '=', 'load_more' )
		),

/* ATTACHMENTS */
		array(
			'id'       => 'attachments-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Attachments', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_max_attachment_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max attachments file size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 50,
		),
		array(
			'id'       => 'wpjobster_allowed_mime_types',
			'type'     => 'textarea',
			'title'    => __( 'Allowed Mime-types', 'wpjobster' ),
			'subtitle' => __( 'Enter the file formats that you accept from users. They will be separated by a comma.', 'wpjobster' ),
			'default'  => 'zip,rar,jpg,png,psd,gif,jpeg,ai,cdr,eps,txt,pdf,doc,docx,ppt,pptx,pps,ppsx,odt,xls,xlsx,mp3,m4a,ogg,wav,mp4,m4v,mov,wmv,avi,mpg,ogv,dwg,svg',
		),

/* LOCATION */
		array(
			'id'       => 'location-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Location', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_html5_geolocation_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable browser location prompt', 'wpjobster' ),
			'subtitle' => __( 'When enabled, the user will be prompted to allow geolocation detection and location inputs will be prefilled automatically.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpj_locations_radius_default',
			'type'     => 'text',
			'title'    => __( 'Location radius default', 'wpjobster' ),
			'subtitle' => __( 'Fill this with your average city size in mind.', 'wpjobster' ),
			'default'  => 10,
		),
		array(
			'id'       => 'wpjobster_locations_unit',
			'type'     => 'select',
			'title'    => __( 'Location radius unit', 'wpjobster' ),
			'subtitle' => __( 'It will determine if the distance will be calculated in kilometers or miles.', 'wpjobster' ),
			'options'  => array(
				'kilometers' => __( 'kilometers', 'wpjobster' ),
				'miles'      => __( 'miles', 'wpjobster' )
			),
			'default'  => 'kilometers',
		),
		array(
			'id'       => 'wpjobster_location_api_provider',
			'type'     => 'select',
			'title'    => __( 'Location autocomplete API', 'wpjobster' ),
			'options'  => array(
				'google' => __( 'Google', 'wpjobster' ),
				'tomtom' => __( 'TomTom', 'wpjobster' )
			),
			'default'  => 'google',
		),
		array(
			'id'       => 'wpjobster_location_restrict_type',
			'type'     => 'select',
			'title'    => __( 'Location Autocomplete Type', 'wpjobster' ),
			'subtitle' => __( 'Cities will autocomplete only city names, Regions also includes locality, sublocality, postal code, country and Geocode includes almost everything but not business names.', 'wpjobster' ),
			'desc'     => '<a href="https://developers.google.com/places/web-service/autocomplete#place_types" target="_blank">' . __( 'Learn more about Google Place Type', 'wpjobster' ) . '</a>',
			'options'  => array(
				'(cities)'  => __( 'Cities', 'wpjobster' ),
				'(regions)' => __( 'Regions', 'wpjobster' ),
				'geocode'   => __( 'Geocode', 'wpjobster' )
			),
			'default'  => '(cities)',
		),
		array(
			'id'       => 'wpjobster_location_restrict_country',
			'type'     => 'text',
			'title'    => __( 'Location Autocomplete Country Restriction', 'wpjobster' ),
			'subtitle' => __( 'Comma-separated list of ISO country codes to restrict the location autocomplete within. Empty means no restriction.', 'wpjobster' ),
			'desc'     => __( 'Example: <code>US, AU, CA, DE, FR, ES</code>', 'wpjobster' )
		),
		array(
			'id'       => 'wpjobster_location_fields',
			'type'     => 'text',
			'title'    => __( 'Location Autocomplete Fields', 'wpjobster' ),
			'subtitle' => __( 'Comma-separated list of returned fields. Empty means all.', 'wpjobster' ),
			'desc'     => __( 'Example: <code>address_component, adr_address, formatted_address, geometry, icon</code>', 'wpjobster' )
		),
	)
);