<?php // Order Settings

$general_order_settings_array = array(
	'title'      => __( 'Order', 'wpjobster' ),
	'desc'       => __( 'Order Settings', 'wpjobster' ),
	'id'         => 'order-settings',
	'subsection' => true,
	'fields'     => array(

/* FEATURES */
		array(
			'id'       => 'order-features-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Features', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_custom_extras',
			'type'     => 'switch',
			'title'    => __( 'Enable custom extras', 'wpjobster' ),
			'subtitle' => __( 'This will add the possibility for buyers to purchase additional job extras during an ongoing/live transaction', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'custom_extras' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_enable_custom_offers',
			'type'     => 'switch',
			'title'    => __( 'Enable custom offers', 'wpjobster' ),
			'subtitle' => __( 'It allows buyers to ask and sellers to offer customized offers in terms of price and delivery time.', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'custom_offers' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_active_job_cutom_offer',
			'type'     => 'switch',
			'title'    => __( 'Send custom offer conditionally', 'wpjobster' ),
			'subtitle' => __( 'Enable this option if users must have at least one active job to submit a custom offer.', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_custom_offers', '=', true ),
			'default'  => true,
			'disabled' => ! wpj_is_allowed( 'custom_offers' ) ? true : false,
		),

/* SETTINGS */
		array(
			'id'       => 'transaction-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Transaction Settings', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_seller_order_rejection_enable',
			'type'     => 'switch',
			'title'    => __( 'Require seller to confirm order', 'wpjobster' ),
			'subtitle' => __( 'Seller is given 24 hours window to accept or cancel the order, otherwise the order will be automatically cancelled and the buyer refunded.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_seller_order_unresponsive_label',
			'type'     => 'switch',
			'title'    => __( 'Show "Unresponsive" label', 'wpjobster' ),
			'subtitle' => __( 'This option, if activated, for sellers who do not answer whether or not to accept the order, will appear next to their name, a label called "Unresponsive", and when hovering on this label, will appear the number of jobs they do not have answer.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_seller_order_rejection_number',
			'type'     => 'text',
			'title'    => __( 'Number of unanswered orders for \'Unresponsive\' label', 'wpjobster' ),
			'subtitle' => __( 'Number of orders left unanswered until the \'Unresponsive\' label appears on the user profile page.', 'wpjobster' ),
			'required' => array( 'wpjobster_seller_order_rejection_enable', '=', true ),
			'default'  => 1,
		),
		array(
			'id'       => 'wpjobster_pending_jobs_days',
			'type'     => 'text',
			'title'    => __( 'Auto-close pending payment', 'wpjobster' ),
			'subtitle' => __( 'How many days should the buyer be able to try again the payment for a pending payment job transaction?', 'wpjobster' ),
			'default'  => 7,
		),
		array(
			'id'       => 'wpjobster_max_time_to_wait',
			'type'     => 'text',
			'title'    => __( 'Auto-mark transaction as completed', 'wpjobster' ),
			'subtitle' => __( 'The number of hours that need to pass from the delivery of the order until the order is automatically marked as completed if the buyer does not mark the order as complete.', 'wpjobster' ),
			'default'  => 72,
		),
		array(
			'id'       => 'wpjobster_clearing_period',
			'type'     => 'text',
			'title'    => __( 'Clearing Period', 'wpjobster' ),
			'subtitle' => __( 'The number of days that need to pass until the seller is credited with the money for the job he completed.', 'wpjobster' ),
			'default'  => 3,
		),
		array(
			'id'       => 'wpjobster_number_of_modifications',
			'type'     => 'text',
			'title'    => __( 'Maximum number of modifications', 'wpjobster' ),
			'subtitle' => __( 'Limit how many times users can request modifications for a particular transaction', 'wpjobster' ),
			'default'  => 5,
		),
		array(
			'id'       => 'wpjobster_number_of_cancellations',
			'type'     => 'text',
			'title'    => __( 'Maximum number of cancellations', 'wpjobster' ),
			'subtitle' => __( 'Limit how many times users can request cancellation for a particular transaction', 'wpjobster' ),
			'default'  => 5,
		),
		array(
			'id'       => 'wpjobster_set_time_direction',
			'type'     => 'select',
			'title'    => __( 'Transaction clock direction', 'wpjobster' ),
			'subtitle' => __( 'Reverses the direction of the countdown timer on the transaction page. Applies to RTL languages only.', 'wpjobster' ),
			'options'  => array(
				'ltr' => __( 'LTR', 'wpjobster' ),
				'rtl' => __( 'RTL', 'wpjobster' )
			),
			'default'  => 'ltr',
		),
		array(
			'id'       => 'wpjobster_stop_transaction_clock',
			'type'     => 'select',
			'title'    => __( 'Stop transaction clock', 'wpjobster' ),
			'subtitle' => __( 'Choose when the clock on the transaction page should stop and hide.', 'wpjobster' ),
			'options'  => array(
				'delivered' => __( 'After seller mark the order as delivered', 'wpjobster' ),
				'completed' => __( 'After buyer mark the order as completed', 'wpjobster' )
			),
			'default'  => 'completed',
		),
	)
);