<?php // Request Settings

$general_request_settings_array = array(
	'title'      => __( 'Request', 'wpjobster' ),
	'desc'       => __( 'Request Settings', 'wpjobster' ),
	'id'         => 'request-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_admin_approve_request',
			'type'     => 'switch',
			'title'    => __( 'Admin approves each request', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option, the administrator will check and approve each posted request before it is made public.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_instructions_responsive_enabled',
			'type'     => 'switch',
			'title'    => __( 'Display responsive tooltip instructions:', 'wpjobster' ),
			'subtitle' => __( 'If this option is enabled, instructions will be displayed on the new job posting page for mobile and tablet devices.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_default_sort_by_request',
			'type'     => 'select',
			'title'    => __( 'Default requests listing order', 'wpjobster' ),
			'subtitle' => __( 'Here you can choose which sort type to be selected by default for pages where the user can choose (like category or search).', 'wpjobster' ),
			'options'  => array(
				'auto'     => __( 'Auto', 'wpjobster' ),
				'new'      => __( 'Newest', 'wpjobster' ),
				'old'      => __( 'Oldest', 'wpjobster' ),
				'distance' => __( 'Distance', 'wpjobster' )
			),
			'default'  => 'auto',
		),

/* CATEGORIES */
		array(
			'id'       => 'request-categories-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Categories', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_display_request_empty_categories',
			'type'     => 'switch',
			'title'    => __( 'Display empty categories', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option, categories without requests will appear in the category list.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_display_request_multiple_categories',
			'type'     => 'switch',
			'title'    => __( 'Enable multiple categories', 'wpjobster' ),
			'subtitle' => __( 'Enabling this option, users will be able to select multiple categories for a specific request.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_display_request_category_description',
			'type'     => 'select',
			'title'    => __( 'Display category description', 'wpjobster' ),
			'subtitle' => __( 'Show or not the description of the category on the category page.', 'wpjobster' ),
			'options'  => array(
				'yes'                    => __( 'Yes', 'wpjobster' ),
				'only_for_categories'    => __( 'Only for categories', 'wpjobster' ),
				'only_for_subcategories' => __( 'Only for subcategories', 'wpjobster' ),
				'no'                     => __( 'No', 'wpjobster' ),
			),
			'default'  => 'yes',
		),

/* PRICE */
		array(
			'id'       => 'request-price-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Price', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_request_budget',
			'type'     => 'switch',
			'title'    => __( 'Enable budget', 'wpjobster' ),
			'subtitle' => __( 'This will allow users to set a budget for their requests.', 'wpjobster' ),
			'default'  => false,
		),

/* DELIVERY */
		array(
			'id'       => 'request-delivery-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Delivery', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_request_max_deliv',
			'type'     => 'switch',
			'title'    => __( 'Enable expected delivery', 'wpjobster' ),
			'subtitle' => __( 'If disabled, the user won\'t be able to choose expected delivery time for his request.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_max_delivery_days',
			'type'     => 'text',
			'title'    => __( 'Max delivery days', 'wpjobster' ),
			'subtitle' => __( 'The maximum number allowed for choosing the delivery time.', 'wpjobster' ),
			'required' => array( 'wpjobster_request_max_deliv', '=', true ),
			'default'  => 30,
		),

/* DATE */
		array(
			'id'       => 'request-date-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Date', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_request_deadline',
			'type'     => 'switch',
			'title'    => __( 'Enable deadline', 'wpjobster' ),
			'subtitle' => __( 'If disabled, the user won\'t be able to choose a deadline for his request.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_date',
			'type'     => 'switch',
			'title'    => __( 'Enable date', 'wpjobster' ),
			'subtitle' => __( 'Buyer can select the date for a request where he needs to meet the seller.', 'wpjobster' ),
			'default'  => false,
		),


/* LOCATION */
		array(
			'id'       => 'request-location-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Location', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_request_lets_meet',
			'type'     => 'switch',
			'title'    => __( 'Enable let\'s meet', 'wpjobster' ),
			'subtitle' => __( 'Requests where the users need to meet in person.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_location',
			'type'     => 'switch',
			'title'    => __( 'Enable locations', 'wpjobster' ),
			'subtitle' => __( 'Enable locations for requests', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_pick_up_location',
			'type'     => 'switch',
			'title'    => __( 'Enable pick up location', 'wpjobster' ),
			'subtitle' => __( 'Enable pick up location for requests', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_drop_off_location',
			'type'     => 'switch',
			'title'    => __( 'Enable drop off location', 'wpjobster' ),
			'subtitle' => __( 'Enable drop off location for requests', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_request_location_display_map',
			'type'     => 'switch',
			'title'    => __( 'Enable location google map', 'wpjobster' ),
			'subtitle' => __( 'The map will be displayed on each request, under the description.', 'wpjobster' ),
			'default'  => false,
		),

/* ATTACHMENTS */
		array(
			'id'       => 'request-attachments-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Attachments', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_request_file_upload',
			'type'     => 'switch',
			'title'    => __( 'Enable file upload', 'wpjobster' ),
			'subtitle' => __( 'Allow your users to upload sample files for their request, downloadable by everyone from the request page.', 'wpjobster' ),
			'default'  => false,
		)

	)
);