<?php // Search Settings

$general_search_settings_array = array(
	'title'      => __( 'Search', 'wpjobster' ),
	'desc'       => __( 'Search Settings', 'wpjobster' ),
	'id'         => 'search-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_enable_user_account_search',
			'type'     => 'switch',
			'title'    => __( 'Enable search form for user account pages', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_default_advanced_search',
			'type'     => 'select',
			'title'    => __( 'Default search', 'wpjobster' ),
			'options'  => array(
				'jobs'     => __( 'Jobs', 'wpjobster' ),
				'requests' => __( 'Requests', 'wpjobster' ),
				'users'    => __( 'Users', 'wpjobster' )
			),
			'default'  => 'jobs',
		),

/* JOB */
		array(
			'id'       => 'search-job-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Job', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_jobs_for_advanced_search',
			'type'     => 'switch',
			'title'    => __( 'Live search for jobs', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_include_job_undefined_delivery',
			'type'     => 'select',
			'title'    => __( 'Include undefined delivery', 'wpjobster' ),
			'options'  => array(
				'always'    => __( 'Always', 'wpjobster' ),
				'ifchecked' => __( 'If User Checked Let\'s Meet', 'wpjobster' ),
				'never'     => __( 'Never', 'wpjobster' )
			),
			'default'  => 'never'
		),

/* REQUEST */
		array(
			'id'       => 'search-request-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Request', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_requests_for_advanced_search',
			'type'     => 'switch',
			'title'    => __( 'Live search for requests', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_search_request_date',
			'type'     => 'switch',
			'title'    => __( 'Date filter', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_include_request_undefined_date',
			'type'     => 'select',
			'title'    => __( 'Include undefined date', 'wpjobster' ),
			'options'  => array(
				'always'    => __( 'Always', 'wpjobster' ),
				'ifchecked' => __( 'If User Checked Let\'s Meet', 'wpjobster' ),
				'never'     => __( 'Never', 'wpjobster' )
			),
			'default'  => 'ifchecked'
		),
		array(
			'id'       => 'wpjobster_include_request_undefined_budget',
			'type'     => 'select',
			'title'    => __( 'Include undefined budget', 'wpjobster' ),
			'options'  => array(
				'always'    => __( 'Always', 'wpjobster' ),
				'ifchecked' => __( 'If User Checked Let\'s Meet', 'wpjobster' ),
				'never'     => __( 'Never', 'wpjobster' )
			),
			'default'  => 'ifchecked'
		),
		array(
			'id'       => 'wpjobster_include_request_undefined_delivery',
			'type'     => 'select',
			'title'    => __( 'Include undefined delivery', 'wpjobster' ),
			'options'  => array(
				'always'    => __( 'Always', 'wpjobster' ),
				'ifchecked' => __( 'If User Checked Let\'s Meet', 'wpjobster' ),
				'never'     => __( 'Never', 'wpjobster' )
			),
			'default'  => 'ifchecked'
		),

/* User */
		array(
			'id'       => 'search-user-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'User', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_users_for_advanced_search',
			'type'     => 'switch',
			'title'    => __( 'Live search for users', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_search_user_location',
			'type'     => 'switch',
			'title'    => __( 'Location filter', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_search_user_skills',
			'type'     => 'switch',
			'title'    => __( 'Skills filter', 'wpjobster' ),
			'default'  => true,
		),
	)
);