<?php // User Settings

$general_user_settings_array = array(
	'title'      => __( 'User', 'wpjobster' ),
	'desc'       => __( 'User Settings', 'wpjobster' ),
	'id'         => 'user-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_display_name_publicly',
			'type'     => 'select',
			'title'    => __( 'Display name publicly as', 'wpjobster' ),
			'options'  => array(
				'username'        => __( 'Username', 'wpjobster' ),
				'first_name'      => __( 'First name', 'wpjobster' ),
				'last_name'       => __( 'Last name', 'wpjobster' ),
				'display_name'    => __( 'Display name', 'wpjobster' ),
				'first_last_name' => __( 'First Last name', 'wpjobster' ),
				'last_first_name' => __( 'Last First name', 'wpjobster' )
			),
			'default'  => 'username',
		),
		array(
			'id'       => 'wpjobster_default_sort_by_user',
			'type'     => 'select',
			'title'    => __( 'Default users listing order', 'wpjobster' ),
			'subtitle' => __( 'Here you can choose which sort type to be selected by default for pages where the user can choose (like category or search).', 'wpjobster' ),
			'options'  => array(
				'auto'   => __( 'Auto', 'wpjobster' ),
				'new'    => __( 'Newest', 'wpjobster' ),
				'old'    => __( 'Oldest', 'wpjobster' ),
				'rating' => __( 'Rating', 'wpjobster' ),
				'sales'  => __( 'Sales number', 'wpjobster' )
			),
			'default'  => 'auto',
		),

/* FEATURES */
		array(
			'id'       => 'user-features-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Features', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_wysiwyg_for_profile',
			'type'     => 'switch',
			'title'    => __( 'Allow WYSIWYG editor for description', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_last_seen',
			'type'     => 'switch',
			'title'    => __( 'Enable last seen on user page', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_user_social_media',
			'type'     => 'switch',
			'title'    => __( 'Enable social media links on user page', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_jobs_section_on_user_profile',
			'type'     => 'switch',
			'title'    => __( 'Enable jobs section on user page', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_user_vat_id',
			'type'     => 'switch',
			'title'    => __( 'Enable user Tax/VAT ID', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_enable_user_transactions_export',
			'type'     => 'switch',
			'title'    => __( 'Enable transactions export', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_en_user_online_status',
			'type'     => 'select',
			'title'    => __( 'Enable user online status', 'wpjobster' ),
			'options'  => array(
				'yes_with_text' => __( 'Yes, with text', 'wpjobster' ),
				'yes_with_icon' => __( 'Yes, with icon', 'wpjobster'),
				'no'            => __( 'No', 'wpjobster' )
			),
			'default'  => 'yes_with_text',
		),

/* Images */
		array(
			'id'       => 'user-images-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Images', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_user_cover',
			'type'     => 'switch',
			'title'    => __( 'Enable cover image for users', 'wpjobster' ),
			'subtitle' => __( 'Allows users to upload a cover image for their profile', 'wpjobster' ),
			'default'  => true
		),
		array(
			'id'       => 'wpjobster_max_user_cover_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max cover upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 10,
			'required' => array( 'wpjobster_enable_user_cover', '=', true )
		),
		array(
			'id'       => 'wpjobster_max_user_avatar_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max avatar upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 10,
		),
		array(
			'id'       => 'wpjobster_max_user_skill_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max skill upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 10,
		),

/* PORTFOLIO */
		array(
			'id'       => 'user-portfolio-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Portfolio', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_user_profile_portfolio',
			'type'     => 'switch',
			'title'    => __( 'Enable user portfolio', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_portfolio_video_upload',
			'type'     => 'switch',
			'title'    => __( 'Allow video upload', 'wpjobster' ),
			'subtitle' => __( 'Allow users to upload videos to their portfolio', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpjobster_enable_user_profile_portfolio', '=', true )
		),
		array(
			'id'       => 'wpjobster_profile_default_nr_of_pics',
			'type'     => 'text',
			'title'    => __( 'Max amount of pictures', 'wpjobster' ),
			'subtitle' => __( 'Maximum number of uploaded images per user', 'wpjobster' ),
			'default'  => 10,
			'required' => array( 'wpjobster_enable_user_profile_portfolio', '=', true )
		),
		array(
			'id'       => 'wpjobster_profile_max_img_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max image upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 10,
			'required' => array( 'wpjobster_enable_user_profile_portfolio', '=', true )
		),
		array(
			'id'       => 'wpjobster_profile_min_img_upload_width',
			'type'     => 'text',
			'title'    => __( 'Min image upload width', 'wpjobster' ),
			'subtitle' => __( 'in PX', 'wpjobster' ),
			'default'  => 720,
			'required' => array( 'wpjobster_enable_user_profile_portfolio', '=', true )
		),
		array(
			'id'       => 'wpjobster_profile_min_img_upload_height',
			'type'     => 'text',
			'title'    => __( 'Min image upload height', 'wpjobster' ),
			'subtitle' => __( 'in PX', 'wpjobster' ),
			'default'  => 405,
			'required' => array( 'wpjobster_enable_user_profile_portfolio', '=', true )
		),

/* COUNTRY & TIMEZONE */
		array(
			'id'       => 'user-country-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Country & Timezone', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_en_country_flags',
			'type'     => 'switch',
			'title'    => __( 'Enable country flags', 'wpjobster' ),
			'subtitle' => __( 'Display country flag on profile page and job pages, based on the country selected by the user.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'          => 'wpjobster_phone_country_select',
			'type'        => 'select',
			'title'       => __( 'Default country flag for phone number', 'wpjobster' ),
			'description' => __( 'If you chose the <b>Autodetect</b> option, make sure you have completed the <b>IPI info DB key</b> field in <b>General Settings</b>.', 'wpjobster' ),
			'options'     => array_merge( array( 'autodetect' => __( 'Autodetect', 'wpjobster' ) ), wpj_get_country_name_by_code() ),
			'default'     => 'US',
		),
		array(
			'id'       => 'wpjobster_enable_country_select',
			'type'     => 'switch',
			'title'    => __( 'Enable user country select', 'wpjobster' ),
			'subtitle' => __( 'Let the users choose their country, even after filling it automatically by IP.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'          => 'wpjobster_user_time_zone',
			'type'        => 'select',
			'title'       => __( 'Default user time zone', 'wpjobster' ),
			'description' => __( 'If you chose the <b>Autodetect</b> option, make sure you have completed the <b>IPI info DB key</b> field in <b>General Settings</b>.', 'wpjobster' ),
			'options'     => array_merge( array( 'autodetect' => __( 'Autodetect', 'wpjobster' ) ), wpj_get_timezone_by_name() ),
			'default'     => 'autodetect'
		),

/* STATS */
		array(
			'id'       => 'user-stats-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Stats', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_user_stats',
			'type'     => 'switch',
			'title'    => __( 'Enable user stats bar', 'wpjobster' ),
			'subtitle' => __( 'Enable or disable the basic user stats bar on my account, sales and shopping pages.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_enable_user_charts',
			'type'     => 'switch',
			'title'    => __( 'Enable user stats charts', 'wpjobster' ),
			'subtitle' => __( 'Enable the advanced user stats charts. User stats bar needs to be active.', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_enable_user_stats', '=', true )
		),
		array(
			'id'            => 'wpj_order_response_rate_stats_percent',
			'type'          => 'slider',
			'title'         => esc_html__( 'Order response rate stats percent', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set to 0 or 100, the order response rate when a user has no data (new account for example)', 'wpjobster' ),
			'default'       => 100,
			'min'           => 0,
			'step'          => 100,
			'max'           => 100,
			'display_value' => 'text',
			'handles'       => 1
		),
		array(
			'id'            => 'wpj_delivered_on_time_stats_percent',
			'type'          => 'slider',
			'title'         => esc_html__( 'Delivered on time stats percent', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set to 0 or 100, the delivered on time when a user has no data (new account for example)', 'wpjobster' ),
			'default'       => 100,
			'min'           => 0,
			'step'          => 100,
			'max'           => 100,
			'display_value' => 'text',
			'handles'       => 1
		),
		array(
			'id'            => 'wpj_order_completion_stats_percent',
			'type'          => 'slider',
			'title'         => esc_html__( 'Order completion stats percent', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set to 0 or 100, the order completion when a user has no data (new account for example)', 'wpjobster' ),
			'default'       => 100,
			'min'           => 0,
			'step'          => 100,
			'max'           => 100,
			'display_value' => 'text',
			'handles'       => 1
		),

/* REVIEWS */
		array(
			'id'       => 'user-review-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Reviews', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_user_min_rating',
			'type'     => 'text',
			'title'    => __( 'Min rating number', 'wpjobster' ),
			'subtitle' => __( 'The minimum number of reviews to display the user rating.', 'wpjobster' ),
			'default'  => 3,
		),
	)
);