<?php // Info

$info_settings_array = array(
	'title'      => __( 'Information', 'wpjobster' ),
	'icon'       => 'el el-info-circle',
	'id'         => 'information',
	'fields'     => array(
		array(
			'id'    => 'wpj-version',
			'type'  => 'info',
			'style' => 'custom',
			'color' => '#47697E',
			'title' => __( 'WPJobster Version', 'wpjobster' ),
			'desc'  => wpjobster_VERSION
		),
		array(
			'id'    => 'wpj-license-type',
			'type'  => 'info',
			'style' => 'custom',
			'color' => '#688B9A',
			'title' => __( 'WPJobster License Type', 'wpjobster' ),
			'desc'  => wpj_get_license_name() . ( wpj_loop_check() && wpj_loop_check() < 3 ? '<a href="https://wpjobster.com/buy/" target="_blank">Upgrade?</a>' : '' )
		),
		array(
			'id'    => 'wpj-license-status',
			'type'  => 'info',
			'style' => 'custom',
			'color' => '#5B7444',
			'title' => __( 'WPJobster License Status', 'wpjobster' ),
			'desc'  => get_transient( get_template() . '_license_message' )
		),
		array(
			'id'    => 'wpj-latest-release',
			'type'  => 'info',
			'style' => 'custom',
			'color' => '#A3C586',
			'title' => __( 'WPJobster Latest Release', 'wpjobster' ),
			'desc'  => wpjobster_RELEASE
		),
		array(
			'id'    => 'wp-version',
			'type'  => 'info',
			'style' => 'custom',
			'color' => '#FFCC33',
			'title' => __( 'WordPress Version', 'wpjobster' ),
			'desc'  => get_bloginfo( 'version' )
		),
		array(
			'id'    => 'php-version',
			'type'  => 'info',
			'style' => 'custom',
			'color' => '#FCF1D1',
			'title' => __( 'PHP Version', 'wpjobster' ),
			'desc'  => phpversion()
		),
	)
);