<?php // Settings Map

ob_start( );

$sections = Redux::construct_sections( $opt_name );
if ( $sections ) {

	echo '<ul>';

		foreach ( $sections as $s_key => $section ) {

			echo '<li>';

				if ( ! isset( $section['subsection'] ) ) echo '<h3 class="site-map-list-section">';
				else echo '<h4 class="site-map-list-subsection"><span class="dashicons dashicons-arrow-right"></span>';

					echo $section['title'];

				if ( ! isset( $section['subsection'] ) ) echo '</h3>';
				else echo '</h4>';

				$fields = Redux::construct_fields( $opt_name, $section['id'] );

				if ( $fields && $section['id'] != '1updater-settings' && $section['id'] != 'changelog' ) {

					echo '<ul class="site-map-list">';

						foreach ( $fields as $f_key => $field ) {

							if ( isset( $field['title'] ) && $field['type'] != 'info' ) {

								echo '<li class="' . ( isset( $field['indent'] ) ? 'site-map-list-subsection-indent' : '' ) . '">';

									if ( isset( $field['indent'] ) ) echo '<strong>';

										$title = $field['title'];
										if ( ! $title && ! empty( $field['subtitle'] ) ) $title = $field['subtitle'];
										if ( ! $title && ! empty( $field['desc'] ) ) $title = $field['desc'];

										echo sprintf( __( '%s:&nbsp;', 'wpjobster' ), $title );

									if ( isset( $field['indent'] ) ) echo '</strong>';

									$option_value = Redux::get_option( $opt_name, $field['id'] );

									echo '<strong>';

										if ( $field['id'] == 'wpjobster_license_key' )
											echo apply_filters( 'wpj_sensitive_info_credentials', $option_value );

										elseif ( $field['type'] == 'switch' && $option_value == 0 )
											echo _e( 'Disabled', 'wpjobster' );

										elseif ( $field['type'] == 'switch' && $option_value == 1 )
											echo _e( 'Enabled', 'wpjobster' );

										elseif ( is_array( $option_value ) && ! wpj_array_is_multidimensional( $option_value ) )
											echo implode( ', ', $option_value );

										elseif ( is_array( $option_value ) && isset( $option_value[1] ) && isset( $option_value[2] ) && is_numeric( $option_value[1] ) && is_numeric( $option_value[2] ) )
											echo $option_value[1] . ' - ' .  $option_value[2];

										elseif ( ! is_array( $option_value ) && $option_value )
											echo $option_value;

										elseif ( ! isset( $field['indent'] ) )
											echo '-';

									echo '</strong>';

									if ( ! empty( $field['new'] ) ) {
										echo '<img src="' . get_template_directory_uri() . '/assets/images/admin/new.webp" />';
									}

								echo '</li>';

							}
						}

					echo '</ul>';

				}

			echo '</li>';

		}

	echo '</ul>';
}

$settings_map_list = ob_get_clean();

$map_settings_array = array(
	'title'      => __( 'Settings Map', 'wpjobster' ),
	'icon'       => 'el el-cog',
	'id'         => 'settings-map',
	'fields'     => array(
		array(
			'id'       => 'settings-map-list',
			'type'     => 'raw',
			'markdown' => true,
			'content'  => $settings_map_list
		),
	)
);