<?php // Email Languages Settings

$email_language_fields = array(
	array(
		'id'       => 'preferred-languages',
		'type'     => 'section',
		'title'    => esc_html__( 'Preferred Languages', 'wpjobster' ),
		'indent'   => true,
	)
);

for ( $i = 1; $i <= 10; $i++ ) {
	$email_language_fields[] = array(
		'id'      => 'wpjobster_language_' . $i,
		'type'    => 'select',
		'title'   => sprintf( __( 'Preferred language %d', 'wpjobster' ), $i ),
		'options' => wpj_get_language_by_code(),
		'default' => $i == 1 ? 'en' : ''
	);
}

$notify_language_settings_array = array(
	'title'      => __( 'Languages', 'wpjobster' ),
	'desc'       => __( 'Email Languages Settings', 'wpjobster' ),
	'id'         => 'email-languages-settings',
	'subsection' => true,
	'fields'     => $email_language_fields
);