<?php // Notify Settings

$notify_settings_array = array(
	'title'      => __( 'Notify Settings', 'wpjobster' ),
	'desc'       => __( 'Messages & Notifications Settings', 'wpjobster' ),
	'id'         => 'notify-settings',
	'icon'       => 'el el-bullhorn',
	'fields'     => array(

/* FEATURES */
		array(
			'id'       => 'notify-features-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Features', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_live_notifications',
			'type'     => 'switch',
			'title'    => __( 'Enable live notifications', 'wpjobster' ),
			'subtitle' => __( 'When enabled, the notification icons from the header will update automatically without refreshing the whole page.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_chat_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable chat', 'wpjobster' ),
			'subtitle' => __( 'By enabling this option, users will be able to chat on any page of the site', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpjobster_enable_live_notifications', '=', true )
		),
		array(
			'id'       => 'wpjobster_all_users_to_sidebar',
			'type'     => 'switch',
			'title'    => __( 'Display all users to sidebar', 'wpjobster' ),
			'subtitle' => __( 'Up to 50 users listed by last visit to the site/marketplace.', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_chat_enable', '=', true )
		),
		array(
			'id'       => 'wpjobster_message_attachments_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable message attachments', 'wpjobster' ),
			'subtitle' => __( 'By enabling this option, it is allowed to upload attachments for messages between users.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_message_scroll_down_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable message scroll down button', 'wpjobster' ),
			'subtitle' => __( 'By enabling this option, a scroll to last message button will appear on the messages page when scroll bar is up.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_message_image_attachments_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable message image attachments', 'wpjobster' ),
			'subtitle' => __( 'By enabling this option, it is allowed to upload image attachments for messages between users.', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_message_default_nr_of_pics',
			'type'     => 'text',
			'title'    => __( 'Max amount of pictures', 'wpjobster' ),
			'subtitle' => __( 'Maximum number of uploaded images per message', 'wpjobster' ),
			'default'  => 10,
			'required' => array( 'wpjobster_message_image_attachments_enable', '=', true ),
		),
		array(
			'id'       => 'wpjobster_message_max_img_upload_size',
			'type'     => 'text',
			'title'    => __( 'Max image upload size (MB)', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Max allowed value is %sMB', 'wpjobster' ), $post_max_size ),
			'default'  => 10,
			'required' => array( 'wpjobster_message_image_attachments_enable', '=', true )
		),
		array(
			'id'       => 'wpjobster_message_search_results_number',
			'type'     => 'text',
			'title'    => __( 'Search results number', 'wpjobster' ),
			'subtitle' => __( 'The number of results to be displayed before and after the searched message, so that the user can understand the context of the message', 'wpjobster' ),
			'default'  => 2,
		),

/* EMOJI */
		array(
			'id'       => 'notify-emoji-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Emoji', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_pm_emoji_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable emoji on private messages', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_chat_emoji_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable emoji on chat', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_transaction_emoji_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable emoji on transaction messages', 'wpjobster' ),
			'default'  => false,
		),

/* EMAIL */
		array(
			'id'       => 'email-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Email', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_email_name_from',
			'type'     => 'text',
			'title'    => __( 'Email from name', 'wpjobster' )
		),
		array(
			'id'       => 'wpjobster_email_addr_from',
			'type'     => 'text',
			'title'    => __( 'Sender email address', 'wpjobster' )
		),
		array(
			'id'       => 'wpjobster_allow_html_emails',
			'type'     => 'switch',
			'title'    => __( 'Allow HTML in emails', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_verify_email',
			'type'     => 'switch',
			'title'    => __( 'Verify email', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_lock_verify_email_address',
			'type'     => 'switch',
			'title'    => __( 'Lock to MyAccount until e-mail verified', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_locked_allowed_pages',
			'type'     => 'select',
			'data'     => 'pages',
			'multi'    => true,
			'title'    => esc_html__( 'Allowed pages when locked to my account', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose the pages that a user can access until they check their email.', 'wpjobster' ),
			'required' => array( 'wpjobster_lock_verify_email_address', '=', true )
		),
		array(
			'id'       => 'wpj_buyer_cart_notify_number',
			'type'     => 'text',
			'title'    => __( 'Buyer cart notify number', 'wpjobster' ),
			'subtitle' => __( 'The number of reminder emails that will be sent for a job, to buyers who reach the checkout page but do not complete the purchase.', 'wpjobster' ),
			'default'  => 3
		),

/* SMS */
		array(
			'id'       => 'sms-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'SMS', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_sms_admin_numb_from',
			'type'     => 'text',
			'title'    => __( 'SMS admin number', 'wpjobster' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'            => 'wpj_resend_sms_time',
			'type'          => 'slider',
			'title'         => esc_html__( 'Time between resending verification codes', 'wpjobster' ),
			'subtitle'      => esc_html__( 'The time in seconds that the user can request that an SMS be resent.', 'wpjobster' ),
			'desc'          => esc_html__( 'seconds', 'wpjobster' ),
			'default'       => 30,
			'min'           => 0,
			'step'          => 1,
			'max'           => 1800,
			'display_value' => 'text',
			'handles'       => 1,
			'disabled'      => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_verify_phone_numbers',
			'type'     => 'switch',
			'title'    => __( 'Verify phone numbers', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_lock_verify_phone_numbers',
			'type'     => 'switch',
			'title'    => __( 'Lock to MyAccount until phone number verified', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
	)
);