<?php // SMS Gateways

$plugin_gateways = array();
if ( ! empty( wpj_get_sms_payment_gateways() ) ) {
	foreach( wpj_get_sms_payment_gateways() as $index => $gateway ) {
		$plugin_gateways[$gateway['unique_id']] = $gateway['label'];
	}
}

$notify_sms_gateway_settings_array = array(
	'title'      => __( 'SMS Gateways', 'wpjobster' ),
	'desc'       => __( 'SMS Gateways Settings', 'wpjobster' ),
	'id'         => 'sms-gateway-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_sms_gateways_enable',
			'type'     => 'select',
			'title'    => __( 'Preferred SMS gateway', 'wpjobster' ),
			'options'  => array_merge( array(
				'-'      => __( 'Without gateway', 'wpjobster' ),
				'twilio' => __( 'Twilio', 'wpjobster' ),
				'cafe24' => __( 'Cafe24', 'wpjobster' ),
			), $plugin_gateways ),
			'default'  => '-',
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'twilio-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Twilio', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'twilio' ),
			'indent'   => true,
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_twilio_sms_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable SMS messages', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'twilio' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false
		),
		array(
			'id'       => 'wpjobster_twilio_whatsapp_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable WhatsApp messages', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'twilio' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false
		),
		array(
			'id'       => 'wpjobster_theme_accountsid',
			'type'     => 'text',
			'title'    => __( 'Account sid', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'twilio' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_theme_authtoken',
			'type'     => 'text',
			'title'    => __( 'Auth token', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'twilio' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_sms_numb_twilio_from',
			'type'     => 'text',
			'title'    => __( 'SMS from Twilio number', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'twilio' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'cafe24-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Cafe24', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'cafe24' ),
			'indent'   => true,
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_theme_cafe_userid',
			'type'     => 'text',
			'title'    => __( 'User id', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'cafe24' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_theme_cafe_secure',
			'type'     => 'text',
			'title'    => __( 'Certification key', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'cafe24' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_sms_numb_cafe_from',
			'type'     => 'text',
			'title'    => __( 'From number', 'wpjobster' ),
			'required' => array( 'wpjobster_sms_gateways_enable', '=', 'cafe24' ),
			'disabled' => ! wpj_is_allowed( 'sms_notifications' ) ? true : false,
		),
	)
);