<?php // Assignment Settings

$assignment_fields = array(
	array(
		'id'       => 'page-assignments',
		'type'     => 'section',
		'title'    => esc_html__( 'Pages', 'wpjobster' ),
		'indent'   => true,
	)
);

foreach ( wpj_get_page_names() as $option => $name ) {
	if ( strpos( $name, 'Single' ) !== false )
		$page_post = wpj_get_page_by_title( str_replace( 'Single ', '', trim( $name ) ) );

	else
		$page_post = wpj_get_page_by_title( trim( $name ) );

	$assignment_fields[] = array(
		'id'      => $option,
		'type'    => 'select',
		'data'    => 'pages',
		'title'   => $name,
		'desc'    => '<a href="' . admin_url() . 'post.php?post=' . wpj_get_option( $option ) . '&action=edit" target="_blank">' . __( 'Edit page', 'wpjobster' ) . '</a>',
		'default' => ! empty( $page_post->ID ) ? $page_post->ID : ''
	);
}

$page_assignment_settings_array = array(
	'title'      => __( 'Page Assignments', 'wpjobster' ),
	'desc'       => __( 'Page Assignments Settings', 'wpjobster' ),
	'id'         => 'page-assignment-settings',
	'subsection' => true,
	'fields'     => $assignment_fields
);