<?php // Permalink Settings

$page_permalink_settings_array = array(
	'title'      => __( 'Permalinks', 'wpjobster' ),
	'desc'       => __( 'Permalink Settings', 'wpjobster' ),
	'id'         => 'permalink-settings',
	'subsection' => true,
	'fields'     => array(

/* JOBS */

		array(
			'id'       => 'job-permalink-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Jobs', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_jobs_permalink_slug_type',
			'type'     => 'select',
			'title'    => __( 'Slug type for jobs permalink', 'wpjobster' ),
			'options'  => array(
				'subcategory' => __( 'Category', 'wpjobster' ),
				'author'      => __( 'Author\'s username', 'wpjobster' ),
			),
			'default'  => 'subcategory',
		),
		array(
			'id'      => 'wpjobster_category_permalink',
			'type'    => 'text',
			'title'   => __( 'Slug for category permalink', 'wpjobster' ),
			'desc'    => __( '*if left empty will show "job-categories"', 'wpjobster' ),
			'default' => 'job-categories',
		),

/* REQUESTS */

		array(
			'id'       => 'requests-permalink-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Requests', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_requests_permalink_slug_type',
			'type'     => 'select',
			'title'    => __( 'Slug type for request permalink', 'wpjobster' ),
			'options'  => array(
				'subcategory' => __( 'Category', 'wpjobster' ),
				'author'      => __( 'Author\'s username', 'wpjobster' ),
			),
			'default'  => 'subcategory',
		),
		array(
			'id'      => 'wpjobster_requests_category_permalink',
			'type'    => 'text',
			'title'   => __( 'Slug for request category permalink', 'wpjobster' ),
			'desc'    => __( '*if left empty will show "request-categories"', 'wpjobster' ),
			'default' => 'request-categories',
		),

/* NEWS */

		array(
			'id'       => 'news-permalink-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'News', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_news_permalink_slug_type',
			'type'     => 'select',
			'title'    => __( 'Slug type for news permalink', 'wpjobster' ),
			'options'  => array(
				'subcategory' => __( 'Category', 'wpjobster' ),
				'author'      => __( 'Author\'s username', 'wpjobster' ),
			),
			'default'  => 'subcategory',
		),
		array(
			'id'      => 'wpjobster_news_category_permalink',
			'type'    => 'text',
			'title'   => __( 'Slug for news category permalink', 'wpjobster' ),
			'desc'    => __( '*if left empty will show "news-categories"', 'wpjobster' ),
			'default' => 'news-categories',
		)

	)
);