<?php // Bank Transfer Settings

foreach ( wpj_get_payment_types( ['subscription', 'badge'] ) as $key => $payment_type ) {

	$banktransfer_fields[] = array(
		'id'       => 'wpjobster_banktransfer_enable_' . $key,
		'type'     => 'switch',
		'title'    => $payment_type['enable_label'],
		'subtitle' => $payment_type['hint_label'],
		'default'  => false,
	);

}

$payment_gateways_banktransfer_settings_array = array(
	'title'      => __( 'Bank Transfer', 'wpjobster' ),
	'desc'       => __( 'Bank Transfer Settings', 'wpjobster' ),
	'id'         => 'bank-transfer-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(
			array(
				'unique_id' => 'banktransfer-enable-settings-section',
				'type'      => 'section',
				'title'     => esc_html__( 'Enable the gateway', 'wpjobster' ),
				'indent'    => true,
			),
			array(
				'id'       => 'wpjobster_banktransfer_enable',
				'type'     => 'switch',
				'title'    => __( 'Enable bank transfer', 'wpjobster' ),
				'subtitle' => __( 'Enable/Disable bank transfer.', 'wpjobster' ),
				'default'  => false,
			)
		),
		$banktransfer_fields,
		array(
			array(
				'unique_id' => 'banktransfer-settings-section',
				'type'      => 'section',
				'title'     => esc_html__( 'Gateway Settings', 'wpjobster' ),
				'indent'    => true,
			),
			array(
				'id'       => 'wpjobster_bank_details',
				'type'     => 'textarea',
				'title'    => __( 'Bank details', 'wpjobster' ),
				'subtitle' => __( 'Put the bank bank details required.', 'wpjobster' )
			),
			array(
				'id'       => 'wpjobster_bank_currency',
				'type'     => 'select',
				'title'    => __( 'Currency for bank transfer', 'wpjobster' ),
				'default'  => 'USD',
				'options'  => wpj_get_currencies_list(),
				'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false,
			),
			array(
				'id'       => 'banktransfer-gateway-payment-settings-section',
				'type'     => 'section',
				'title'    => esc_html__( 'Payment', 'wpjobster' ),
				'indent'   => true,
			),
			array(
				'id'       => 'wpjobster_banktransfer_button_caption',
				'type'     => 'text',
				'title'    => __( 'Payment button name', 'wpjobster' ),
				'subtitle' => __( 'Put the Bank Transfer button caption you want user to see on purchase page.', 'wpjobster' ),
				'default'  => 'Bank Transfer',
			),
			array(
				'id'       => 'wpjobster_banktransfer_success_page',
				'type'     => 'select',
				'data'     => 'pages',
				'title'    => __( 'Transaction success page', 'wpjobster' ),
				'subtitle' => __( 'Please select a page to show when bank transfer transaction successful and include your bank details in it.', 'wpjobster' ),
				'default'  => ! empty( wpj_get_page_by_title( 'Order' ) ) ? wpj_get_page_by_title( 'Order' )->ID : get_option( 'wpjobster_order_page_id' )
			),
			array(
				'id'       => 'wpjobster_banktransfer_failure_page',
				'type'     => 'select',
				'data'     => 'pages',
				'title'    => __( 'Transaction failure page', 'wpjobster' ),
				'subtitle' => __( 'Please select a page to show when bank transfer transaction failure and include your bank details in it.', 'wpjobster' ),
				'default'  => ! empty( wpj_get_page_by_title( 'Order' ) ) ? wpj_get_page_by_title( 'Order' )->ID : get_option( 'wpjobster_order_page_id' )
			)
		)
	)
);