<?php // COD Settings

foreach ( wpj_get_payment_types( array( 'topup', 'featured', 'withdraw', 'custom_extra', 'tips', 'subscription' ) ) as $key => $payment_type ) {

	$cod_fields[] = array(
		'id'       => 'wpjobster_cod_enable_' . $key,
		'type'     => 'switch',
		'title'    => $payment_type['enable_label'],
		'subtitle' => $payment_type['hint_label'],
		'default'  => false,
	);

}

$payment_gateways_cod_settings_array = array(
	'title'      => __( 'COD', 'wpjobster' ),
	'desc'       => __( 'COD Settings', 'wpjobster' ),
	'id'         => 'cod-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(
			array(
				'unique_id' => 'cod-enable-settings-section',
				'type'      => 'section',
				'title'     => esc_html__( 'Enable the gateway', 'wpjobster' ),
				'indent'    => true,
			),
			array(
				'id'       => 'wpjobster_cod_enable',
				'type'     => 'switch',
				'title'    => __( 'Enable cash on delivery', 'wpjobster' ),
				'subtitle' => __( 'Enable/Disable Cash on delivery.', 'wpjobster' ),
				'default'  => false,
			)
		),
		$cod_fields,
		array(
			array(
				'id'       => 'cod-gateway-payment-settings-section',
				'type'     => 'section',
				'title'    => esc_html__( 'Payment', 'wpjobster' ),
				'indent'   => true,
			),
			array(
				'id'       => 'wpjobster_cod_button_caption',
				'type'     => 'text',
				'title'    => __( 'Payment button name', 'wpjobster' ),
				'subtitle' => __( 'Put the Cash On Delivery button caption you want user to see on purchase page', 'wpjobster' ),
				'default'  => 'Cash on Delivery'
			),
			array(
				'id'      => 'wpjobster_cod_success_page',
				'type'    => 'select',
				'data'    => 'pages',
				'title'   => __( 'Transaction success page', 'wpjobster' ),
				'default' => ! empty( wpj_get_page_by_title( 'Order' ) ) ? wpj_get_page_by_title( 'Order' )->ID : get_option( 'wpjobster_order_page_id' )
			),
			array(
				'id'      => 'wpjobster_cod_failure_page',
				'type'    => 'select',
				'data'    => 'pages',
				'title'   => __( 'Transaction failure page', 'wpjobster' ),
				'default' => ! empty( wpj_get_page_by_title( 'Order' ) ) ? wpj_get_page_by_title( 'Order' )->ID : get_option( 'wpjobster_order_page_id' )
			)
		)
	)
);