<?php // Badge Payment Type Settings

$payment_type_badge_settings_array = array(
	'title'      => __( 'Badge', 'wpjobster' ),
	'desc'       => __( 'Badge Settings', 'wpjobster' ),
	'id'         => 'badge-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_enable_badges_sale',
			'type'     => 'switch',
			'title'    => __( 'Enable badges sale', 'wpjobster' ),
			'subtitle' => __( 'Select Yes if you want to let the users buy badges.', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'           => 'badge-list-settings',
			'type'         => 'repeater',
			'title'        => __( 'Add new badge', 'wpjobster' ),
			'item_name'    => __( 'badge', 'wpjobster' ),
			'group_values' => true,
			'required'     => array( 'wpjobster_enable_badges_sale', '=', true ),
			'fields'       => array(
				array(
					'id'          => 'wpj_badge_text',
					'type'        => 'text',
					'title'       => __( 'Description', 'wpjobster' ),
					'default'     => __( 'Verified User', 'wpjobster' )
				),
				array(
					'id'          => 'wpj_badge_icon',
					'type'        => 'text',
					'title'       => __( 'Icon', 'wpjobster' ),
					'desc'        => sprintf( __( 'Example: info, list alternate outline, address card outline, truck.<br>All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
					'default'     => 'check circle'
				),
				array(
					'id'          => 'wpj_badge_price',
					'type'        => 'text',
					'title'       => sprintf( __( 'Price (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
					'default'     => '1'
				),
				array(
					'id'          => 'wpj_badge_min_rating',
					'type'        => 'text',
					'title'       => __( 'Min rating (min 0, max 5)', 'wpjobster' ),
				),
				array(
					'id'          => 'wpj_badge_min_reviews',
					'type'        => 'text',
					'title'       => __( 'Min reviews number', 'wpjobster' ),
				),
			)
		)
	)
);