<?php // Featured Payment Type Settings

$payment_type_featured_settings_array = array(
	'title'      => __( 'Featured', 'wpjobster' ),
	'desc'       => __( 'Featured Settings', 'wpjobster' ),
	'id'         => 'featured-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_featured_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable featured jobs', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_interval',
			'type'     => 'text',
			'title'    => __( 'Featured interval (days)', 'wpjobster' ),
			'required' => array( 'wpjobster_featured_enable', '=', true ),
			'default'  => 7,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_homepage_featured_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable Hompage featured jobs', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_featured_enable', '=', true ),
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_homepage',
			'type'     => 'text',
			'title'    => __( 'Number of featured jobs on Homepage', 'wpjobster' ),
			'required' => array( 'wpjobster_homepage_featured_enable', '=', true ),
			'default'  => 5,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_price_homepage',
			'type'     => 'text',
			'title'    => sprintf( __( 'Price for featured job on Homepage (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'required' => array( 'wpjobster_homepage_featured_enable', '=', true ),
			'default'  => 5,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_category_featured_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable Category featured jobs', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_featured_enable', '=', true ),
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_category',
			'type'     => 'text',
			'title'    => __( 'Number of featured jobs on Category pages', 'wpjobster' ),
			'required' => array( 'wpjobster_category_featured_enable', '=', true ),
			'default'  => 5,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_price_category',
			'type'     => 'text',
			'title'    => sprintf( __( 'Price for featured job on Category pages (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'required' => array( 'wpjobster_category_featured_enable', '=', true ),
			'default'  => 5,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subcategory_featured_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable Subcategory featured jobs', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_featured_enable', '=', true ),
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_subcategory',
			'type'     => 'text',
			'title'    => __( 'Number of featured jobs on Subcategory pages', 'wpjobster' ),
			'required' => array( 'wpjobster_subcategory_featured_enable', '=', true ),
			'default'  => 5,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_featured_price_subcategory',
			'type'     => 'text',
			'title'    => sprintf( __( 'Price for featured job on Subcategory pages (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'required' => array( 'wpjobster_subcategory_featured_enable', '=', true ),
			'default'  => 5,
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'featured-info-1',
			'type'     => 'info',
			'title'    => __( 'If you change the interval, the current featured jobs are not affected by this change.', 'wpjobster' ),
			'required' => array( 'wpjobster_featured_enable', '=', true ),
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		),
		array(
			'id'       => 'featured-info-2',
			'type'     => 'info',
			'title'    => __( 'If you change the number of featured jobs per page and it is less than previous, the current featured jobs will show until their period expires, even if there will be more jobs than the new value.', 'wpjobster' ),
			'required' => array( 'wpjobster_featured_enable', '=', true ),
			'disabled' => ! wpj_is_allowed( 'featured_job' ) ? true : false,
		)
	)
);