<?php // Job Payment Type Settings

$payment_type_job_settings_array = array(
	'title'      => __( 'Job Purchase', 'wpjobster' ),
	'desc'       => __( 'Job Purchase Settings', 'wpjobster' ),
	'id'         => 'job-purchase-settings',
	'subsection' => true,
	'fields'     => array_merge(
		apply_filters( 'wpj_job_type_list_filter', array(
			array(
				'id'       => 'price-type-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Price type', 'wpjobster' ),
				'indent'   => true,
			),
			array(
				'id'       => 'wpjobster_price_type',
				'type'     => 'select',
				'title'    => __( 'Price type', 'wpjobster' ),
				'options'  => array(
					'free_input'      => __( 'Free text input', 'wpjobster' ),
					'fixed_amount'    => __( 'Job fixed amount', 'wpjobster' ),
					'dropdown_values' => __( 'Dropdown values', 'wpjobster' ),
				),
				'default'  => 'free_input',
			),
			array(
				'id'       => 'wpjobster_enable_fixed_rate',
				'type'     => 'switch',
				'title'    => __( 'Fixed', 'wpjobster' ),
				'default'  => true,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' )
			),
			array(
				'id'       => 'wpjobster_enable_hourly_rate',
				'type'     => 'switch',
				'title'    => __( 'Hourly', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' )
			),
			array(
				'id'       => 'wpjobster_enable_daily_rate',
				'type'     => 'switch',
				'title'    => __( 'Daily', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' )
			),
			array(
				'id'       => 'wpjobster_enable_weekly_rate',
				'type'     => 'switch',
				'title'    => __( 'Weekly', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' )
			),
			array(
				'id'       => 'wpjobster_enable_monthly_rate',
				'type'     => 'switch',
				'title'    => __( 'Monthly', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' )
			),
			array(
				'id'       => 'wpjobster_packages_enabled',
				'type'     => 'switch',
				'title'    => __( 'Packages', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' ),
				'disabled' => ! wpj_is_allowed( 'packages' ) ? true : false,
			),
			array(
				'id'       => 'wpjobster_package_selected_page_load',
				'type'     => 'text',
				'title'    => __( 'Package selected on page load', 'wpjobster' ),
				'subtitle'    => __( 'Between 0 and 2', 'wpjobster' ),
				'desc'     => __( '0 for Basic<br>1 for Standard<br>2 for Premium', 'wpjobster' ),
				'default'  => 1,
				'required' => array( 'wpjobster_packages_enabled', '=', true ),
				'disabled' => ! wpj_is_allowed( 'packages' ) ? true : false,
			),
			array(
				'id'       => 'wpjobster_enable_custom_rate',
				'type'     => 'switch',
				'title'    => __( 'No price set (custom offers only)', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_price_type', '=', 'free_input' ),
				'disabled' => ! wpj_is_allowed( 'custom_offers' ) ? true : false,
			)
		) ),

		array(
			array(
				'id'       => 'wpjobster_job_fixed_amount',
				'type'     => 'text',
				'title'    => sprintf( __( 'Fixed amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
				'required' => array( 'wpjobster_price_type', '=', 'fixed_amount' )
			),
			array(
				'id'       => 'newcost',
				'type'     => 'multi_text',
				'title'    => sprintf( __( 'Add new cost (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
				'required' => array( 'wpjobster_price_type', '=', 'dropdown_values' )
			),

/* WORK SAMPLES */

			array(
				'id'       => 'work-samples-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Work samples', 'wpjobster' ),
				'indent'   => true,
			),
			array(
				'id'       => 'wpjobster_enable_review_work_samples',
				'type'     => 'switch',
				'title'    => __( 'Enable work samples', 'wpjobster' ),
				'subtitle' => __( 'Allow the buyer to include a sample of the delivered work when posting a review.', 'wpjobster' ),
				'default'  => true,
			),
			array(
				'id'       => 'wpjobster_max_review_work_samples',
				'type'     => 'text',
				'title'    => __( 'Max work samples', 'wpjobster' ),
				'required' => array( 'wpjobster_enable_review_work_samples', '=', true ),
				'default'  => 10,
			)
		)
	)
);