<?php // Subscription Payment Type Settings

$payment_type_subscription_settings_array = array(
	'title'      => __( 'Subscription', 'wpjobster' ),
	'desc'       => __( 'Subscription Settings', 'wpjobster' ),
	'id'         => 'user-subscription-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_subscription_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enabled', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_prior_notification',
			'type'     => 'select',
			'title'    => __( 'Email notification before expiring subscription', 'wpjobster' ),
			'subtitle' => __( 'How many days in advance to notify the user about the expiration of his subscription.', 'wpjobster' ),
			'options'  => array(
				'1' => 1,
				'2' => 2,
				'3' => 3,
				'4' => 4,
				'5' => 5,
				'6' => 6,
			),
			'default'  => '1',
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),

/* SUBSCRIPTION LEVEL 0 */

		array(
			'id'       => 'subscription-level0-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Subscription Level 0 - Free', 'wpjobster' ),
			'indent'   => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_name_level0',
			'type'        => 'text',
			'title'       => __( 'Name', 'wpjobster' ),
			'placeholder' => __( 'Leave empty for translatable string', 'wpjobster' ),
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 'Free',
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),

/* SUBSCRIPTION LEVEL 1 */

		array(
			'id'       => 'subscription-level1-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Subscription Level 1 - Starter', 'wpjobster' ),
			'indent'   => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_name_level1',
			'type'        => 'text',
			'title'       => __( 'Name', 'wpjobster' ),
			'placeholder' => __( 'Leave empty for translatable string', 'wpjobster' ),
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 'Starter',
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_weekly_amount_level1',
			'type'        => 'text',
			'title'       => sprintf( __( 'Weekly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable weekly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="weekly" data-level="1" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 1,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_monthly_amount_level1',
			'type'        => 'text',
			'title'       => sprintf( __( 'Monthly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable monthly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="monthly" data-level="1" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 4,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_quarterly_amount_level1',
			'type'        => 'text',
			'title'       => sprintf( __( 'Quarterly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable quarterly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="quarterly" data-level="1" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 12,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_yearly_amount_level1',
			'type'        => 'text',
			'title'       => sprintf( __( 'Yearly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable yearly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="yearly" data-level="1" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 48,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_lifetime_amount_level1',
			'type'        => 'text',
			'title'       => sprintf( __( 'Lifetime amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable lifetime period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="lifetime" data-level="1" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_enabled', '=', true ),
			'default'     => 96,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),

/* SUBSCRIPTION LEVEL 2 */

		array(
			'id'       => 'subscription-level2-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Subscription Level 2 - Business', 'wpjobster' ),
			'indent'   => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_level_2_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enabled', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_name_level2',
			'type'        => 'text',
			'title'       => __( 'Name', 'wpjobster' ),
			'placeholder' => __( 'Leave empty for translatable string', 'wpjobster' ),
			'required'    => array( 'wpjobster_subscription_level_2_enabled', '=', true ),
			'default'     => 'Business',
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_weekly_amount_level2',
			'type'        => 'text',
			'title'       => sprintf( __( 'Weekly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable weekly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="weekly" data-level="2" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_level_2_enabled', '=', true ),
			'default'     => 2,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_monthly_amount_level2',
			'type'        => 'text',
			'title'       => sprintf( __( 'Monthly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable monthly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="monthly" data-level="2" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_level_2_enabled', '=', true ),
			'default'     => 8,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_quarterly_amount_level2',
			'type'        => 'text',
			'title'       => sprintf( __( 'Quarterly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable quarterly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="quarterly" data-level="2" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_level_2_enabled', '=', true ),
			'default'     => 24,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_yearly_amount_level2',
			'type'        => 'text',
			'title'       => sprintf( __( 'Yearly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable yearly period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="yearly" data-level="2" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_level_2_enabled', '=', true ),
			'default'     => 96,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_lifetime_amount_level2',
			'type'        => 'text',
			'title'       => sprintf( __( 'Lifetime amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable lifetime period for this level', 'wpjobster' ),
			'desc'        => '<a data-period="lifetime" data-level="2" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required'    => array( 'wpjobster_subscription_level_2_enabled', '=', true ),
			'default'     => 192,
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),

/* SUBSCRIPTION LEVEL 3 */

		array(
			'id'       => 'subscription-level3-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Subscription Level 3 - Professional', 'wpjobster' ),
			'indent'   => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_level_3_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enabled', 'wpjobster' ),
			'default'  => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'          => 'wpjobster_subscription_name_level3',
			'type'        => 'text',
			'title'       => __( 'Name', 'wpjobster' ),
			'placeholder' => __( 'Leave empty for translatable string', 'wpjobster' ),
			'required'    => array( 'wpjobster_subscription_level_3_enabled', '=', true ),
			'default'     => 'Professional',
			'disabled'    => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_weekly_amount_level3',
			'type'     => 'text',
			'title'    => sprintf( __( 'Weekly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable weekly period for this level', 'wpjobster' ),
			'desc'     => '<a data-period="weekly" data-level="3" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required' => array( 'wpjobster_subscription_level_3_enabled', '=', true ),
			'default'  => 3,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_monthly_amount_level3',
			'type'     => 'text',
			'title'    => sprintf( __( 'Monthly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable monthly period for this level', 'wpjobster' ),
			'desc'     => '<a data-period="monthly" data-level="3" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required' => array( 'wpjobster_subscription_level_3_enabled', '=', true ),
			'default'  => 12,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_quarterly_amount_level3',
			'type'     => 'text',
			'title'    => sprintf( __( 'Quarterly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable quarterly period for this level', 'wpjobster' ),
			'desc'     => '<a data-period="quarterly" data-level="3" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required' => array( 'wpjobster_subscription_level_3_enabled', '=', true ),
			'default'  => 36,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_yearly_amount_level3',
			'type'     => 'text',
			'title'    => sprintf( __( 'Yearly amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable yearly period for this level', 'wpjobster' ),
			'desc'     => '<a data-period="yearly" data-level="3" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required' => array( 'wpjobster_subscription_level_3_enabled', '=', true ),
			'default'  => 144,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_lifetime_amount_level3',
			'type'     => 'text',
			'title'    => sprintf( __( 'Lifetime amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'placeholder' => __( 'Leave empty if you want to disable lifetime period for this level', 'wpjobster' ),
			'desc'     => '<a data-period="lifetime" data-level="3" class="js-send-email-subscription-price-changed cursor-pointer">' . __( 'Send email', 'wpjobster' ) . '</a>',
			'required' => array( 'wpjobster_subscription_level_3_enabled', '=', true ),
			'default'  => 288,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'    => 'subscription-info-1',
			'type'     => 'info',
			'title'    => __( 'The "Send email" link from above let you manually send a notification about the price change only to the users affected by it.', 'wpjobster' ),
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),

/* ELIGIBILITY */

		array(
			'id'       => 'subscription-eligibility-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Eligibility Settings', 'wpjobster' ),
			'indent'   => true,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_eligibility_enabled',
			'type'     => 'switch',
			'title'    => __( 'Enable eligibility', 'wpjobster' ),
			'subtitle' => __( 'Select yes for this option to enable the eligibility.', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpjobster_subscription_enabled', '=', true ),
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_eligibility_amount_level1',
			'type'     => 'text',
			'title'    => sprintf( __( 'Level 1 sales amount needed (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'subtitle' => sprintf( __( 'User needs to have total sales more than eligibility amount in order to reach level %d', 'wpjobster' ), 1 ),
			'required' => array( 'wpjobster_subscription_eligibility_enabled', '=', true ),
			'default'  => 10,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_eligibility_amount_level2',
			'type'     => 'text',
			'title'    => sprintf( __( 'Level 2 sales amount needed (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'subtitle' => sprintf( __( 'User needs to have total sales more than eligibility amount in order to reach level %d', 'wpjobster' ), 2 ),
			'required' => array( 'wpjobster_subscription_eligibility_enabled', '=', true ),
			'default'  => 100,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_subscription_eligibility_amount_level3',
			'type'     => 'text',
			'title'    => sprintf( __( 'Level 3 sales amount needed (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'subtitle' => sprintf( __( 'User needs to have total sales more than eligibility amount in order to reach level %d', 'wpjobster' ), 3 ),
			'required' => array( 'wpjobster_subscription_eligibility_enabled', '=', true ),
			'default'  => 1000,
			'disabled' => ! wpj_is_allowed( 'subscriptions' ) ? true : false,
		),
	)
);