<?php // Topup Payment Type Settings

$payment_type_topup_settings_array = array(
	'title'      => __( 'Topup', 'wpjobster' ),
	'desc'       => __( 'Topup Settings', 'wpjobster' ),
	'id'         => 'topup-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_enable_topup',
			'type'     => 'switch',
			'title'    => __( 'Enable topup', 'wpjobster' ),
			'subtitle' => __( 'Allow your users to purchase in-site credits using PayPal', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'top_up' ) ? true : false,
		),
		array(
			'id'       => 'topup-packages-section',
			'type'     => 'section',
			'title'    => esc_html__( 'Packages', 'wpjobster' ),
			'indent'   => true,
			'required' => array( 'wpjobster_enable_topup', '=', true ),
			'disabled' => ! wpj_is_allowed( 'top_up' ) ? true : false,
		),
		array(
			'id'           => 'topup-packages-settings',
			'type'         => 'repeater',
			'title'        => sprintf( __( 'Add new package (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'subtitle'     => __( 'Add a top up package.', 'wpjobster' ),
			'item_name'    => __( 'package', 'wpjobster' ),
			'group_values' => true,
			'fields'       => array(
				array(
					'id'          => 'topup_cost',
					'type'        => 'text',
					'title'       => __( 'Cost', 'wpjobster' ),
					'subtitle'    => __( 'The amount user will pay for a particular top up package.', 'wpjobster' ),
					'placeholder' => wpj_get_site_default_currency(),
				),
				array(
					'id'          => 'topup_credit',
					'type'        => 'text',
					'title'       => __( 'Credit', 'wpjobster' ),
					'subtitle'    => __( 'The amount the user will be credited with. Difference between the two is what you will be making on those transactions.', 'wpjobster' ),
					'placeholder' => wpj_get_site_default_currency(),
				),
			),
			'required' => array( 'wpjobster_enable_topup', '=', true ),
			'disabled' => ! wpj_is_allowed( 'top_up' ) ? true : false,
		)
	)
);