<?php // Withdrawal Payment Type Settings

$payment_type_withdrawal_settings_array = array(
	'title'      => __( 'Withdrawal', 'wpjobster' ),
	'desc'       => __( 'Withdrawal Settings', 'wpjobster' ),
	'id'         => 'withdrawal-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'wpjobster_withdraw_limit',
			'type'     => 'text',
			'title'    => sprintf( __( 'Minimum withdrawal amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'default'  => 10,
		),
		array(
			'id'       => 'wpjobster_enable_withdraw_email_verification',
			'type'     => 'switch',
			'title'    => __( 'Enable withdraw email verification', 'wpjobster' ),
			'subtitle' => __( 'User need to validate his request before the withdrawal appear in the admin section', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'wpjobster_payoneer_enable_withdraw',
			'type'     => 'switch',
			'title'    => __( 'Enable payoneer withdraw', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'    => 'withdrawal-info-1',
			'type'  => 'info',
			'title' => __( 'Go to Payment Gateways to enable more withdrawal gateways.', 'wpjobster' )
		)
	)
);