<?php // Currency Settings

global $wpjobster_currencies_array;

$exchange_rates = wpj_json_decode( wpj_get_option( 'exchange_rates' ) );

$rate_fields = array();
foreach ( $wpjobster_currencies_array as $wpjobster_currency ) {
	if ( $wpjobster_currency != "USD" ) {
		$rate_fields[] = array(
			'id'       => 'wpjobster_' . $wpjobster_currency . '_currency',
			'type'     => 'text',
			'title'    => $wpjobster_currency,
			'data'     => array( isset( $exchange_rates->rates->$wpjobster_currency ) ? $exchange_rates->rates->$wpjobster_currency : '' ),
			'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false,
		);
	}
}

$pricing_currency_settings_array = array(
	'title'      => __( 'Currencies', 'wpjobster' ),
	'desc'       => __( 'Currency Settings', 'wpjobster' ),
	'id'         => 'currency-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(
			array(
				'id'       => 'site-currencies-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Site currencies', 'wpjobster' ),
				'indent'   => true,
			),
			array(
				'id'           => 'add-new-currency',
				'type'         => 'repeater',
				'title'        => __( 'Add new currency', 'wpjobster' ),
				'item_name'    => __( 'currency', 'wpjobster' ),
				'group_values' => true,
				'limit'        => wpj_is_allowed( 'multi_currency' ) ? apply_filters( 'wpj_multi_currency_limit_filter', 10 ) : 1,
				'fields'       => array(
					array(
						'id'      => 'currency_name',
						'type'    => 'select',
						'title'   => __( 'Currency', 'wpjobster' ),
						'options' => wpj_get_currencies_list(),
						'default' => 'USD',
					),
					array(
						'id'      => 'curency_symbol',
						'type'    => 'text',
						'title'   => __( 'Symbol', 'wpjobster' ),
						'default' => '$'
					)
				)
			),
			array(
				'id'       => 'rate-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Rates', 'wpjobster' ),
				'indent'   => true,
				'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false,
			),
			array(
				'id'       => 'wpjobster_enable_open_exchange_api_rate',
				'type'     => 'switch',
				'title'    => __( 'Enable Open Exchange Rates API', 'wpjobster' ),
				'default'  => false,
				'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false,
			),
			array(
				'id'       => 'wpjobster_exchange_drop_percent',
				'type'     => 'text',
				'title'    => __( 'Currency drop percent (%)', 'wpjobster' ),
				'required' => array( 'wpjobster_enable_open_exchange_api_rate', '=', true ),
				'default'  => 5,
				'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false,
			)
		),
		$rate_fields,
		array(
			array(
				'id'    => 'usd-base-currency',
				'type'  => 'info',
				'title' => __( 'USD', 'wpjobster' ),
				'desc'  => __( 'USD is the base currency to which all exchange rates are relative. You can still set any currency as the primary one for the frontend.', 'wpjobster' )
			)
		)
	)
);