<?php // Fee Settings

$site_fee_options = array(
	'disabled' => __( 'Disabled', 'wpjobster' ),
	'percent'  => __( 'Percent', 'wpjobster' ),
	'fixed'    => __( 'Fixed', 'wpjobster' )
);

if ( wpj_is_allowed( 'flexible_fees' ) ) $site_fee_options['flexible'] = __( 'Flexible', 'wpjobster' );

$pricing_fee_settings_array = array(
	'title'      => __( 'Fees', 'wpjobster' ),
	'desc'       => __( 'Fee Settings', 'wpjobster' ),
	'id'         => 'fee-settings',
	'subsection' => true,
	'fields'     => array(

/* FOR SELLERS - Site Fees */
		array(
			'id'       => 'seller-fee-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'For Sellers - Site Fees', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_site_fee',
			'type'     => 'select',
			'title'    => __( 'Site fee', 'wpjobster' ),
			'subtitle' => __( 'Please choose between the available site fee types then fill below the amounts.', 'wpjobster' ),
			'options'  => $site_fee_options,
			'default'  => 'disabled',
		),
		array(
			'id'       => 'wpjobster_percent_fee_taken',
			'type'     => 'text',
			'title'    => __( 'Percent site fee (%)', 'wpjobster' ),
			'subtitle' => __( 'If the site fee is set to percent, this value will be used.', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_site_fee', '=', 'percent' )
		),
		array(
			'id'       => 'wpjobster_solid_fee_taken',
			'type'     => 'text',
			'title'    => sprintf( __( 'Fixed site fee (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'subtitle' => __( 'If the site fee is set to fixed, this value will be used.', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_site_fee', '=', 'fixed' )
		),
		array(
			'id'           => 'flexible-fee-settings',
			'type'         => 'repeater',
			'title'        => __( 'Flexible site fee (%)', 'wpjobster' ),
			'subtitle'     => __( 'Percent per level.', 'wpjobster' ),
			'item_name'    => __( 'fee', 'wpjobster' ),
			'group_values' => true,
			'limit'        => 4,
			'disabled'     => ! wpj_is_allowed( 'flexible_fees' ) ? true : false,
			'fields'       => array(
				array(
					'id'          => 'flexible_fee_over',
					'type'        => 'text',
					'title'       => __( 'Fee Over', 'wpjobster' ),
					'placeholder' => sprintf( __( 'Fee over x %s', 'wpjobster' ), wpj_get_site_default_currency() ),
					'default'     => '0'
				),
				array(
					'id'          => 'level0_flexible_fee',
					'type'        => 'text',
					'title'       => __( 'Level 0', 'wpjobster' ),
					'placeholder' => '%',
					'default'     => '20'
				),
				array(
					'id'          => 'level1_flexible_fee',
					'type'        => 'text',
					'title'       => __( 'Level 1', 'wpjobster' ),
					'placeholder' => '%',
					'default'     => '20'
				),
				array(
					'id'          => 'level2_flexible_fee',
					'type'        => 'text',
					'title'       => __( 'Level 2', 'wpjobster' ),
					'placeholder' => '%',
					'default'     => '20'
				),
				array(
					'id'          => 'level3_flexible_fee',
					'type'        => 'text',
					'title'       => __( 'Level 3', 'wpjobster' ),
					'placeholder' => '%',
					'default'     => '20'
				),
			),
			'required' => array( 'wpjobster_enable_site_fee', '=', 'flexible' )
		),

/* FOR BUYERS - Processing Fees */
		array(
			'id'       => 'buyer-fee-pf-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'For Buyers - Processing Fees', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_buyer_processing_fees',
			'type'     => 'select',
			'title'    => __( 'Processing fee', 'wpjobster' ),
			'subtitle' => __( 'Enable/Disable processing fees chargeable to buyer for site admin.', 'wpjobster' ),
			'options'  => array(
				'disabled' => __( 'Disabled', 'wpjobster' ),
				'percent'  => __( 'Percent', 'wpjobster' ),
				'fixed'    => __( 'Fixed', 'wpjobster' ),
			),
			'default'  => 'disabled',
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_buyer_processing_fees_percent',
			'type'     => 'text',
			'title'    => __( 'Percent processing fee (%)', 'wpjobster' ),
			'subtitle' => __( 'Processing fees percent chargeable to buyer for site admin.', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_buyer_processing_fees', '=', 'percent' ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_buyer_processing_fees',
			'type'     => 'text',
			'title'    => sprintf( __( 'Fixed processing fee (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
			'subtitle' => __( 'Processing fees chargeable to buyer for site admin.', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_buyer_processing_fees', '=', 'fixed' ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_enable_refund_buyer_processing_fees',
			'type'     => 'switch',
			'title'    => __( 'Includes processing fee in refund', 'wpjobster' ),
			'subtitle' => __( 'Enable/Disable refunding processing fees when the transaction is closed.', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpjobster_enable_buyer_processing_fees', '!=', 'disabled' ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),

/* FOR BUYERS - Tax */
		array(
			'id'       => 'buyer-fee-tax-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'For Buyers - Tax', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_enable_site_tax',
			'type'     => 'switch',
			'title'    => __( 'Tax', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_tax_percent',
			'type'     => 'text',
			'title'    => __( 'Percent tax (%)', 'wpjobster' ),
			'required' => array( 'wpjobster_enable_site_tax', '=', true ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_tax_over',
			'type'     => 'select',
			'title'    => __( 'Apply tax over', 'wpjobster' ),
			'subtitle' => __( 'Apply tax to job price, processing fees or apply to both.', 'wpjobster' ),
			'options'  => array(
				'job'            => __( 'Job price', 'wpjobster' ),
				'processing_fee' => __( 'Processing fee', 'wpjobster' ),
				'job_and_pf'     => __( 'Job price and processing fee', 'wpjobster' )
			),
			'default'  => 'job',
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'       => 'wpjobster_enable_refund_tax',
			'type'     => 'switch',
			'title'    => __( 'Includes tax in refund', 'wpjobster' ),
			'subtitle' => __( 'Enable/Disable refunding tax when the transaction is closed', 'wpjobster' ),
			'default'  => false,
			'required' => array( 'wpjobster_enable_site_tax', '=', true ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'           => 'country-tax-settings',
			'type'         => 'repeater',
			'title'        => __( 'Tax by country', 'wpjobster' ),
			'subtitle'     => __( 'Select a country and the tax for it.', 'wpjobster' ),
			'item_name'    => __( 'tax', 'wpjobster' ),
			'group_values' => true,
			'fields'       => array(
				array(
					'id'          => 'country_name',
					'type'        => 'select',
					'title'       => __( 'Country name', 'wpjobster' ),
					'options'     => wpj_get_country_name_by_code()
				),
				array(
					'id'          => 'country_tax',
					'type'        => 'text',
					'title'       => __( 'Country tax (%)', 'wpjobster' )
				),
			),
			'required' => array( 'wpjobster_enable_site_tax', '=', true ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false,
		),
		array(
			'id'           => 'category-tax-settings',
			'type'         => 'repeater',
			'title'        => __( 'Tax by category', 'wpjobster' ),
			'subtitle'     => __( 'Select a category and the tax for it.', 'wpjobster' ),
			'item_name'    => __( 'tax', 'wpjobster' ),
			'group_values' => true,
			'fields'       => array(
				array(
					'id'    => 'category_name',
					'type'  => 'select',
					'title' => __( 'Category name', 'wpjobster' ),
					'data' => 'terms',
					'args' => array(
						'taxonomies' => ['job_cat'],
					),
				),
				array(
					'id'    => 'category_tax',
					'type'  => 'text',
					'title' => __( 'Category tax (%)', 'wpjobster' )
				),
			),
			'required' => array( 'wpjobster_enable_site_tax', '=', true ),
			'disabled' => ! wpj_is_allowed( 'processing_fee' ) ? true : false
		)
	)
);