<?php // Limit Settings

for ( $i = 0; $i < 4; $i++ ) {
	$job_amount_fields[] = array(
		'id'       => 'wpj_job_price_limits_level' . $i,
		'type'     => 'slider',
		'title'    => $i == 0 ? sprintf( __( 'Job amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ) : '',
		'subtitle' => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'default'  => array(
			1 => 5,
			2 => 5000,
		),
		'min'           => 0,
		'step'          => 1,
		'max'           => apply_filters( 'wpj_job_amount_max_limit_level_filter', 10000 ),
		'display_value' => 'text',
		'handles'       => 2
	);

	$job_extra_amount_fields[] = array(
		'id'       => 'wpj_job_extra_price_limits_level' . $i,
		'type'     => 'slider',
		'title'    => $i == 0 ? sprintf( __( 'Extra amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ) : '',
		'subtitle' => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'default'  => array(
			1 => 5,
			2 => 5000,
		),
		'min'           => 0,
		'step'          => 1,
		'max'           => apply_filters( 'wpj_extra_amount_max_limit_level_filter', 10000 ),
		'display_value' => 'text',
		'handles'       => 2
	);

	$custom_extra_amount_fields[] = array(
		'id'       => 'wpj_custom_extra_price_limits_level' . $i,
		'type'     => 'slider',
		'title'    => $i == 0 ? sprintf( __( 'Custom extra amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ) : '',
		'subtitle' => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'default'  => array(
			1 => 5,
			2 => 5000,
		),
		'min'           => 0,
		'step'          => 1,
		'max'           => apply_filters( 'wpj_custom_extra_amount_max_limit_level_filter', 10000 ),
		'display_value' => 'text',
		'handles'       => 2,
		'disabled'      => ! wpj_is_allowed( 'custom_extras' ) ? true : false,
	);

	$subscr_job_amount_fields[] = array(
		'id'       => 'wpj_job_price_limits_subscription_level' . $i,
		'type'     => 'slider',
		'title'    => $i == 0 ? sprintf( __( 'Job amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ) : '',
		'subtitle' => sprintf( __( 'Subscription Level %d', 'wpjobster' ), $i ),
		'default'  => array(
			1 => 5,
			2 => 5000,
		),
		'min'           => 0,
		'step'          => 1,
		'max'           => apply_filters( 'wpj_job_amount_max_limit_subscription_filter', 10000 ),
		'display_value' => 'text',
		'handles'       => 2
	);

	$subscr_job_extra_amount_fields[] = array(
		'id'       => 'wpj_job_extra_price_limits_subscription_level' . $i,
		'type'     => 'slider',
		'title'    => $i == 0 ? sprintf( __( 'Extra amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ) : '',
		'subtitle' => sprintf( __( 'Subscription Level %d', 'wpjobster' ), $i ),
		'default'  => array(
			1 => 5,
			2 => 5000,
		),
		'min'           => 0,
		'step'          => 1,
		'max'           => apply_filters( 'wpj_extra_amount_max_limit_subscription_filter', 10000 ),
		'display_value' => 'text',
		'handles'       => 2
	);

	$subscr_custom_extra_amount_fields[] = array(
		'id'       => 'wpj_custom_extra_price_limits_subscription_level' . $i,
		'type'     => 'slider',
		'title'    => $i == 0 ? sprintf( __( 'Custom extra amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ) : '',
		'subtitle' => sprintf( __( 'Subscription Level %d', 'wpjobster' ), $i ),
		'default'  => array(
			1 => 5,
			2 => 5000,
		),
		'min'           => 0,
		'step'          => 1,
		'max'           => apply_filters( 'wpj_custom_extra_amount_max_limit_subscription_filter', 10000 ),
		'display_value' => 'text',
		'handles'       => 2,
		'disabled'      => ! wpj_is_allowed( 'custom_extras' ) ? true : false,
	);
}

$pricing_limit_settings_array = array(
	'title'      => __( 'Limits', 'wpjobster' ),
	'desc'       => __( 'Price Limits Settings', 'wpjobster' ),
	'id'         => 'price-limit-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(

/* LEVEL & SUBSCRIPTION LIMITS */
			array(
				'id'       => 'price-limits-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level & Subscription', 'wpjobster' ),
				'indent'   => true,
			),
			array(
				'id'       => 'wpj_package_amount_price_limits',
				'type'     => 'slider',
				'title'    => sprintf( __( 'Package amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
				'subtitle' => __( 'Minimum and maximum price that can be set for a package amount.', 'wpjobster' ),
				'default'       => array(
					1 => 5,
					2 => 1000,
				),
				'min'           => 0,
				'step'          => 1,
				'max'           => apply_filters( 'wpj_package_amount_max_limit_filter', 10000 ),
				'display_value' => 'text',
				'handles'       => 2,
				'disabled'      => ! wpj_is_allowed( 'packages' ) ? true : false,
			),
			array(
				'id'       => 'wpj_custom_offer_amount_price_limits',
				'type'     => 'slider',
				'title'    => sprintf( __( 'Custom offer amount (%s)', 'wpjobster' ), wpj_get_site_default_currency() ),
				'subtitle' => __( 'Minimum and maximum price that can be set for a custom offer.', 'wpjobster' ),
				'default'       => array(
					1 => 5,
					2 => 5000,
				),
				'min'           => 0,
				'step'          => 1,
				'max'           => apply_filters( 'wpj_custom_offer_amount_max_limit_filter', 10000 ),
				'display_value' => 'text',
				'handles'       => 2,
				'disabled'      => ! wpj_is_allowed( 'custom_offers' ) ? true : false,
			),
			array(
				'id'       => 'level-price-limits-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level', 'wpjobster' ),
				'indent'   => true
			)
		),
		$job_amount_fields, $job_extra_amount_fields, $custom_extra_amount_fields,
		array(
			array(
				'id'       => 'subscription-price-limits-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription', 'wpjobster' ),
				'indent'   => true
			)
		),
		$subscr_job_amount_fields, $subscr_job_extra_amount_fields, $subscr_custom_extra_amount_fields
	)
);