<?php // Pricing Settings

$pricing_settings_array = array(
	'title'  => __( 'Pricing Settings', 'wpjobster' ),
	'id'     => 'pricing-main-settings',
	'icon'   => 'el el-usd',
	'fields' => array(
		array(
			'id'       => 'wpjobster_credits_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable credits', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'wpjobster_currency_position',
			'type'     => 'select',
			'title'    => __( 'Currency symbol position', 'wpjobster' ),
			'options'  => array(
				'front' => __( 'In front of sum', 'wpjobster' ) . ' (' . wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ) . '50)',
				'back'  => __( 'After the sum', 'wpjobster' ) . ' (50' . wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ) . ')'
			),
			'default'  => 'back',
		),
		array(
			'id'       => 'wpjobster_currency_symbol_space',
			'type'     => 'select',
			'title'    => __( 'Space between sum and symbol', 'wpjobster' ),
			'options'  => array(
				'yes' => __( 'Yes', 'wpjobster' ) . ' (50 ' . wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ) . ')',
				'no'  => __( 'No', 'wpjobster' ) . ' (50' . wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ) . ')'
			),
			'default'  => 'yes',
		),
		array(
			'id'       => 'wpjobster_decimals',
			'type'     => 'select',
			'title'    => __( 'Decimals', 'wpjobster' ),
			'options'  => array(
				'default'  => __( 'Default','wpjobster' ),
				'ifneeded' => __( 'If Needed', 'wpjobster' ),
				'never'    => __( 'Never', 'wpjobster' )
			),
			'default'  => 'default',
		),
		array(
			'id'       => 'wpjobster_decimal_sum_separator',
			'type'     => 'select',
			'title'    => __( 'Decimals sum separator', 'wpjobster' ),
			'options'  => array(
				','   => __( 'Comma (,)', 'wpjobster' ),
				'.' => __( 'Point (.)', 'wpjobster' )
			),
			'default'  => '.',
		),
		array(
			'id'       => 'wpjobster_thousands_sum_separator',
			'type'     => 'select',
			'title'    => __( 'Thousands sum separator', 'wpjobster' ),
			'options'  => array(
				','   => __( 'Comma (,)', 'wpjobster' ),
				'.' => __( 'Point (.)', 'wpjobster' )
			),
			'default'  => ',',
		),
		array(
			'id'       => 'wpjobster_replace_zero_with_free',
			'type'     => 'select',
			'title'    => __( 'Replace "0.00 USD" price with "Free"', 'wpjobster' ),
			'options'  => array(
				'yes' => __( 'Yes', 'wpjobster' ),
				'no'  => __( 'No', 'wpjobster' )
			),
			'default'  => 'no',
		),
	)
);