<?php
// JOB METABOXES //
function wpjobster_set_job_metaboxes() {
	global $post;
	$value = get_post_custom( $post->ID );

	// Normal
	$wpjobster_packages = wpj_get_option( 'wpjobster_packages_enabled' );
	if ( $wpjobster_packages == "yes" ) {
		add_meta_box( 'job_packages',          'Job Packages',          'wpjobster_theme_job_packages',          'job', 'advanced', 'high' );
		add_meta_box( 'job_packages_rejected', 'Job Packages Rejected', 'wpjobster_theme_job_packages_rejected', 'job', 'advanced', 'high' );
	}

	add_meta_box( 'job_rejected', 'Job Rejected',            'wpjobster_theme_job_rejected',   'job', 'advanced', 'high' );
	add_meta_box( 'job_media',    'Job Media',               'wpjobster_theme_job_images',     'job', 'advanced', 'high' );
	add_meta_box( 'job_extra',    'Job Additional Services', 'wpjobster_theme_job_additional', 'job', 'advanced', 'high' );

	// Side
	add_meta_box( 'job_dets', 'Job Details', 'wpjobster_theme_job_dts', 'job', 'side', 'default' );

	if ( wpj_get_option( 'wpjobster_featured_enable' ) == 'yes' )
		add_meta_box( 'job_featured', 'Job Featured', 'wpjobster_theme_job_featured', 'job', 'side', 'default' );

	add_meta_box( 'job_instr', 'Instructions to Buyer', 'wpjobster_theme_job_instructions', 'job', 'side', 'default' );

	$instant_attachments = isset( $value["job_any_attachments"][0] ) ? $value["job_any_attachments"][0] : '';
	if ( wpj_post_has_attachments( $instant_attachments ) )
		add_meta_box( 'job_attachments', 'Instant Delivery Attachments', 'wpjobster_job_attachments', 'job', 'side', 'default' );

	$preview_job_attachments = isset( $value["preview_job_attachments"][0] ) ? $value["preview_job_attachments"][0] : '';
	if ( wpj_post_has_attachments( $preview_job_attachments ) )
		add_meta_box( 'preview_job_attachments', 'Job Preview', 'wpjobster_preview_job_attachments', 'job', 'side', 'default' );

	// Action
	do_action( 'wpj_after_admin_metaboxes', 'job' );
}

if ( ! function_exists( 'wpjobster_theme_job_images' ) ) {
	function wpjobster_theme_job_images() {
		global $post;

		if ( wpj_bool_option( 'wpjobster_enable_job_cover' ) ) {
			echo '<h4>' . __( 'Job Cover', 'wpjobster' ) . '</h4>';
			wpj_display_job_cover_upload_form( $post->ID );
		}

		echo '<h4>' . __( 'Job Images', 'wpjobster' ) . '</h4>';

		wpj_display_image_upload_form( $post->ID, 'job', 'job', 'job_images' );
	}
}

function wpjobster_theme_job_additional() {
	global $post;

	$pid = $post->ID;
	$aid = $post->post_author;

	$user_level = wpj_get_user_level( $aid );

	$sts = wpj_get_option( 'wpjobster_get_level' . $user_level . '_extras' );

	if ( ! is_numeric( $sts ) ) { $sts = 3; } ?>

	<h3><?php echo sprintf( __( "This user is allowed to have max %s extras.", "wpjobster" ), $sts ); ?></h3>

	<table width="100%">

		<?php for ( $k = 1; $k <= 10; $k++ ) { ?>

			<tr>

				<td>
					<?php $post_job_extra = get_post_meta( $pid, 'extra' . $k . '_extra_enabled', true ); ?>
					<input type="checkbox" name="enable_extra_<?php echo $k; ?>" <?php echo $post_job_extra == true ? 'checked' : ''; ?> />
				</td>

				<td><?php _e( 'For an extra', 'wpjobster' ); ?>
					<input type="text" size="3" name="extra<?php echo $k; ?>_price" value="<?php echo get_post_meta( $pid, 'extra' . $k . '_price', true ); ?>" />
					<?php echo wpj_get_site_default_currency(); ?> &nbsp; &nbsp;
				</td>

				<td>
					<textarea name="extra<?php echo $k; ?>_content" cols="40" rows="2"><?php echo get_post_meta( $pid, 'extra' . $k . '_content', true ); ?></textarea>
					<?php do_action( 'wpj_after_admin_extra_display', $pid, $k, 'admin' ); ?>
				</td>

				<td><?php _e( 'Max days to deliver', 'wpjobster' );

					$post_job_extra_max_days = get_post_meta( $pid, 'max_days_ex_' . $k, true ); ?>

					<select id="max_days_<?php echo $k; ?>" name="max_days_<?php echo $k; ?>" class="max-day-deliver">

						<option value="" disabled selected hidden><?php _e( "Please Select", "wpjobster" ); ?></option>

						<?php if ( wpj_get_option( 'wpjobster_enable_instant_delivery' ) != "no" ) {

							$selected_instant = $post_job_extra_max_days == 'instant' ? ' selected="selected" ' :''; ?>
							<option <?php echo $selected_instant; ?> value="instant"><?php _e( 'Instant', 'wpjobster' ); ?></option>

						<?php }

						for ( $i_count = 1; $i_count <= 30; $i_count++ ) {

							$selected_max_days = $post_job_extra_max_days == $i_count ? ' selected="selected" ' :''; ?>

							<option value="<?php echo $i_count; ?>" <?php echo $selected_max_days; ?>><?php echo sprintf( _n( '%d day', '%d days', $i_count, 'wpjobster' ), $i_count ); ?></option>

						<?php } ?>

					</select>

				</td>

				<td>
					<?php $post_job_extra_multiple = get_post_meta( $pid, 'extra' . $k . '_enabled', true ); ?>

					<input type="checkbox" name="enable_multiples_<?php echo $k; ?>" <?php echo $post_job_extra_multiple == true ? 'checked' : ''; ?> /><?php _e( 'Multiple', 'wpjobster' ); ?>
				</td>

			</tr>

		<?php } ?>

	</table>

<?php }

if ( ! function_exists( 'wpjobster_theme_job_packages' ) ) {
	function wpjobster_theme_job_packages() {

		global $post;
		$pid = $post->ID;

		$packages = get_post_meta( $pid, 'job_packages', true );

		$package_name          = get_post_meta( $pid, 'package_name', true );
		$package_description   = get_post_meta( $pid, 'package_description', true );
		$package_max_days      = get_post_meta( $pid, 'package_max_days', true );
		$package_revisions     = get_post_meta( $pid, 'package_revisions', true );
		$package_price         = get_post_meta( $pid, 'package_price', true );
		$package_custom_fields = get_post_meta( $pid, 'package_custom_fields', true ); ?>

		<table class="packages" width="100%">
			<thead>
				<tr>
					<th></th>
					<th><?php _e( 'BASIC', 'wpjobster'); ?></th>
					<th><?php _e( 'STANDARD', 'wpjobster'); ?></th>
					<th><?php _e( 'PREMIUM', 'wpjobster'); ?></th>
				</tr>
			</thead>

			<tbody>
				<tr>
					<th><?php _e( 'Package name', 'wpjobster'); ?></th>
					<?php if ( $package_name ) {
						foreach ( $package_name as $p_n_key => $p_name ) { ?>
							<td>
								<input name="package_name[]" maxlength="35" type="text" placeholder="<?php _e( 'Name your package', 'wpjobster'); ?>" value="<?php echo $p_name; ?>">
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<input name="package_name[]" maxlength="35" type="text" placeholder="<?php _e( 'Name your package', 'wpjobster'); ?>">
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package description', 'wpjobster'); ?></th>
					<?php if ( $package_description ) {
						foreach ( $package_description as $p_d_key => $p_desc ) { ?>
							<td>
								<textarea rows="10" name="package_description[]" type="text" placeholder="<?php _e( 'Describe the details of your offering', 'wpjobster'); ?>"><?php echo $p_desc; ?></textarea>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<textarea rows="10" name="package_description[]" type="text" placeholder="<?php _e( 'Describe the details of your offering', 'wpjobster'); ?>"></textarea>
							</td>
						<?php }
					} ?>
				</tr>

				<?php if( $package_custom_fields ) {
					foreach ( $package_custom_fields as $key => $value ) { ?>
						<tr>
							<th><?php echo $value['name']; ?></th>
							<td>
								<?php if ( $value['basic'] == 'on' ){
									echo '<span class="dashicons dashicons-yes"></span>';
								} else {
									echo '<span class="dashicons dashicons-no-alt"></span>';
								} ?>
							</td>
							<td>
								<?php if ( $value['standard'] == 'on' ){
									echo '<span class="dashicons dashicons-yes"></span>';
								} else {
									echo '<span class="dashicons dashicons-no-alt"></span>';
								} ?>
							</td>
							<td>
								<?php if ( $value['premium'] == 'on' ){
									echo '<span class="dashicons dashicons-yes"></span>';
								} else {
									echo '<span class="dashicons dashicons-no-alt"></span>';
								} ?>
							</td>
						</tr>
					<?php }
				} ?>

				<tr>
					<th><?php _e( 'Package delivery time', 'wpjobster'); ?></th>
					<?php if ( $package_max_days ) {
						foreach ( $package_max_days as $p_md_key => $p_max_days ) { ?>
							<td>
								<select id="max_days" name="package_max_days[]">
									<option value="" disabled selected hidden><?php _e( "Please Select","wpjobster" );?></option>
									<?php for($i_count=1;$i_count<=wpj_get_option( 'wpjobster_job_max_delivery_days' );$i_count++){ ?>
										<option value="<?php echo $i_count ?>" <?php echo ( $i_count==$p_max_days?' selected="selected=" ':"" ); ?>>
											<?php echo sprintf( _n( '%d day', '%d days',$i_count, 'wpjobster' ), $i_count);?>
										</option>
									<?php } ?>
								</select>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<select id="max_days" name="package_max_days[]">
									<option value="" disabled selected hidden><?php _e( "Please Select","wpjobster" );?></option>
									<?php for($i_count=1;$i_count<=wpj_get_option( 'wpjobster_job_max_delivery_days' );$i_count++){ ?>
										<option value="<?php echo $i_count ?>">
											<?php echo sprintf( _n( '%d day', '%d days',$i_count, 'wpjobster' ), $i_count);?>
										</option>
									<?php } ?>
								</select>
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package revisions', 'wpjobster'); ?></th>
					<?php if ( $package_revisions ) {
						foreach ( $package_revisions as $p_r_key => $p_revisions ) { ?>
							<td>
								<select name="package_revisions[]">
									<option value="" disabled selected hidden><?php _e( "Please Select","wpjobster" );?></option>
									<?php for( $i_count=1;$i_count<=9;$i_count++ ){ ?>
										<option value="<?php echo $i_count ?>" <?php echo ( $i_count==$p_revisions?' selected="selected=" ':"" ); ?>>
											<?php echo $i_count;?>
										</option>
									<?php } ?>
									<option <?php if ( $p_revisions == 'unlimited' ) echo 'selected'; ?> value="unlimited"><?php _e( 'Unlimited', 'wpjobster' ); ?></option>
								</select>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<select name="package_revisions[]">
									<option value="" disabled selected hidden><?php _e( "Please Select","wpjobster" );?></option>
									<?php for( $i_count=1;$i_count<=9;$i_count++ ){ ?>
										<option value="<?php echo $i_count ?>">
											<?php echo $i_count;?>
										</option>
									<?php } ?>
									<option value="unlimited"><?php _e( 'Unlimited', 'wpjobster' ); ?></option>
								</select>
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package price', 'wpjobster') . '&nbsp;('.wpj_get_currency_symbol_by_name(wpj_get_site_default_currency()).')'; ?></th>
					<?php if ( $package_price ) {
						foreach ( $package_price as $p_p_key => $p_price ) { ?>
							<td>
								<input name="package_price[]" type="number" step="0.01" placeholder="<?php _e( 'Package price', 'wpjobster'); ?>" value="<?php echo $p_price; ?>">
							</td>
						<?php }
					} else {
						for ( $i=0; $i<3; $i++ ) { ?>
							<td>
								<input name="package_price[]" type="number" step="0.01" placeholder="<?php _e( 'Package price', 'wpjobster'); ?>" />
							</td>
						<?php }
					} ?>
				</tr>
			</tbody>
		</table>
		<?php
	}
}

if ( ! function_exists( 'wpjobster_theme_job_packages_rejected' ) ) {
	function wpjobster_theme_job_packages_rejected() {
		global $post;
		$pid = $post->ID;

		$rejected_package_name        = get_post_meta( $pid, 'rejected_package_name', true );
		$rejected_package_description = get_post_meta( $pid, 'rejected_package_description', true );
		$rejected_package_max_days    = get_post_meta( $pid, 'rejected_package_max_days', true );
		$rejected_package_revisions   = get_post_meta( $pid, 'rejected_package_revisions', true );
		$rejected_package_price       = get_post_meta( $pid, 'rejected_package_price', true ); ?>

		<table class="packages" width="100%">
			<thead>
				<tr>
					<th></th>
					<th><?php _e( 'BASIC', 'wpjobster'); ?></th>
					<th><?php _e( 'STANDARD', 'wpjobster'); ?></th>
					<th><?php _e( 'PREMIUM', 'wpjobster'); ?></th>
				</tr>
			</thead>

			<tbody>
				<tr>
					<th><?php _e( 'Package name', 'wpjobster'); ?></th>
					<?php if ( $rejected_package_name ) {
							foreach ( $rejected_package_name as $rejected_p_n_key => $rejected_p_name ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_name[]" type="text"><?php echo $rejected_p_name; ?></textarea>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_name[]" type="text"></textarea>
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package description', 'wpjobster'); ?></th>
					<?php if ( $rejected_package_description ) {
						foreach ( $rejected_package_description as $rejected_p_d_key => $rejected_p_desc ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_description[]" type="text"><?php echo $rejected_p_desc; ?></textarea>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_description[]" type="text"></textarea>
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package delivery time', 'wpjobster'); ?></th>
					<?php if ( $rejected_package_max_days ) {
						foreach ( $rejected_package_max_days as $rejected_p_md_key => $rejected_p_max_days ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_max_days[]" type="text"><?php echo $rejected_p_max_days; ?></textarea>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_max_days[]" type="text"></textarea>
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package revisions', 'wpjobster'); ?></th>
					<?php if ( $rejected_package_revisions ) {
						foreach ( $rejected_package_revisions as $rejected_p_r_key => $rejected_p_revisions ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_revisions[]" type="text"><?php echo $rejected_p_revisions; ?></textarea>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_revisions[]" type="text"></textarea>
							</td>
						<?php }
					} ?>
				</tr>

				<tr>
					<th><?php _e( 'Package price', 'wpjobster') . '&nbsp;('.wpj_get_currency_symbol_by_name(wpj_get_site_default_currency()).')'; ?></th>
					<?php if ( $rejected_package_price ) {
						foreach ( $rejected_package_price as $rejected_p_p_key => $rejected_p_price ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_price[]" type="text"><?php echo $rejected_p_price; ?></textarea>
							</td>
						<?php }
					} else {
						for( $i=0; $i<3; $i++ ) { ?>
							<td>
								<textarea rows="2" name="rejected_package_price[]" type="text"></textarea>
							</td>
						<?php }
					} ?>
				</tr>
			</tbody>
		</table>
	<?php }
}

if ( ! function_exists( 'wpjobster_theme_job_dts' ) ) {
	function wpjobster_theme_job_dts() {
		global $post;

		$pid      = $post->ID;
		$price    = get_post_meta( $pid, "price", true );
		$location = get_post_meta( $pid, "Location", true );
		$f        = get_post_meta( $pid, "featured", true );
		$t        = get_post_meta( $pid, "closed", true );
		$active   = get_post_meta( $pid, "active", true ); ?>

		<ul id="post-new4">
			<input name="fromadmin" type="hidden" value="1" />

			<li>
				<h2><?php _e( 'Job Price:', 'wpjobster' ); ?></h2>

				<p>
					<?php
					$post_job_type = WPJ_Form::post( 'price_type', get_post_meta( $pid, 'price_type', true ) );
					$price_type    = wpj_get_option( 'wpjobster_price_type' );

					if ( $price_type == "fixed_amount" ) {
						echo wpj_show_price( wpj_get_option( 'wpjobster_job_fixed_amount' ) );

					} elseif ( $price_type == "dropdown_values" ) {
						$dropdown_values = wpj_get_option( 'newcost' );
						$post_value      = WPJ_Form::post( 'job_cost', get_post_meta( $pid, 'price', true ) );

						if ( $dropdown_values ) { ?>

							<select name="job_cost">

								<?php foreach ( $dropdown_values as $cost ) { ?>

									<option <?php echo $cost == $post_value ? "selected='selected'" : ""; ?> value="<?php echo $cost; ?>">

										<?php echo wpj_show_price( $cost ); ?>

									</option>

								<?php } ?>

							</select>

						<?php } else {
							_e( 'Prices are not defined. Go to Jobster Settings > Payment Type > Job and define the prices.', 'wpjobster' );

						}

					} else {
						if (
							wpj_get_option( 'wpjobster_enable_fixed_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_hourly_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_daily_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_weekly_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_monthly_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_custom_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes'
							|| apply_filters( 'wpj_admin_price_type_condition_filter', false )
						) {

							// Multiple type of prices
							echo '<input type="text" style="width: 50%;" name="job_cost" value="' . get_post_meta( $pid, 'price', true ) . '" size="5" /> ';

							echo '<select name="price_type" style="width: calc(50% - 42px);">';

								if ( wpj_get_option( 'wpjobster_enable_fixed_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'fixed' ? "selected='selected'" : " " ) . ' value="fixed">' . __( 'fixed', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_hourly_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'hourly' ? "selected='selected'" : " " ) . ' value="hourly">' . __( 'hourly', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_daily_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'daily' ? "selected='selected'" : " " ) . ' value="daily">' . __( 'daily', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_weekly_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'weekly' ? "selected='selected'" : " " ) . ' value="weekly">' . __( 'weekly', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_monthly_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'monthly' ? "selected='selected'" : " " ) . ' value="monthly">' . __( 'monthly', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_custom_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'custom' ? "selected='selected'" : " " ) . ' value="custom">' . __( 'custom', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'package' ? "selected='selected'" : " " ) . ' value="package">' . __( 'package', 'wpjobster' ) . '</option>';
								}

								do_action( 'wpj_after_admin_job_price_type_field', $pid, $post_job_type );

							echo '</select>';

						} else {

							// Free input text
							if ( wpj_show_price_in_front() == true ) echo wpj_get_site_default_currency();

							echo '<input type="text" name="job_cost" class="do_input" value="' . get_post_meta( $pid, 'price', true ) . '" size="5" /> ';

							if ( wpj_show_price_in_front() == false ) echo wpj_get_site_default_currency();

						}

					} ?>
				</p>
			</li>

			<?php $wpjobster_location = wpj_get_option( 'wpjobster_location' );

			// TODO: Implement TomTom API in admin
			if ( $wpjobster_location == "yes" ) { ?>
				<li>
					<h2><?php _e( 'Location', 'wpjobster' ); ?>:</h2>

					<p class="lighter">
						<input class="js-location-autocomplete do_input" type="text" data-replaceplaceholder="<?php _e( 'Select a valid location', 'wpjobster' ) ?>" placeholder="<?php _e( 'Location', 'wpjobster' ) ?>" id="location_input" value="<?php echo get_post_meta( $pid, 'location_input', true ); ?>" name="location_input">
						<input id="lat" type="hidden" name="lat"  id="lat" value="<?php echo get_post_meta( $pid, 'lat', true ); ?>">
						<input id="long" type="hidden" name="long"  id="long" value="<?php echo get_post_meta( $pid, 'long', true ); ?>">
					</p>
				</li>
			<?php } ?>

			<li>
				<h2><?php _e( 'Delivery (days)', 'wpjobster' ); ?>:</h2>
				<p><input type="text" size="10" name="max_days" class="do_input" value="<?php echo get_post_meta( $pid, 'max_days', true ); ?>" /></p>
			</li>

			<li>
				<h2><?php _e( 'Video Link(s)', 'wpjobster' ); ?>:</h2>

				<?php $videos = get_post_meta( $pid, 'video_link', true );

				if ( $videos ) {

					foreach ( $videos as $key => $value ) { ?>

						<p><input type="text" size="10" name="video_link[]" class="do_input" value="<?php echo $value; ?>" /></p>

					<?php }

				} else { ?>

					<p><input type="text" size="10" name="video_link[]" class="do_input" /></p>

				<?php } ?>

			</li>

			<?php $wpjobster_enable_shipping = wpj_get_option( 'wpjobster_enable_shipping' );

			if ( $wpjobster_enable_shipping == "yes" ) { ?>
				<li>
					<h2><?php echo sprintf( __( 'Requires shipping? (%s)', 'wpjobster' ), wpj_get_site_default_currency() ); ?></h2>

					<p>
						<input type="text" size="5" class="do_input"  name="shipping" value="<?php echo ( empty( $shipping ) ? get_post_meta( $pid, 'shipping', true ) : $shipping ); ?>" />
					</p>
				</li>
			<?php } ?>

			<li>
				<h2><?php _e( 'Fake Queue', 'wpjobster' ); ?>:</h2>
				<p><input type="text" size="5" name="fake_queue" class="do_input" value="<?php echo get_post_meta( $pid, 'fake_queue', true ); ?>" /></p>
			</li>

			<li>
				<p><input type="checkbox" value="1" name="active" <?php if ( $active == '1' ) echo ' checked="checked" '; ?> /><?php _e( "Active Job?", 'wpjobster' ); ?></p>
			</li>

			<li>
				<p><input type="checkbox" value="1" name="closed" <?php if ( $t == '1' ) echo ' checked="checked" '; ?> /><?php _e( "Closed", 'wpjobster' ); ?></p>
			</li>

			<li>
				<p><input type="checkbox" value="yes" name="lets_meet" <?php if ( get_post_meta( $pid, 'lets_meet', true ) == 'yes' ) echo ' checked="checked" '; ?> /><?php _e( "Let's Meet", 'wpjobster' ); ?></p>
			</li>
		</ul>
	<?php }
}

function wpjobster_theme_job_featured() {
	global $post;

	$pid = $post->ID;

	$dt_homepage      = get_post_meta( $pid, 'home_featured_until', true );
	$dt_categories    = get_post_meta( $pid, 'category_featured_until', true );
	$dt_subcategories = get_post_meta( $pid, 'subcategory_featured_until', true );

	$date_format      = wpj_get_option( 'date_format' );

	$h_start_date     = wpj_get_featured_start_date( 'homepage', $pid );
	$h_end_date       = wpj_get_featured_end_date( $h_start_date );
	$c_start_date     = wpj_get_featured_start_date( 'category', $pid );
	$c_end_date       = wpj_get_featured_end_date( $c_start_date);
	$s_start_date     = wpj_get_featured_start_date( 'subcategory', $pid );
	$s_end_date       = wpj_get_featured_end_date( $s_start_date ); ?>

	<ul id="post-new5">
		<li>
			<input type="checkbox" value="yes" name="f_homepage" <?php if ( is_numeric( $dt_homepage ) ) echo ' checked="checked" '; ?> />

			<?php _e( 'Homepage', 'wpjobster' );

			if ( is_numeric( $dt_homepage ) ) {
				echo '<br><strong>';
					echo 'between(' . wpj_date( $date_format, wpj_get_featured_start_date_from_end_date($dt_homepage ) ) . " - " . wpj_date( $date_format, $dt_homepage ) . ')';
				echo '</strong>';
			} else {
				echo '<br><strong>';
					echo 'First available(' . wpj_date( $date_format, $h_start_date ) . " - " . wpj_date( $date_format, $h_end_date ) . ')';
				echo '</strong>';
			} ?>
		</li>

		<li>
			<input type="checkbox" value="yes" name="f_categories" <?php if ( is_numeric( $dt_categories ) ) echo ' checked="checked" '; ?> />

			<?php _e( 'Categories', 'wpjobster' );

			if ( is_numeric( $dt_categories ) ) {
				echo '<br><strong>';
					echo 'between(' . wpj_date( $date_format, wpj_get_featured_start_date_from_end_date( $dt_categories ) ) . " - " . wpj_date( $date_format, $dt_categories ) . ')';
				echo '</strong>';
			} else {
				echo '<br><strong>';
					echo 'First available(' . wpj_date( $date_format, $c_start_date ) . " - " . wpj_date( $date_format, $c_end_date ) . ')';
				echo '</strong>';
			} ?>
		</li>

		<li>
			<input type="checkbox" value="yes" name="f_subcategories" <?php if ( is_numeric( $dt_subcategories ) ) echo ' checked="checked" '; ?> />

			<?php _e( 'Subcategories', 'wpjobster' );

			if ( is_numeric( $dt_subcategories ) ) {
				echo '<br><strong>';
					echo 'between(' . wpj_date( $date_format, wpj_get_featured_start_date_from_end_date( $dt_subcategories ) ) . " - " . wpj_date( $date_format, $dt_subcategories ) . ')';
				echo '</strong>';
			} else {
				echo '<br><strong>';
					echo 'First available(' . wpj_date( $date_format, $s_start_date ) . " - " . wpj_date( $date_format, $s_end_date ) . ')';
				echo '</strong>';
			} ?>
		</li>
	</ul>
<?php }

function wpjobster_job_attachments() {
	global $post;

	$value = get_post_custom( $post->ID );
	$instant_attachments = ! empty( $value["job_any_attachments"][0] ) ? $value["job_any_attachments"][0] : '';
	if ( wpj_post_has_attachments( $instant_attachments ) ) {
		wpj_display_attachments_list( $instant_attachments, $post->ID, '', '', '', true, false );
	}
}

function wpjobster_preview_job_attachments() {
	global $post;

	$value = get_post_custom( $post->ID );
	$preview_job_attachments = ! empty( $value["preview_job_attachments"][0] ) ? $value["preview_job_attachments"][0] : '';
	if ( wpj_post_has_attachments( $preview_job_attachments ) ) {
		wpj_display_attachments_list( $preview_job_attachments, $post->ID, '', '', '', true, false );
	}
}

function wpjobster_theme_job_instructions() {
	global $post;

	if ( wpj_get_option( 'wpjobster_buyer_instructions_job_enabled' ) == 'yes' ) { ?>
		<input type="checkbox" value="yes" name="buyer_instructions" <?php if ( get_post_meta( $post->ID, 'buyer_instructions', true ) == 'yes' ) echo ' checked="checked" '; ?> /><?php _e( "Display instructions to job page", 'wpjobster' ); ?>
	<?php } ?>

	<textarea cols="60" rows="5" name="instruction_box">
		<?php echo get_post_meta( $post->ID, 'instruction_box', true ); ?>
	</textarea>
<?php }

if (!function_exists( 'wpjobster_theme_job_rejected' )) {

	function wpjobster_theme_job_rejected() {
		global $post;

		$pid        = $post->ID;
		$aid        = $post->post_author;
		$user_level = wpj_get_user_level( $aid );
		$sts        = wpj_get_option( 'wpjobster_get_level' . $user_level . '_extras' );

		$rejected_title            = get_post_meta( $pid, "rejected_title", true );
		$rejected_description      = get_post_meta( $pid, "rejected_description", true );
		$rejected_instruction      = get_post_meta( $pid, "rejected_instruction", true );
		$rejected_tag              = get_post_meta( $pid, "rejected_tag", true );
		$rejected_image            = get_post_meta( $pid, "rejected_image", true );
		$rejected_audio            = get_post_meta( $pid, "rejected_audio", true );
		$rejected_video            = get_post_meta( $pid, "rejected_video", true );
		$rejected_preview          = get_post_meta( $pid, "rejected_preview", true );
		$rejected_instant_delivery = get_post_meta( $pid, "rejected_instant_delivery", true );
		$rejected_extra[1]         = get_post_meta( $pid, "rejected_extra1", true );
		$rejected_extra[2]         = get_post_meta( $pid, "rejected_extra2", true );
		$rejected_extra[3]         = get_post_meta( $pid, "rejected_extra3", true );
		$rejected_extra[4]         = get_post_meta( $pid, "rejected_extra4", true );
		$rejected_extra[5]         = get_post_meta( $pid, "rejected_extra5", true );
		$rejected_extra[6]         = get_post_meta( $pid, "rejected_extra6", true );
		$rejected_extra[7]         = get_post_meta( $pid, "rejected_extra7", true );
		$rejected_extra[8]         = get_post_meta( $pid, "rejected_extra8", true );
		$rejected_extra[9]         = get_post_meta( $pid, "rejected_extra9", true );
		$rejected_extra[10]        = get_post_meta( $pid, "rejected_extra10", true );

		$rejected_title_comment            = get_post_meta( $pid, "rejected_title_comment", true );
		$rejected_description_comment      = get_post_meta( $pid, "rejected_description_comment", true );
		$rejected_instruction_comment      = get_post_meta( $pid, "rejected_instruction_comment", true );
		$rejected_tag_comment              = get_post_meta( $pid, "rejected_tag_comment", true );
		$rejected_image_comment            = get_post_meta( $pid, "rejected_image_comment", true );
		$rejected_audio_comment            = get_post_meta( $pid, "rejected_audio_comment", true );
		$rejected_video_comment            = get_post_meta( $pid, "rejected_video_comment", true );
		$rejected_preview_comment          = get_post_meta( $pid, "rejected_preview_comment", true );
		$rejected_instant_delivery_comment = get_post_meta( $pid, "rejected_instant_delivery_comment", true );
		$rejected_extra1_comment           = get_post_meta( $pid, "rejected_extra1_comment", true );
		$rejected_extra2_comment           = get_post_meta( $pid, "rejected_extra2_comment", true );
		$rejected_extra3_comment           = get_post_meta( $pid, "rejected_extra3_comment", true );
		$rejected_extra4_comment           = get_post_meta( $pid, "rejected_extra4_comment", true );
		$rejected_extra5_comment           = get_post_meta( $pid, "rejected_extra5_comment", true );
		$rejected_extra6_comment           = get_post_meta( $pid, "rejected_extra6_comment", true );
		$rejected_extra7_comment           = get_post_meta( $pid, "rejected_extra7_comment", true );
		$rejected_extra8_comment           = get_post_meta( $pid, "rejected_extra8_comment", true );
		$rejected_extra9_comment           = get_post_meta( $pid, "rejected_extra9_comment", true );
		$rejected_extra10_comment          = get_post_meta( $pid, "rejected_extra10_comment", true); ?>

		<table width="100%">

			<tr>
				<td><?php _e( "Rejected Title", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_title" <?php if ( $rejected_title == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_title_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_title_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Description", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_description" <?php if ( $rejected_description == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_description_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_description_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Instruction", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_instruction" <?php if ( $rejected_instruction == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_instruction_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_instruction_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Tag", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_tag" <?php if ( $rejected_tag == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_tag_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_tag_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Image", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_image" <?php if ( $rejected_image == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_image_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_image_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Audio", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_audio" <?php if ( $rejected_audio == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_audio_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_audio_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Video", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_video" <?php if ( $rejected_video == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_video_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_video_comment', true ); ?></textarea></td>
			</tr>

			<?php if ( empty( $sts ) ) { $sts = 10; }

			for ( $k = 1; $k <= $sts; $k++ ) { ?>

				<tr>
					<td><?php echo sprintf( __( "Rejected Extra %d", 'wpjobster' ), $k ); ?></td>
					<td><input type="checkbox" value="1" name="rejected_extra<?php echo $k; ?>" <?php if ( $rejected_extra[$k] == '1' ) echo ' checked="checked" '; ?> /></td>
					<td><textarea name="rejected_extra<?php echo $k; ?>_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_extra' . $k . '_comment', true ); ?></textarea></td>
				</tr>

			<?php } ?>

			<tr>
				<td><?php _e( "Rejected Job Preview", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_preview" <?php if ( $rejected_preview == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_preview_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_preview_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Instant Delivery", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="rejected_instant_delivery" <?php if ( $rejected_instant_delivery == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="rejected_instant_delivery_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'rejected_instant_delivery_comment', true ); ?></textarea></td>
			</tr>

		</table>
	<?php }
}