<?php

function wpj_display_notifications_page_content() { $notifications_class = new WPJ_Notifications(); ?>

	<div class="wrap">
		<h2 class="wpj-admin-title">Jobster - <?php _e( 'Notifications', 'wpjobster' ); ?></h2>

		<?php $notifications_class->saveNotifications(); $notifications_class->resetNotifications(); ?>

		<div id="usual2" class="usual wpj-admin-table-wrapper">

			<div class="wpj-admin-header js-notifications">
				<ul>
					<li><a href="#notifications"><?php _e( 'Notifications', 'wpjobster' ); ?></a></li>
					<li><a href="#legend"><?php _e( 'Legend', 'wpjobster' ); ?></a></li>
				</ul>
			</div>

			<!-- Email Notifications -->
			<div id="notifications">
				<table class="widefat post" cellspacing="0">
					<thead>
						<tr>
							<th class="vertical-align-middle">
								<?php _e( 'Email & SMS Notification Content', 'wpjobster' ); ?>

								<form method="post" action="" style="margin-left: auto;">

									<button class="button button-primary mr10 save-tab-notifications js-save-tab-notifications-trigger">
										<?php _e( 'Save current tab options', 'wpjobster' ); ?>
									</button>

									<button class="button button-primary mr10 save-all-notifications js-save-all-notifications-trigger">
										<?php _e( 'Save all options', 'wpjobster' ); ?>
									</button>

									<input onclick="if ( confirm( 'Are you sure you want to reset the emails to their original content?' ) ) return true; else event.stopPropagation(); event.preventDefault();" type="submit" class="button button-secondary mr10" name="reset_emails_post" title="Reset the emails to their original content" value="<?php _e( 'Reset Emails content', 'wpjobster' ); ?>" />

									<input onclick="if ( confirm( 'Are you sure you want to reset the SMS to their original content?' ) ) return true; else event.stopPropagation(); event.preventDefault();" type="submit" class="button button-secondary" name="reset_sms_post" title="Reset the SMS to their original content" value="<?php _e( 'Reset SMS content', 'wpjobster' ); ?>" />

								</form>

							</th>
						</tr>
					</thead>

					<tbody>
						<tr>
							<td style="text-align: left;">
								<div class="ui vertical accordion text menu acc-nav">

									<?php $notifications = wpj_get_notifications_array(); $i = 0;

									foreach ( $notifications as $notification ) {
										$j = 0; ?>

										<!-- Left menu items -->
										<div class="title <?php if ( array_key_exists( WPJ_Form::get( 'active_subtab' ), $notification['items'] ) || ( ! WPJ_Form::get( 'active_subtab' ) && $i == 0 ) ) { echo "active"; } ?>">
											<i class="dropdown icon"></i>
											<b><?php echo $notification["title"]; ?></b>
										</div>

										<div class="content menu <?php if ( array_key_exists( WPJ_Form::get( 'active_subtab' ), $notification['items'] ) || ( ! WPJ_Form::get( 'active_subtab' ) && $i == 0 ) ) { echo "active"; } ?>">

											<?php foreach ( $notification["items"] as $item_index => $item ) {
												if ( get_option( 'uz_email_' . $item_index . '_enable' ) == 'no' ) {
													$disabled = 'disabled';
												} else {
													$disabled = '';
												}

												if (
													( WPJ_Form::get( 'active_subtab' ) == $item_index )
													|| ( ! WPJ_Form::get( 'active_subtab' ) && $i == 0 && $j == 0 )
												) {
													$active = 'active';
												} else {
													$active = '';
												} ?>

												<!-- Left menu subitems -->
												<a
													class="item <?php echo $disabled . ' ' . $active; ?>"
													href="<?php bloginfo( 'url' ); ?>/wp-admin/admin.php?page=jobster-notifications&active_tab=notifications&active_subtab=<?php echo $item_index; ?>"
													data-item="uz_tabs_notification_<?php echo $item_index; ?>">
														<?php echo $item["title"] ?>
												</a>

												<?php $j++;
											} ?>

										</div>

										<?php $i++;
									} ?>

								</div>

								<div class="acc-cnt">

									<form method="post" action="" class="notifications-wrapper">

										<?php $i = 0;

										foreach ( $notifications as $notification ) { $j = 0;
											foreach ( $notification["items"] as $reason => $item ) {
												$reason_name = $item["title"];
												$reason_desc = $item["description"]; ?>

												<div id="<?php echo 'uz_tabs_notification_' . $reason; ?>" class="notification-wrapper hidden-tab <?php if ( ( WPJ_Form::get( 'active_subtab' ) == $reason ) || ( ! WPJ_Form::get( 'active_subtab' ) && $i == 0 && $j == 0 ) ) { echo "active"; } ?>">

													<!-- Shortcodes -->
													<div class="spntxt_bo"><?php echo $reason_desc; ?></div>

													<!-- Email notifications -->
													<table width="100%" class="wpj-admin-table mt20">

														<!-- Enable this email -->
														<tr>
															<td style="text-align: left;"><?php _e( 'Enable this EMAIL:', 'wpjobster' ); ?><br>
																<select name="uz_email_<?php echo $reason; ?>_enable">
																	<option <?php if ( get_option( 'uz_email_' . $reason . '_enable' ) == 'yes' ) echo 'selected="selected"'; ?> value="yes"><?php _e( 'Yes', 'wpjobster' ); ?></option>
																	<option <?php if ( get_option( 'uz_email_' . $reason . '_enable' ) == 'no' ) echo 'selected="selected"'; ?> value="no"><?php _e( 'No', 'wpjobster' ); ?></option>
																</select>
															</td>
														</tr>

														<?php $languages = wpj_get_preferred_languages();

														if ( $languages ) {
															foreach ( $languages as $lang => $lang_name ) { ?>

																<!-- Email subject -->
																<tr>
																	<td style="text-align: left;"><?php _e( 'Email Subject:', 'wpjobster' ); ?><?php echo ' (' . $lang_name . ')'; ?><br>
																		<input type="text" size="90" name="<?php echo 'uz_email_' . $reason . '_' . $lang . '_subject'; ?>" value="<?php echo wpj_stripslashes( get_option( 'uz_email_' . $reason . '_' . $lang . '_subject' ) ); ?>"/>
																	</td>
																</tr>

																<!-- Email content -->
																<tr>
																	<td style="text-align: left;" valign="top" ><?php _e( 'Email Content:', 'wpjobster' ); ?><?php echo ' (' . $lang_name . ')'; ?><br>

																		<textarea cols="90" rows="10" class="<?php echo 'uz_email_' . $reason . '_' . $lang . '_message'; ?> w100" name="<?php echo 'uz_email_' . $reason . '_' . $lang . '_message'; ?>"><?php echo wpj_stripslashes( get_option( 'uz_email_' . $reason . '_' . $lang . '_message' ) ); ?></textarea>
																	</td>
																</tr>

															<?php }

														} else { ?>

															<tr>
																<td>
																	<p><?php _e( 'No preferred language selected!', 'wpjobster' ); ?></p>
																	<p><?php _e( 'You must select at least one language in the Languages section of the Notify Settings menu in order to edit the content of the emails.', 'wpjobster' ); ?></p>
																</td>
															</tr>

														<?php } ?>

													</table>

													<!-- SMS notifications -->
													<table width="100%" class="wpj-admin-table mt20 <?php if ( ! wpj_is_allowed( 'sms_notifications' ) ) { echo "wpjobster-disabled-settings"; } ?>">

														<!-- Enable this SMS -->
														<tr>
															<td style="text-align: left;"><?php _e( 'Enable this SMS:', 'wpjobster' ); ?><br>
																<select name="uz_sms_<?php echo $reason; ?>_enable">
																	<option <?php if ( get_option( 'uz_sms_' . $reason . '_enable' ) == 'yes' ) echo 'selected="selected"'; ?> value="yes"><?php _e( 'Yes', 'wpjobster' ); ?></option>
																	<option <?php if ( get_option( 'uz_sms_' . $reason . '_enable' ) == 'no' ) echo 'selected="selected"'; ?> value="no"><?php _e( 'No', 'wpjobster' ); ?></option>
																</select>
															</td>
														</tr>

														<?php $languages = wpj_get_preferred_languages();
														
														if ( $languages ) {
															foreach ( $languages as $lang => $lang_name ) { ?>

																<!-- SMS content -->
																<tr>
																	<td style="text-align: left;" valign="top" ><?php _e( 'SMS Content:', 'wpjobster' ); ?><?php echo ' (' . $lang_name . ')'; ?><br>
																	<textarea cols="80" rows="10" name="<?php echo 'uz_sms_' . $reason . '_' . $lang . '_message'; ?>" class="w100"><?php echo wpj_stripslashes( get_option( 'uz_sms_' . $reason . '_' . $lang . '_message' ) ); ?></textarea></td>
																</tr>

															<?php }

														} else { ?>

															<tr>
																<td>
																	<p><?php _e( 'No preferred language selected!', 'wpjobster' ); ?></p>
																	<p><?php _e( 'You must select at least one language in the Languages section of the Notify Settings menu in order to edit the content of the emails.', 'wpjobster' ); ?></p>
																</td>
															</tr>

														<?php } ?>

													</table>

													<!-- Save options -->
													<div class="db mt20">
														<input type="submit" class="button-secondary save-tab-notifications js-save-tab-notifications-button" value="<?php _e( 'Save current tab options', 'wpjobster' ); ?>"/>
													</div>

												</div>

											<?php $i++; }
										$j++; } ?>

										<!-- Save all options -->
										<div class="db mt10">
											<input type="submit" class="button-primary save-all-notifications js-save-all-notifications-button" value="<?php _e( 'Save all options', 'wpjobster' ); ?>"/>
										</div>

									</form>

								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div><!-- END notifications TAB -->

			<!-- Legend -->
			<div id="legend">
				<table class="widefat post" cellspacing="0">
					<thead>
						<tr>
							<th colspan="2" style="text-align: left;"><?php _e( 'All tags legend<br>You can NOT use all of them in each email, please see the available shortcodes list from top!', 'wpjobster' ); ?></th>
						</tr>
					</thead>

					<?php $legend_info = $notifications_class->getLegendInfo(); ?>

					<tbody>

						<?php foreach ( $legend_info as $key => $value ) { ?>

							<tr>
								<td class="uppercase color-20c497"><b><?php echo $key; ?></b></td>
								<td></td>
							</tr>

							<?php foreach ( $value as $shortcode => $description ) { ?>

								<tr>
									<td><b><?php echo '##' . $shortcode . '##'; ?></b></td>
									<td><?php echo $description; ?></td>
								</tr>

							<?php }

						} ?>

					</tbody>
				</table>
			</div><!-- END legend TAB -->

		</div>
	</div>

<?php }

add_action( 'admin_enqueue_scripts', 'wpj_admin_load_tinyMCE' );
function wpj_admin_load_tinyMCE() {
	if ( isset( $_GET['page'] ) && $_GET['page'] == 'jobster-notifications' && wpj_get_option( 'wpjobster_allow_html_emails' ) == 'yes' ) {
		wp_enqueue_script( 'tinymce_js_main', includes_url() . 'js/tinymce/tinymce.min.js' );
		wp_enqueue_script( 'tinymce_js_plugin', includes_url() . 'js/tinymce/plugins/compat3x/plugin.min.js' );
	}
}

class WPJ_Notifications {
	public function saveNotifications() {
		if ( ! empty( $_POST ) ) {
			foreach ( $_POST as $key => $value ) {
				if ( str_contains( $key, 'uz_email_' ) )
					update_option( $key, $value );

				if ( str_contains( $key, 'uz_sms_' ) ) {
					if ( wpj_is_allowed( 'sms_notifications' ) )
						update_option( $key, $value );

					else
						$not_allowed = 1;
				}
			}

			if ( ! empty( $not_allowed ) ) {
				if ( class_exists( 'Redux' ) ) Redux::set_option( 'jobster_settings', 'wpjobster_sms_gateways_enable', '-' ); ?>

				<div class="error notice">
					<p>Could not save SMS settings. Please <a href="https://wpjobster.com/buy/?utm_source=upgrade-feature-notice" target="_blank">upgrade</a> your license to Entrepreneur in order to use this feature.</p>
				</div>

			<?php }

			echo '<div class="updated fade"><p>' . __( 'Notifications settings saved!', 'wpjobster' ) . '</p></div>';
		}
	}

	public function resetNotifications() {
		if ( isset( $_POST['reset_emails_post'] ) )
			include_once get_template_directory() . '/admin/first-run/emails.php';

		if ( isset( $_POST['reset_sms_post'] ) )
			include_once get_template_directory() . '/admin/first-run/sms.php';
	}

	public function getLegendInfo() {
		$user_arr = [
			'receiver_username'       => __( "the person that will receive the emails.", "wpjobster" ),
			'receiver_email'          => __( "the email address of the user", "wpjobster" ),
			'sender_username'         => __( "the other person involved in the transaction.", "wpjobster" ),
			'username'                => __( "this is used mostly for emails sent to admin, because receiver_username woudn't make sense", "wpjobster" ),
			'user_email'              => __( "this is used mostly for emails sent to admin, because receiver_email woudn't make sense", "wpjobster" ),
			'password'                => __( "the auto generated password for old nonajax registration", "wpjobster" ),
			'password_reset_link'     => __( "the password reset link", "wpjobster" ),
			'email_verification'      => __( "the email verification link", "wpjobster" ),
			'private_message_excerpt' => __( "the private message excerpt", "wpjobster" ),
			'private_message_content' => __( "the private message content", "wpjobster" )
		];

		$service_arr = [
			'all_featured_info' => __( "the periods and pages of the job that will be featured", "wpjobster" ),
			'job_name'          => __( "new job's title", "wpjobster" ),
			'job_link'          => __( "link for the new job", "wpjobster" ),
			'request_name'      => __( "new request's title", "wpjobster" ),
			'request_link'      => __( "link for the new request", "wpjobster" )
		];

		$order_arr = [
			'current_level'         => __( "current level of the receiver", "wpjobster" ),
			'payment_type'          => __( "payment type used for transaction", "wpjobster" ),
			'payment_amount'        => __( "payment amount for current transaction", "wpjobster" ),
			'mc_gross'              => __( "gross amount for current transaction", "wpjobster" ),
			'processing_fees'       => __( "processing fee amount for current transaction", "wpjobster" ),
			'tax_amount'            => __( "tax amount for current transaction", "wpjobster" ),
			'transaction_number'    => __( "transaction number", "wpjobster" ),
			'transaction_page_link' => __( "transaction page link", "wpjobster" )
		];

		$withdrawal_arr = [
			'amount_withdrawn'              => __( "amount withdrawn, including", "wpjobster" ),
			'withdraw_method'               => __( "withdraw method", "wpjobster" ),
			'withdrawal_email_verification' => __( "withdrawal verification link", "wpjobster" ),
			'withdrawal_username'           => __( "withdraw username for admin email", "wpjobster" ),
			'withdrawal_amount'             => __( "withdraw amount for admin email", "wpjobster" ),
			'withdrawal_method'             => __( "withdraw method for admin email", "wpjobster" ),
			'withdrawal_link'               => __( "user withdrawal link", "wpjobster" )
		];

		$topup_arr = [
			'amount_updated'             => __( "balance amount after topup", "wpjobster" ),
			'amount_updated_in_currency' => __( "balance amount after topup for current currency", "wpjobster" ),
			'payment_gateway'            => __( "payment gateway used for topup", "wpjobster" )
		];

		$subscription_arr = [
			'current_subscription_level'  => __( "current subscription level", "wpjobster" ),
			'current_subscription_amount' => __( "current subscription amount", "wpjobster" ),
			'current_subscription_period' => __( "current subscription period", "wpjobster" ),
			'next_subscription_level'     => __( "next subscriptionlevel", "wpjobster" ),
			'next_subscription_amount'    => __( "next subscription amount", "wpjobster" ),
			'next_billing_date'           => __( "next subscription date", "wpjobster" )
		];

		$exchange_arr = [
			'main_currency'      => __( "exchange - site currency", "wpjobster" ),
			'old_price'          => __( "exchange - old currency value", "wpjobster" ),
			'new_price'          => __( "exchange - new currency value", "wpjobster" ),
			'percent_difference' => __( "exchange - percent difference between old and new currency value", "wpjobster" )
		];

		$link_arr = [
			'my_account_url'       => __( "your website's my account link", "wpjobster" ),
			'private_message_link' => __( "the link for the conversation with a particular user", "wpjobster" ),
			'admin_orders_url'     => __( "your website's admin orders link", "wpjobster" )
		];

		$site_arr = [
			'your_site_name' => __( "your website's name", "wpjobster" ),
			'your_site_url'  => __( "your website's homepage url", "wpjobster" ),
		];

		return [
			__( 'User'        , 'wpjobster' ) => $user_arr,
			__( 'Service'     , 'wpjobster' ) => $service_arr,
			__( 'Order'       , 'wpjobster' ) => $order_arr,
			__( 'Withdrawal'  , 'wpjobster' ) => $withdrawal_arr,
			__( 'Topup'       , 'wpjobster' ) => $topup_arr,
			__( 'Subscription', 'wpjobster' ) => $subscription_arr,
			__( 'Exchange'    , 'wpjobster' ) => $exchange_arr,
			__( 'Link'        , 'wpjobster' ) => $link_arr,
			__( 'Site'        , 'wpjobster' ) => $site_arr,
		];
	}
}