<?php
// OFFER METABOXES //
function wpjobster_set_offer_metaboxes() {
	add_meta_box( 'offer_details', 'Offer Details', 'wpjobster_theme_offer_details', 'offer', 'side', 'high' );

	// Action
	do_action( 'wpj_after_admin_metaboxes', 'offer' );
}

if ( ! function_exists( 'wpjobster_theme_offer_details' ) ) {

	function wpjobster_theme_offer_details() {
		global $post;

		$pid        = $post->ID;
		$price      = get_post_meta( $pid, "price", true );
		$t          = get_post_meta( $pid, "closed", true );
		$active     = get_post_meta( $pid, "active", true );
		$buyer_id   = get_post_meta( $pid, "offer_buyer", true ); ?>

		<ul id="post-new4">
			<input name="fromadmin" type="hidden" value="1" />

			<li>
				<h2><?php echo sprintf( __( 'Buyer: <strong>%s</strong>', 'wpjobster' ), wpj_get_user_display_type( $buyer_id ) ); ?>></h2>
			</li>

			<li>
				<h2><?php _e( 'Job Price:', 'wpjobster' ); ?></h2>
				<p>

					<?php
					$post_job_type = WPJ_Form::post( 'price_type', get_post_meta( $pid, 'price_type', true ) );
					$price_type    = wpj_get_option( 'wpjobster_price_type' );

					if ( $price_type == "fixed_amount" ) {
						echo wpj_show_price( wpj_get_option( 'wpjobster_job_fixed_amount' ) );

					} elseif ( $price_type == "dropdown_values" ) {
						$dropdown_values = wpj_get_option( 'newcost' );
						$post_value      = WPJ_Form::post( 'job_cost', get_post_meta( $pid, 'price', true ) );

						if ( $dropdown_values ) { ?>

							<select name="job_cost">

								<?php foreach ( $dropdown_values as $cost ) { ?>

									<option <?php echo $cost == $post_value ? "selected='selected'" : ""; ?> value="<?php echo $cost; ?>">

										<?php echo wpj_show_price( $cost ); ?>

									</option>

								<?php } ?>

							</select>

						<?php } else _e( 'Prices are not defined. Go to Jobster Settings > Payment Type > Job and define the prices.', 'wpjobster' );

					} else {
						if (
							wpj_get_option( 'wpjobster_enable_fixed_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_hourly_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_daily_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_weekly_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_monthly_rate', true ) == 'yes'
							|| wpj_get_option( 'wpjobster_enable_custom_rate', true ) == 'yes'
						) { // Multiple type of prices ?>

							<input type="text" style="width: 76px;" name="job_cost" value="<?php echo get_post_meta( $pid, 'price', true ); ?>" size="5" />

							<select name="price_type" style="width: 76px; height: 25px; margin-top: -4px;">

								<?php
								if ( wpj_get_option( 'wpjobster_enable_fixed_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'fixed' ? "selected='selected'" : " " ) . ' value="fixed">' . __( 'fixed', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_hourly_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'hourly' ? "selected='selected'" : " " ) . ' value="hourly">' . __( 'hourly', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_daily_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'daily' ? "selected='selected'" : " " ) . ' value="daily">' . __( 'daily', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_weekly_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'weekly' ? "selected='selected'" : " " ) . ' value="weekly">' . __( 'weekly', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_monthly_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'monthly' ? "selected='selected'" : " " ) . ' value="monthly">' . __( 'monthly', 'wpjobster' ) . '</option>';
								}
								if ( wpj_get_option( 'wpjobster_enable_custom_rate', true ) == 'yes' ) {
									echo '<option ' . ( $post_job_type == 'custom' ? "selected='selected'" : " " ) . ' value="custom">' . __( 'custom', 'wpjobster' ) . '</option>';
								} ?>

							</select>

						<?php } else { // Free input text
							if ( wpj_show_price_in_front() == true )
								echo wpj_get_site_default_currency();

							echo '<input type="text" name="job_cost" class="do_input" value="' . get_post_meta( $pid, 'price', true ) . '" size="5" /> ';

							if ( wpj_show_price_in_front() == false )
								echo wpj_get_site_default_currency();

						}
					} ?>

				</p>
			</li>

			<li>
				<h2><?php _e( 'Delivery', 'wpjobster' ); ?>:</h2>
				<p><input type="text" size="10" name="max_days" class="do_input" value="<?php echo get_post_meta( $pid, 'max_days', true ); ?>" />&nbsp;<?php _e( 'days', 'wpjobster' ); ?></p>
			</li>

			<li>
				<p>
					<input type="checkbox" value="1" name="active" <?php if ( get_post_meta( $pid, 'offer_accepted', true ) == 1 ) echo ' checked="checked" '; ?> disabled />
					<?php _e( "Offer Accepted", 'wpjobster' ); ?>
				</p>
			</li>

			<li>
				<p>
					<input type="checkbox" value="1" name="active" <?php if ( get_post_meta( $pid, 'offer_declined', true ) == 1 ) echo ' checked="checked" '; ?> disabled />
					<?php _e( "Offer Declined", 'wpjobster' ); ?>
				</p>
			</li>

			<li>
				<p>
					<input type="checkbox" value="1" name="active" <?php if ( get_post_meta( $pid, 'offer_withdrawn', true ) == 1 ) echo ' checked="checked" '; ?> disabled />
					<?php _e( "Offer Withdrawn", 'wpjobster' ); ?>
				</p>
			</li>

			<li>
				<p>
					<input type="checkbox" value="1" name="active" <?php if ( get_post_meta( $pid, 'offer_expired', true ) == 1 ) echo ' checked="checked" '; ?> disabled />
					<?php _e( "Offer Expired", 'wpjobster' ); ?>
				</p>
			</li>

		</ul>

	<?php }
}