<?php
// Custom post states for admin pages
add_filter( 'display_post_states', 'wpj_custom_post_states', 10, 2 );
function wpj_custom_post_states( $states, $post ) {

	if ( ! isset( $post->ID ) ) return $states;

	// Theme
	if ( $post->ID == wpj_get_option( 'wpjobster_not_found_page_id' ) ) {
		$states[] = __( 'Not Found Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'main_page_url_user' ) ) {
		$states[] = __( 'Logged In Front Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_levels_page_id' ) ) {
		$states[] = __( 'Level Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_how_it_works_page_id' ) ) {
		$states[] = __( 'How it Works Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_privacy_policy_page_id' ) ) {
		$states[] = __( 'Privacy Policy Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_terms_of_service_page_id' ) ) {
		$states[] = __( 'Terms of Service Page', 'wpjobster' );
	}

	// Blog
	if ( $post->ID == wpj_get_option( 'wpjobster_all_blog_posts_page_id' ) ) {
		$states[] = __( 'Articles Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_single_blog_page_id' ) ) {
		$states[] = __( 'Single Blog Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_all_news_page_id' ) ) {
		$states[] = __( 'News Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_single_news_page_id' ) ) {
		$states[] = __( 'Single News Page', 'wpjobster' );
	}

	// Job
	if ( $post->ID == wpj_get_option( 'wpjobster_single_job_page_id' ) ) {
		$states[] = __( 'Single Job Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_page_id' ) ) {
		$states[] = __( 'My Account Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_favorites_page_id' ) ) {
		$states[] = __( 'My Favorites Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_all_categories_page_id' ) ) {
		$states[] = __( 'All Categories Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_advanced_search_id' ) ) {
		$states[] = __( 'Job Search Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_post_new_page_id' ) ) {
		$states[] = __( 'New Job Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_jobs_map_overview_page_id' ) ) {
		$states[] = __( 'Jobs Map Overview Page', 'wpjobster' );
	}

	// Request
	if ( $post->ID == wpj_get_option( 'wpjobster_single_request_page_id' ) ) {
		$states[] = __( 'Single Request Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_requests_page_id' ) ) {
		$states[] = __( 'My Requests Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) ) {
		$states[] = __( 'Request Search Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_new_request_page_id' ) ) {
		$states[] = __( 'New Request Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_all_requests_page_id' ) ) {
		$states[] = __( 'All Requests Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_all_proposals_page_id' ) ) {
		$states[] = __( 'All Proposals Page', 'wpjobster' );
	}

	// User
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ) ) {
		$states[] = __( 'User Settings Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_search_user_page_id' ) ) {
		$states[] = __( 'User Search Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_user_profile_page_id' ) ) {
		$states[] = __( 'User Profile Page', 'wpjobster' );
	}

	// User Verification
	if ( $post->ID == wpj_get_option( 'wpjobster_verify_email_page_id' ) ) {
		$states[] = __( 'Verify Email Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_verify_phone_page_id' ) ) {
		$states[] = __( 'Verify Phone Page', 'wpjobster' );
	}

	// Payment
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_sales_page_id' ) ) {
		$states[] = __( 'Sales Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_shopping_page_id' ) ) {
		$states[] = __( 'Shopping Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_payments_page_id' ) ) {
		$states[] = __( 'Payments Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_checkout_page_id' ) ) {
		$states[] = __( 'Checkout Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_badges_page_id' ) ) {
		$states[] = __( 'Checkout Badge Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_feature_page_id' ) ) {
		$states[] = __( 'Checkout Featured Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_subscriptions_page_id' ) ) {
		$states[] = __( 'Subscription Page', 'wpjobster' );
	}

	// Order
	if ( $post->ID == wpj_get_option( 'wpjobster_order_page_id' ) ) {
		$states[] = __( 'Order Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_topup_order_page_id' ) ) {
		$states[] = __( 'TopUp Order Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_reviews_page_id' ) ) {
		$states[] = __( 'My Ratings Page', 'wpjobster' );
	}

	// Notification
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_all_notifications_page_id' ) ) {
		$states[] = __( 'All Notifications Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ) ) {
		$states[] = __( 'Messages Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_email_settings_page_id' ) ) {
		$states[] = __( 'E-mail Settings Page', 'wpjobster' );
	}

	// Authentication
	if ( $post->ID == wpj_get_option( 'wpjobster_login_page_id' ) ) {
		$states[] = __( 'User Login Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_register_page_id' ) ) {
		$states[] = __( 'User Register Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_forgot_password_page_id' ) ) {
		$states[] = __( 'User Forgot Password Page', 'wpjobster' );
	}

	// AIO
	if ( $post->ID == wpj_get_option( 'wpjobster_new_ticket_page_id' ) ) {
		$states[] = __( 'New Ticket Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_single_ticket_page_id' ) ) {
		$states[] = __( 'Single Ticket Page', 'wpjobster' );
	}
	if ( $post->ID == wpj_get_option( 'wpjobster_ticket_list_page_id' ) ) {
		$states[] = __( 'Tickets list Page', 'wpjobster' );
	}

	return apply_filters( 'wpj_post_states_filter', $states, $post );
}