<?php
// PAGE METABOXES //
add_action( 'admin_init', function() {
	if ( WPJ_Form::get( 'post' ) == wpj_get_option( 'wpjobster_checkout_page_id' ) )
		add_meta_box( 'payment_instructions', 'Payment Instructions', 'wpj_payment_instructions_callback', 'page', 'normal', 'high' );

	if ( WPJ_Form::get( 'post' ) == wpj_get_option( 'wpjobster_post_new_page_id' ) )
		add_meta_box( 'job_packages_instructions', 'Job Packages Instructions', 'wpj_package_instructions_callback', 'page', 'normal', 'high' );

	add_meta_box( 'wpj_page_attributes', 'WPJ Page Attributes', 'wpj_page_attributes_callback', 'page', 'side', 'high' );

	// Action
	do_action( 'wpj_after_admin_metaboxes', 'page' );
});

function wpj_payment_instructions_callback() {
	global $post;

	echo '<label>' . __( 'Title', 'wpjobster' ) . '</label><br><input type="text" style="width: 100%;" name="payment_instructions_title" value="' . get_post_meta( $post->ID, 'payment_instructions_title', true ) . '" />';
	echo '<label>' . __( 'Description', 'wpjobster' ) . '</label><br><textarea style="width: 100%;" rows="6" name="payment_instructions_description">' . get_post_meta( $post->ID, 'payment_instructions_description', true ) . '</textarea>';
}

function wpj_package_instructions_callback() {
	global $post;
	$pid = $post->ID;

	$package_name_instructions         = get_post_meta( $pid, 'package_name_instructions', true );
	$package_description_instructions  = get_post_meta( $pid, 'package_description_instructions', true );
	$package_max_days_instructions     = get_post_meta( $pid, 'package_max_days_instructions', true );
	$package_revisions_instructions    = get_post_meta( $pid, 'package_revisions_instructions', true );
	$package_price_instructions        = get_post_meta( $pid, 'package_price_instructions', true );
	$package_cf_name_instructions      = get_post_meta( $pid, 'package_cf_name_instructions', true );
	$package_cf_checklist_instructions = get_post_meta( $pid, 'package_cf_checklist_instructions', true ); ?>

	<table class="packages" width="100%">
		<tbody>
			<tr>
				<th><?php _e( 'Package name', 'wpjobster'); ?></th>
				<td><textarea rows="2" name="package_name_instructions" type="text"><?php echo $package_name_instructions; ?></textarea></td>
			</tr>

			<tr>
				<th><?php _e( 'Package description', 'wpjobster'); ?></th>
				<td><textarea rows="2" name="package_description_instructions" type="text"><?php echo $package_description_instructions; ?></textarea></td>
			</tr>

			<tr>
				<th><?php _e( 'Package delivery time', 'wpjobster'); ?></td>
				<td><textarea rows="2" name="package_max_days_instructions" type="text"><?php echo $package_max_days_instructions; ?></textarea></td>
			</tr>

			<tr>
				<th><?php _e( 'Package revision', 'wpjobster'); ?></td>
				<td><textarea rows="2" name="package_revisions_instructions" type="text"><?php echo $package_revisions_instructions; ?></textarea></td>
			</tr>

			<tr>
				<th><?php _e( 'Package price', 'wpjobster'); ?></th>
				<td><textarea rows="2" name="package_price_instructions" type="text"><?php echo $package_price_instructions; ?></textarea></td>
			</tr>

			<tr>
				<th><?php _e( 'Package custom field name', 'wpjobster'); ?></th>
				<td><textarea rows="2" name="package_cf_name_instructions" type="text"><?php echo $package_cf_name_instructions; ?></textarea></td>
			</tr>

			<tr>
				<th><?php _e( 'Package custom field checklist', 'wpjobster'); ?></th>
				<td><textarea rows="2" name="package_cf_checklist_instructions" type="text"><?php echo $package_cf_checklist_instructions; ?></textarea></td>
			</tr>
		</tbody>
	</table>

<?php }

function wpj_page_attributes_callback() {
	global $post; ?>

	<div class="components-page-content mb8">
		<div class="mb5">
			<label><?php _e( 'Source of page content:', 'wpjobster' ); ?></label>
		</div>
		<div>
			<select name="page_content_source">
				<option <?php echo get_post_meta( $post->ID, 'page_content_source', true ) == 'page_builder' ? 'selected="selected' : ''; ?> value="page_builder"><?php _e( 'Page Builder', 'wpjobster' ); ?></option>
				<option <?php echo get_post_meta( $post->ID, 'page_content_source', true ) == 'code' ? 'selected="selected' : ''; ?> value="code"><?php _e( 'Code', 'wpjobster' ); ?></option>
			</select>
		</div>
	</div>

	<div class="components-page-content-reset mb8">
		<div class="mb5">
			<label><?php _e( 'Change the source content of all pages:', 'wpjobster' ); ?></label>
		</div>
		<div>
			<select name="page_content_source_all">
				<option value="">-</option>
				<option value="page_builder"><?php _e( 'Page Builder', 'wpjobster' ); ?></option>
				<option value="code"><?php _e( 'Code', 'wpjobster' ); ?></option>
			</select>
		</div>
	</div>

	<div class="components-page-content-import mb8">
		<div class="mb5">
			<label><?php _e( 'Import page content:', 'wpjobster' ); ?></label>
		</div>
		<div>
			<select name="page_content_import" class="js-import-page-content">
				<option value="">-</option>

				<?php foreach ( wpj_get_page_names( false ) as $page_id => $page_title ) { ?>

					<option value="<?php echo wpj_get_option( $page_id ); ?>"><?php echo $page_title; ?></option>

				<?php } ?>

			</select>
		</div>
	</div>

	<div class="components-page-assignment mb8">
		<div class="mb5">
			<label><?php _e( 'Page assignment:', 'wpjobster' ); ?></label>
		</div>
		<div>
			<a href="<?php echo admin_url( 'admin.php?page=jobster-settings&tab=' . wpj_get_settings_tab_number_by_field_id( 'page-assignments' ) ); ?>"><?php _e( 'Go to page assignment', 'wpjobster' ); ?></a>
		</div>
	</div>

	<div class="components-page-factory-reset mb8">
		<div class="mb5">
			<label><?php _e( 'Factory reset:', 'wpjobster' ); ?></label>
		</div>
		<div>
			<a class="cursor-pointer js-reset-page underline"><?php _e( 'Reset the page to its original content', 'wpjobster' ); ?></a>
		</div>
	</div>

<?php }