<?php
add_filter( 'add_menu_classes', 'wpj_show_pending_number_request');
function wpj_show_pending_number_request( $menu ) {
	$types = apply_filters( 'wpj_admin_pending_posts_filter', [ "job", "request" ] );

	foreach ( $types as $type ) {

		$num_posts = wp_count_posts( $type, 'readable' );

		// posts count
		$pending_count = 0;

		if ( ! empty( $num_posts->draft ) )
			$pending_count += $num_posts->draft;

		elseif ( ! empty( $num_posts->pending ) )
			$pending_count += $num_posts->pending;

		// menus to show
		if ( $type == 'post' )
			$menu_str = 'edit.php';

		else
			$menu_str = 'edit.php?post_type=' . $type;

		// add html
		foreach ( $menu as $menu_key => $menu_data ) {
			if ( $menu_str != $menu_data[2] ) { continue; }

			$menu[$menu_key][0] .= '
				<span class="update-plugins count-' . $pending_count . '">
					<span class="plugin-count">' . number_format_i18n( $pending_count ) . '</span>
				</span>
			';
		}
	}

	return $menu;
}