<?php
add_filter( 'manage_edit-request_columns', 'wpj_admin_request_info_label' );
function wpj_admin_request_info_label( $columns ) {
	$columns = [
		"cb"            => "<input type=\"checkbox\" />",
		"title"         => __( "Request Title", 'wpjobster' ),
		"author"        => __( "Author", 'wpjobster' ),
		"posted"        => __( "Posted On", 'wpjobster' ),
		"active"        => __( "Status", 'wpjobster' ),
		"active_reason" => __( "Status Reason", 'wpjobster' )
	];

	return $columns;
}

add_filter( 'post_row_actions', 'wpj_admin_request_post_row_action', 10, 2 );
function wpj_admin_request_post_row_action( $actions, $post ) {
	if ( $post->post_type == 'request' ) {
		if ( get_post_meta( $post->ID, 'active', true ) == 1 )
			$actions['deactivate'] = '<a href="' . get_bloginfo( 'url' ) . '/wp-admin/edit.php?post_type=request&post=' . $post->ID . '&activate=0">' . __( 'Deactivate', 'wpjobster' ) . '</a> ';

		else
			$actions['activate'] = '<a href="' . get_bloginfo( 'url' ) . '/wp-admin/edit.php?post_type=request&post=' . $post->ID . '&activate=1">' . __( 'Activate', 'wpjobster' ) . '</a> ';
	}

	return $actions;
}

add_action( 'manage_posts_custom_column', 'wpj_admin_request_info_action' );
function wpj_admin_request_info_action( $column ) {
	global $post;

	if ( $post->post_type == 'request' ) {

		if ( "ID" == $column ) echo $post->ID;

		elseif ( "description" == $column ) echo $post->ID;

		elseif ( "author" == $column ) echo $post->post_author;

		elseif ( "posted" == $column ) echo wpj_date( 'jS \of F, Y \<\b\r\/\>H:i:s', strtotime( $post->post_date ) );

		elseif ( "active" == $column ) echo get_post_meta( $post->ID, 'active', true ) == 1 ? __( 'Active', 'wpjobster' ) : __( 'Inactive', 'wpjobster' );

		elseif ( "active_reason" == $column ) echo get_post_meta( $post->ID, 'active', true ) == 1 ? get_post_meta( $post->ID, 'activate_reason', true ) : get_post_meta( $post->ID, 'deactivation_reason', true );

	}
}

add_action( 'load-edit.php', 'wpj_admin_change_request_status' );
function wpj_admin_change_request_status() {
	global $typenow;

	if ( $typenow == 'request' ) {
		if ( ! empty ( $_GET['post'] ) ) {
			if ( isset( $_GET['activate'] ) && $_GET['activate'] == '0' ) {
				wpj_deactivate_request( $_GET['post'], 'by_admin' );

			} elseif ( isset( $_GET['activate'] ) && $_GET['activate'] == '1' ) {
				wpj_activate_request( $_GET['post'], 'by_admin' );

			}
		}

		add_filter( 'posts_where' , 'wpj_admin_request_posts_status_where', 10, 2 );
	}
}

add_filter( 'bulk_actions-edit-request', 'wpj_admin_request_activate_all_label_bulk_actions' );
function wpj_admin_request_activate_all_label_bulk_actions( $bulk_actions ) {
	$bulk_actions['activate_all'] = __( 'Activate all', 'wpjobster');
	$bulk_actions['deactivate_all'] = __( 'Deactivate all', 'wpjobster');

	return $bulk_actions;
}

add_filter( 'handle_bulk_actions-edit-request', 'wpj_admin_request_activate_all_action_bulk_actions', 10, 3 );
function wpj_admin_request_activate_all_action_bulk_actions( $redirect_to, $doaction, $post_ids ) {
	if ( $doaction == 'activate_all' || $doaction == 'deactivate_all' ) {

		foreach ( $post_ids as $post_id ) {
			if ( $doaction == 'deactivate_all' ) {
				wpj_deactivate_request( $post_id, 'by_admin' );
			} elseif ( $doaction == 'activate_all' ) {
				wpj_activate_request( $post_id, 'by_admin' );
			}
		}

	}

	return $redirect_to;
}

add_filter( 'views_edit-request', 'wpj_filter_request_status' );
function wpj_filter_request_status( $views ) {
	global $wp;

	$class_active   = isset( $_GET[ 'active' ] ) && $_GET[ 'active' ] == 1 ? ' current' : '';
	$class_inactive = isset( $_GET[ 'active' ] ) && $_GET[ 'active' ] == 0 ? ' current' : '';

	$current_url = home_url( add_query_arg( [ $_GET ], $wp->request ) );

	$views['active'] = sprintf(
		'<a class="' . $class_active . '" href="%s">%s <span class="count">(%d)</span></a>',
		esc_url( $current_url . '&active=1' ),
		esc_html__( 'Active', 'wpjobster' ),
		wpj_get_posts_count_by_post_type( 'request', '1' )
	);

	$views['inactive'] = sprintf(
		'<a class="' . $class_inactive . '" href="%s">%s <span class="count">(%d)</span></a>',
		esc_url( $current_url . '&active=0' ),
		esc_html__( 'Inactive', 'wpjobster' ),
		wpj_get_posts_count_by_post_type( 'request', '0' )
	);

	return $views;
}

function wpj_admin_request_posts_status_where( $where, $wp_query_obj ) {
	global $wpdb;

	$post_type = ! empty( $wp_query_obj->query_vars['post_type'] ) ? $wp_query_obj->query_vars['post_type'] : '';

	if ( $post_type == 'request' ) {
		if ( ! empty( $_GET[ 'active' ] ) || ( isset( $_GET[ 'active' ] ) && $_GET[ 'active' ] == 0 ) ) {
			$where .= " AND ID IN (SELECT post_id FROM $wpdb->postmeta WHERE meta_key='active' AND meta_value='" . $_GET[ 'active' ] . "')";
		}
	}

	return $where;
}