<?php
// REQUEST METABOXES //
function wpjobster_set_request_metaboxes() {
	global $post;
	$value = get_post_custom( $post->ID );

	add_meta_box( 'job_budget_from',         'Budget From',         'wpjobster_request_budget_from',            'request', 'side',     'default' );
	add_meta_box( 'job_budget_to',           'Budget To',           'wpjobster_request_budget_to',              'request', 'side',     'default' );
	add_meta_box( 'job_max_days_to_deliver', 'Max days to deliver', 'wpjobster_request_max_days_to_deliver',    'request', 'side',     'default' );
	add_meta_box( 'request_deadline',        'Deadline',            'wpjobster_request_deadline',               'request', 'side',     'default' );
	add_meta_box( 'request_autoclose',       'Autoclose',           'wpjobster_request_autoclose',              'request', 'side',     'default' );
	add_meta_box( 'request_rejected',        'Request Rejected',    'wpjobster_request_rejected',               'request', 'advanced', 'high' );

	$request_attachments = ! empty( $value["request_attachments"][0] ) ? $value["request_attachments"][0] : '';
	if ( wpj_post_has_attachments( $request_attachments ) ) {
		add_meta_box( 'request_attachments', 'Attachments', 'wpjobster_request_attachments', 'request', 'side', 'default' );
	}

	// Action
	do_action( 'wpj_after_admin_metaboxes', 'request' );
}

function wpjobster_request_budget_from() {
	global $post;
	$value = get_post_custom( $post->ID );
	$budget_from = ( ! empty( $value["request_budget_from"][0] ) && $value["request_budget_from"][0] != '' ) ? $value["request_budget_from"][0] : '';
	echo '<input type="text" name="request_budget_from" value="' . $budget_from . '" id="request_budget_from" />';
}

function wpjobster_request_budget_to() {
	global $post;
	$value = get_post_custom( $post->ID );
	$budget_to = ( ! empty( $value["request_budget_to"][0] ) && $value["request_budget_to"][0] != '' ) ? $value["request_budget_to"][0] : '';
	echo '<input type="text" name="request_budget_to" value="' . $budget_to . '" id="request_budget_to" />';
}

function wpjobster_request_max_days_to_deliver() {
	global $post;
	$value = get_post_custom( $post->ID );
	$request_delivery = ( ! empty( $value["request_delivery"][0] ) && $value["request_delivery"][0] != '' ) ? $value["request_delivery"][0] : '';
	echo '<input type="text" name="request_delivery" value="' . $request_delivery . '" id="request_delivery" />';
}

function wpjobster_request_attachments() {
	global $post;
	$value = get_post_custom( $post->ID );
	$request_attachments = ! empty( $value["request_attachments"][0] ) ? $value["request_attachments"][0] : '';
	if ( wpj_post_has_attachments( $request_attachments ) ) {
		wpj_display_attachments_list( $request_attachments, $post->ID, '', '', '', '', false );
	}
}

function wpjobster_request_deadline() {
	global $post;
	$value = get_post_custom( $post->ID );
	$request_deadline = ! empty( $value["request_deadline"][0] ) ? date( 'Y-m-d', $value["request_deadline"][0] ) : '';
	echo '<input type="date" name="request_deadline" value="' . $request_deadline . '" id="request_deadline" />';
}

function wpjobster_request_autoclose() {
	global $post;
	$pid = $post->ID;
	$autoclose_value = get_post_meta( $pid, 'request_autoclose', true ); ?>

	<select name="request_autoclose">
		<option value="no" <?php if ( $autoclose_value != 'yes' ) echo 'selected="selected"'; ?>><?php _e( 'No', 'wpjobster' ); ?></option>
		<option value="yes" <?php if ( $autoclose_value == 'yes' ) echo 'selected="selected"'; ?>><?php _e( 'Yes', 'wpjobster' ); ?></option>
	</select>

<?php }

if ( ! function_exists( 'wpjobster_request_rejected' ) ) {
	function wpjobster_request_rejected() {
		global $post;
		$pid = $post->ID;

		$req_rejected_title       = get_post_meta( $pid, "req_rejected_title", true );
		$req_rejected_description = get_post_meta( $pid, "req_rejected_description", true );
		$req_rejected_tags        = get_post_meta( $pid, "req_rejected_tags", true );
		$req_rejected_deadline    = get_post_meta( $pid, "req_rejected_deadline", true );
		$req_rejected_budget_from = get_post_meta( $pid, "req_rejected_budget_from", true );
		$req_rejected_budget_to   = get_post_meta( $pid, "req_rejected_budget_to", true );
		$req_rejected_attachments = get_post_meta( $pid, "req_rejected_attachments", true ); ?>

		<input name="fromadmin" type="hidden" value="1" />

		<table width="100%">

			<tr>
				<td><?php _e( "Rejected Title", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_title" <?php if ( $req_rejected_title == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_title_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_title_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Description", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_description" <?php if ( $req_rejected_description == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_description_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_description_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Tags", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_tags" <?php if ( $req_rejected_tags == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_tags_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_tags_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Deadline", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_deadline" <?php if ( $req_rejected_deadline == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_deadline_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_deadline_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Budget From", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_budget_from" <?php if ( $req_rejected_budget_from == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_budget_from_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_budget_from_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Budget To", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_budget_to" <?php if ( $req_rejected_budget_to == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_budget_to_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_budget_to_comment', true ); ?></textarea></td>
			</tr>

			<tr>
				<td><?php _e( "Rejected Attachments", 'wpjobster' ); ?></td>
				<td><input type="checkbox" value="1" name="req_rejected_attachments" <?php if ( $req_rejected_attachments == '1' ) echo ' checked="checked" '; ?> /></td>
				<td><textarea name="req_rejected_attachments_comment" cols="40" rows="2"><?php echo get_post_meta( $pid, 'req_rejected_attachments_comment', true ); ?></textarea></td>
			</tr>

		</table>
	<?php }
}