<?php
add_action( 'wp_ajax_reset_page_action', 'wpj_reset_page_action' );
function wpj_reset_page_action( $post_id = '', $post_title = '', $with_update = true ) {
	if ( ! $post_id && isset( $_REQUEST['post_id'] ) ) $post_id = $_REQUEST['post_id'];
	if ( ! $post_title && isset( $_REQUEST['post_title'] ) ) $post_title = $_REQUEST['post_title'];

	if ( ! $post_title && $post_id ) {
		foreach ( wpj_get_page_names() as $page_id => $page_title ) {
			if ( wpj_get_option( $page_id ) == $post_id ) $post_title = $page_title;
		}
	}

	if ( ! $post_title ) $post_title = get_the_title( $post_id );

	$post_title = str_replace( 'Single ', '', trim( $post_title ) );

	$page_content = '';

	if ( $post_id || $post_title ) {
		$page_content = apply_filters( 'wpj_reset_page_action_content_filter', '', $post_id, $post_title );

		if ( ! $page_content ) {

			$data = wpj_get_data_with_cURL( 'https://democontent.wpjobster.com/v6/jobster_content_gutenberg.xml' );

			$data = str_replace( "<content:encoded>", "<contentEncoded>", $data );
			$data = str_replace( "</content:encoded>", "</contentEncoded>", $data );

			$data = str_replace( "<wp:post_id>", "<postId>", $data );
			$data = str_replace( "</wp:post_id>", "</postId>", $data );

			$xml  = simplexml_load_string( $data, 'SimpleXMLElement', LIBXML_NOCDATA );

			foreach ( $xml->channel->item as $item ) {
				if ( $post_title == $item->title ) {
					$page_content = ( string ) $item->contentEncoded;

					if ( $with_update && $page_content ) {
						$post_arr = [
							'ID'           => $post_id,
							'post_content' => $page_content,
						];

						wp_update_post( $post_arr );
					}
				}
			}

		}

	}

	if ( wpj_is_ajax_call() ) wp_die();

	return ! empty( $page_content ) ? $page_content : false;
}