<?php
// Save post changes from admin
add_action( 'save_post', 'wpjobster_save_custom_fields' );
if ( ! function_exists( 'wpjobster_save_custom_fields' ) ) {
	function wpjobster_save_custom_fields( $pid ) {
		global $post;

		$post = get_post( $pid );
		$aid  = $post->post_author;

		if ( isset( $_POST['fromadmin'] ) ) {

			/* CUSTOM FIELDS */
			$custom_field = new WPJ_Custom_Fields( $pid, $post->post_type );
			$custom_field->saveFieldsContent();

			if ( $post->post_type == 'job' ) { /* JOBS */

				$user_level = wpj_get_user_level( $aid );
				$sts        = wpj_get_option( 'wpjobster_get_level' . $user_level . '_extras' );

				if ( isset( $_POST['buyer_instructions'] ) ) {
					update_post_meta( $pid, 'buyer_instructions', trim( $_POST['buyer_instructions'] ) );
					update_post_meta( $pid, 'instruction_box', trim( $_POST['instruction_box'] ) );
				}

				if ( empty( $sts ) ) $sts = 10;

				for ( $k = 1; $k <= $sts; $k++ ) {
					if ( isset( $_POST['enable_extra_' . $k] ) ) {
						update_post_meta( $pid, 'extra' . $k . '_extra_enabled', true );

						$extra_price   = trim( $_POST['extra' . $k . '_price'] );
						$extra_content = trim( $_POST['extra' . $k . '_content'] );

						$extra_days = trim( $_POST['max_days_' . $k] );
						if ( !  empty( $extra_days ) && is_numeric( $extra_days ) && $extra_days > 0 ) {
							update_post_meta( $pid, 'max_days_ex_' . $k, $extra_days );
						} else {
							update_post_meta( $pid, 'max_days_ex_' . $k, 'instant' );
						}

						if ( ! empty( $extra_price ) && is_numeric( $extra_price ) && ! empty( $extra_content ) ) {
							update_post_meta( $pid, 'extra' . $k . '_price', $extra_price );
							update_post_meta( $pid, 'extra' . $k . '_content', $extra_content );
						} else {
							update_post_meta( $pid, 'extra' . $k . '_price', '' );
							update_post_meta( $pid, 'extra' . $k . '_content', '' );
						}

						if ( isset( $_POST['enable_multiples_' . $k] ) ) {
							update_post_meta( $pid, 'extra' . $k . '_enabled', true );
						} else {
							update_post_meta( $pid, 'extra' . $k . '_enabled', false );
						}

					} else {
						update_post_meta( $pid, 'extra' . $k . '_extra_enabled', false );

					}
				}

				$title_variable = get_post_meta( $pid, 'title_variable', true );

				update_post_meta( $pid, "title_variable", $title_variable );
				update_post_meta( $pid, "max_days", trim( $_POST['max_days'] ) );

				// Price
				$job_cost = htmlspecialchars( $_POST['job_cost'] );

				if ( wpj_get_option( 'wpjobster_price_type' ) == "fixed_amount" )
					$job_cost = wpj_get_option( 'wpjobster_job_fixed_amount' );

				update_post_meta( $pid, "price", $job_cost );

				if ( ! empty( $_POST['price_type'] ) )
					update_post_meta( $pid, "price_type", $_POST['price_type'] );

				$ending = get_post_meta( $pid, "ending", true );
				$closed = get_post_meta( $pid, "closed", true );
				update_post_meta( $pid, "shipping", trim( $_POST['shipping'] ) );

				wpj_update_job_rating_metas( $pid );

				if ( $_POST['active'] == '1' )
					update_post_meta( $pid, "active", '1' );
				else
					update_post_meta( $pid, "active", '0' );

				if ( isset( $_POST['closed'] ) && $_POST['closed'] == '1' ) {
					update_post_meta( $pid, "closed", '1' );

				} else {
					if ( $closed == "1" )
						update_post_meta( $pid, "ending", time() + 30 * 24 * 3600 );

					update_post_meta( $pid, "closed", '0' );

				}

				$home_featured_now        = get_post_meta( $pid, "home_featured_now", true );
				$category_featured_now    = get_post_meta( $pid, "category_featured_now", true );
				$subcategory_featured_now = get_post_meta( $pid, "subcategory_featured_now", true );

				if ( empty( $home_featured_now ) ) {
					update_post_meta( $pid, "home_featured_now", 'z' );
				}
				if ( empty( $category_featured_now ) ) {
					update_post_meta( $pid, "category_featured_now", 'z' );
				}
				if ( empty( $subcategory_featured_now ) ) {
					update_post_meta( $pid, "subcategory_featured_now", 'z' );
				}

				if ( isset( $_POST['lets_meet'] ) ) {
					$lets_meet = trim( strip_tags( htmlspecialchars( $_POST['lets_meet'] ) ) );
					update_post_meta( $pid, "lets_meet", $lets_meet );
				} else {
					update_post_meta( $pid, "lets_meet", "no" );
				}

				if ( isset( $_POST['video_link'] ) )
					update_post_meta( $pid, "video_link", $_POST['video_link'] );
				else
					update_post_meta( $pid, "video_link", '' );

				$wpjobster_location = wpj_get_option( 'wpjobster_location' );
				if ( $wpjobster_location == "yes" ) {
					if ( isset( $_POST['location_input'] ) )
						update_post_meta( $pid, "location_input", trim( htmlspecialchars( $_POST['location_input'] ) ) );
					else
						update_post_meta( $pid, "location_input", '' );

					if ( isset( $_POST['lat'] ) )
						update_post_meta( $pid, "lat", trim( htmlspecialchars( $_POST['lat'] ) ) );
					else
						update_post_meta( $pid, "lat", '' );

					if ( isset( $_POST['long'] ) )
						update_post_meta( $pid, "long", trim( htmlspecialchars( $_POST['long'] ) ) );
					else
						update_post_meta( $pid, "long", '' );
				}

				if ( isset( $_POST['fake_queue'] ) ) {
					update_post_meta( $pid, "fake_queue", trim( htmlspecialchars( $_POST['fake_queue'] ) ) );
					update_post_meta( $pid, 'fake_queue_exp', '' );

				} else {
					update_post_meta( $pid, "fake_queue", '' );
					update_post_meta( $pid, 'fake_queue_exp', '' );

				}

				// Featured image
				if ( ! has_post_thumbnail( $pid ) ) {
					$attachments = wpj_get_job_images( $pid );
					if ( $attachments ) set_post_thumbnail( $pid, $attachments[0]->ID );
				}

				// Featured homepage
				if ( isset( $_POST['f_homepage'] ) ) {
					wpj_mark_job_as_featured( 'homepage', $pid );

				} else {
					update_post_meta( $pid, 'home_featured_until', 'z' );
					update_post_meta( $pid, 'home_featured_now', 'z' );

				}

				// Featured category
				if ( isset( $_POST['f_categories'] ) ) {
					wpj_mark_job_as_featured( 'category', $pid );

				} else {
					update_post_meta( $pid, 'category_featured_until', 'z' );
					update_post_meta( $pid, 'category_featured_now', 'z' );

				}

				// Featured subcategory
				if ( isset( $_POST['f_subcategories'] ) ) {
					wpj_mark_job_as_featured( 'subcategory', $pid );

				} else {
					update_post_meta( $pid, 'subcategory_featured_until', 'z' );
					update_post_meta( $pid, 'subcategory_featured_now', 'z' );

				}

				if ( ! empty( $_POST['price_type'] ) && $_POST['price_type'] == "package" ) {
					update_post_meta( $pid, 'job_packages', 'yes' );

				} else {
					update_post_meta( $pid, 'job_packages', 'no' );

				}

				$wpjobster_packages = wpj_get_option( 'wpjobster_packages_enabled' );
				if ( $wpjobster_packages == "yes" ) {

					if ( isset( $_POST['package_name'] ) ) {
						update_post_meta( $pid, 'package_name', $_POST['package_name'] );
					}
					if ( isset( $_POST['package_description'] ) ) {
						update_post_meta( $pid, 'package_description', $_POST['package_description'] );
					}
					if ( isset( $_POST['package_max_days'] ) ) {
						update_post_meta( $pid, 'package_max_days', $_POST['package_max_days'] );
					}
					if ( isset( $_POST['package_revisions'] ) ) {
						update_post_meta( $pid, 'package_revisions', $_POST['package_revisions'] );
					}
					if ( isset( $_POST['package_price'] ) ) {
						update_post_meta( $pid, 'package_price', $_POST['package_price'] );
					}

					if ( isset( $_POST['rejected_package_name'] ) ) {
						update_post_meta( $pid, 'rejected_package_name', $_POST['rejected_package_name'] );
					}
					if ( isset( $_POST['rejected_package_description'] ) ) {
						update_post_meta( $pid, 'rejected_package_description', $_POST['rejected_package_description'] );
					}
					if ( isset( $_POST['rejected_package_max_days'] ) ) {
						update_post_meta( $pid, 'rejected_package_max_days', $_POST['rejected_package_max_days'] );
					}
					if ( isset( $_POST['rejected_package_revisions'] ) ) {
						update_post_meta( $pid, 'rejected_package_revisions', $_POST['rejected_package_revisions'] );
					}
					if ( isset( $_POST['rejected_package_price'] ) ) {
						update_post_meta( $pid, 'rejected_package_price', $_POST['rejected_package_price'] );
					}

				}

				if ( isset( $_POST['rejected_title'] ) && $_POST['rejected_title'] == '1' )
					update_post_meta( $pid, "rejected_title", '1' );
				else
					update_post_meta( $pid, "rejected_title", '0' );

				if ( isset( $_POST['rejected_description'] ) && $_POST['rejected_description'] == '1' )
					update_post_meta( $pid, "rejected_description", '1' );
				else
					update_post_meta( $pid, "rejected_description", '0' );

				if ( isset( $_POST['rejected_instruction'] ) && $_POST['rejected_instruction'] == '1' )
					update_post_meta( $pid, "rejected_instruction", '1' );
				else
					update_post_meta( $pid, "rejected_instruction", '0' );

				if ( isset( $_POST['rejected_tag'] ) && $_POST['rejected_tag'] == '1' )
					update_post_meta( $pid, "rejected_tag", '1' );
				else
					update_post_meta( $pid, "rejected_tag", '0' );

				if ( isset( $_POST['rejected_image'] ) && $_POST['rejected_image'] == '1' )
					update_post_meta( $pid, "rejected_image", '1' );
				else
					update_post_meta( $pid, "rejected_image", '0' );

				if ( isset( $_POST['rejected_audio'] ) && $_POST['rejected_audio'] == '1' )
					update_post_meta( $pid, "rejected_audio", '1' );
				else
					update_post_meta( $pid, "rejected_audio", '0' );

				if ( isset( $_POST['rejected_video'] ) && $_POST['rejected_video'] == '1' )
					update_post_meta( $pid, "rejected_video", '1' );
				else
					update_post_meta( $pid, "rejected_video", '0' );

				if ( isset( $_POST['rejected_preview'] ) && $_POST['rejected_preview'] == '1' )
					update_post_meta( $pid, "rejected_preview", '1' );
				else
					update_post_meta( $pid, "rejected_preview", '0' );

				if ( isset( $_POST['rejected_instant_delivery'] ) && $_POST['rejected_instant_delivery'] == '1' )
					update_post_meta( $pid, "rejected_instant_delivery", '1' );
				else
					update_post_meta( $pid, "rejected_instant_delivery", '0' );

				if ( isset( $_POST['rejected_extra1'] ) && $_POST['rejected_extra1'] == '1' )
					update_post_meta( $pid, "rejected_extra1", '1' );
				else
					update_post_meta( $pid, "rejected_extra1", '0' );

				if ( isset( $_POST['rejected_extra2'] ) && $_POST['rejected_extra2'] == '1' )
					update_post_meta( $pid, "rejected_extra2", '1' );
				else
					update_post_meta( $pid, "rejected_extra2", '0' );

				if ( isset( $_POST['rejected_extra3'] ) && $_POST['rejected_extra3'] == '1' )
					update_post_meta( $pid, "rejected_extra3", '1' );
				else
					update_post_meta( $pid, "rejected_extra3", '0' );
				if ( isset( $_POST['rejected_extra4'] ) && $_POST['rejected_extra4'] == '1' )
					update_post_meta( $pid, "rejected_extra4", '1' );
				else
					update_post_meta( $pid, "rejected_extra4", '0' );
				if ( isset( $_POST['rejected_extra5'] ) && $_POST['rejected_extra5'] == '1' )
					update_post_meta( $pid, "rejected_extra5", '1' );
				else
					update_post_meta( $pid, "rejected_extra5", '0' );
				if ( isset( $_POST['rejected_extra6'] ) && $_POST['rejected_extra6'] == '1' )
					update_post_meta( $pid, "rejected_extra6", '1' );
				else
					update_post_meta( $pid, "rejected_extra6", '0' );
				if ( isset( $_POST['rejected_extra7'] ) && $_POST['rejected_extra7'] == '1' )
					update_post_meta( $pid, "rejected_extra7", '1' );
				else
					update_post_meta( $pid, "rejected_extra7", '0' );
				if ( isset( $_POST['rejected_extra8'] ) && $_POST['rejected_extra8'] == '1' )
					update_post_meta( $pid, "rejected_extra8", '1' );
				else
					update_post_meta( $pid, "rejected_extra8", '0' );
				if ( isset( $_POST['rejected_extra9'] ) && $_POST['rejected_extra9'] == '1' )
					update_post_meta( $pid, "rejected_extra9", '1' );
				else
					update_post_meta( $pid, "rejected_extra9", '0' );
				if ( isset( $_POST['rejected_extra10'] ) && $_POST['rejected_extra10'] == '1' )
					update_post_meta( $pid, "rejected_extra10", '1' );
				else
					update_post_meta( $pid, "rejected_extra10", '0' );

				if ( isset( $_POST['rejected_title_comment'] ) )
					update_post_meta( $pid, "rejected_title_comment", trim( htmlspecialchars( $_POST['rejected_title_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_title_comment", '' );

				if ( isset( $_POST['rejected_description_comment'] ) )
					update_post_meta( $pid, "rejected_description_comment", trim( htmlspecialchars( $_POST['rejected_description_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_description_comment", '' );

				if ( isset( $_POST['rejected_instruction_comment'] ) )
					update_post_meta( $pid, "rejected_instruction_comment", trim( htmlspecialchars( $_POST['rejected_instruction_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_instruction_comment", '' );

				if ( isset( $_POST['rejected_tag_comment'] ) )
					update_post_meta( $pid, "rejected_tag_comment", trim( htmlspecialchars( $_POST['rejected_tag_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_tag_comment", '' );

				if ( isset( $_POST['rejected_image_comment'] ) )
					update_post_meta( $pid, "rejected_image_comment", trim( htmlspecialchars( $_POST['rejected_image_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_image_comment", '' );

				if ( isset( $_POST['rejected_audio_comment'] ) )
					update_post_meta( $pid, "rejected_audio_comment", trim( htmlspecialchars( $_POST['rejected_audio_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_audio_comment", '' );

				if ( isset( $_POST['rejected_video_comment'] ) )
					update_post_meta( $pid, "rejected_video_comment", trim( htmlspecialchars( $_POST['rejected_video_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_video_comment", '' );

				if ( isset( $_POST['rejected_preview_comment'] ) )
					update_post_meta( $pid, "rejected_preview_comment", trim( htmlspecialchars( $_POST['rejected_preview_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_preview_comment", '' );

				if ( isset( $_POST['rejected_instant_delivery_comment'] ) )
					update_post_meta( $pid, "rejected_instant_delivery_comment", trim( htmlspecialchars( $_POST['rejected_instant_delivery_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_instant_delivery_comment", '' );

				if ( isset( $_POST['rejected_extra1_comment'] ) )
					update_post_meta( $pid, "rejected_extra1_comment", trim( htmlspecialchars( $_POST['rejected_extra1_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra1_comment", '' );

				if ( isset( $_POST['rejected_extra2_comment'] ) )
					update_post_meta( $pid, "rejected_extra2_comment", trim( htmlspecialchars( $_POST['rejected_extra2_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra2_comment", '' );

				if ( isset( $_POST['rejected_extra3_comment'] ) )
					update_post_meta( $pid, "rejected_extra3_comment", trim( htmlspecialchars( $_POST['rejected_extra3_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra3_comment", '' );
				if ( isset( $_POST['rejected_extra4_comment'] ) )
					update_post_meta( $pid, "rejected_extra4_comment", trim( htmlspecialchars( $_POST['rejected_extra4_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra4_comment", '' );
				if ( isset( $_POST['rejected_extra5_comment'] ) )
					update_post_meta( $pid, "rejected_extra5_comment", trim( htmlspecialchars( $_POST['rejected_extra5_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra5_comment", '' );
				if ( isset( $_POST['rejected_extra6_comment'] ) )
					update_post_meta( $pid, "rejected_extra6_comment", trim( htmlspecialchars( $_POST['rejected_extra6_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra6_comment", '' );
				if ( isset( $_POST['rejected_extra7_comment'] ) )
					update_post_meta( $pid, "rejected_extra7_comment", trim( htmlspecialchars( $_POST['rejected_extra7_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra7_comment", '' );
				if ( isset( $_POST['rejected_extra8_comment'] ) )
					update_post_meta( $pid, "rejected_extra8_comment", trim( htmlspecialchars( $_POST['rejected_extra8_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra8_comment", '' );
				if ( isset( $_POST['rejected_extra9_comment'] ) )
					update_post_meta( $pid, "rejected_extra9_comment", trim( htmlspecialchars( $_POST['rejected_extra9_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra9_comment", '' );
				if ( isset( $_POST['rejected_extra10_comment'] ) )
					update_post_meta( $pid, "rejected_extra10_comment", trim( htmlspecialchars( $_POST['rejected_extra10_comment'] ) ) );
				else
					update_post_meta( $pid, "rejected_extra10_comment", '' );

			} elseif ( $post->post_type == 'request' ) { /* REQUEST */

				update_post_meta( $pid, 'request_budget_from', $_POST['request_budget_from'] );
				update_post_meta( $pid, 'request_budget_to', $_POST['request_budget_to'] );
				update_post_meta( $pid, 'request_delivery', $_POST['request_delivery'] );
				update_post_meta( $pid, 'request_deadline', strtotime( $_POST['request_deadline'] ) );
				update_post_meta( $pid, 'request_autoclose', $_POST['request_autoclose'] );

				/* Rejected */
				if ( isset( $_POST['req_rejected_title'] ) && $_POST['req_rejected_title'] == '1' )
					update_post_meta( $pid, "req_rejected_title", '1' );
				else
					update_post_meta( $pid, "req_rejected_title", '0' );

				if ( isset( $_POST['req_rejected_description'] ) && $_POST['req_rejected_description'] == '1' )
					update_post_meta( $pid, "req_rejected_description", '1' );
				else
					update_post_meta( $pid, "req_rejected_description", '0' );

				if ( isset( $_POST['req_rejected_tags'] ) && $_POST['req_rejected_tags'] == '1' )
					update_post_meta( $pid, "req_rejected_tags", '1' );
				else
					update_post_meta( $pid, "req_rejected_tags", '0' );

				if ( isset( $_POST['req_rejected_category'] ) && $_POST['req_rejected_category'] == '1' )
					update_post_meta( $pid, "req_rejected_category", '1' );
				else
					update_post_meta( $pid, "req_rejected_category", '0' );

				if ( isset( $_POST['req_rejected_deadline'] ) && $_POST['req_rejected_deadline'] == '1' )
					update_post_meta( $pid, "req_rejected_deadline", '1' );
				else
					update_post_meta( $pid, "req_rejected_deadline", '0' );

				if ( isset( $_POST['req_rejected_budget_from'] ) && $_POST['req_rejected_budget_from'] == '1' )
					update_post_meta( $pid, "req_rejected_budget_from", '1' );
				else
					update_post_meta( $pid, "req_rejected_budget_from", '0' );

				if ( isset( $_POST['req_rejected_budget_to'] ) && $_POST['req_rejected_budget_to'] == '1' )
					update_post_meta( $pid, "req_rejected_budget_to", '1' );
				else
					update_post_meta( $pid, "req_rejected_budget_to", '0' );

				if ( isset( $_POST['req_rejected_attachments'] ) && $_POST['req_rejected_attachments'] == '1' )
					update_post_meta( $pid, "req_rejected_attachments", '1' );
				else
					update_post_meta( $pid, "req_rejected_attachments", '0' );

				if ( isset( $_POST['req_rejected_title_comment'] ) )
					update_post_meta( $pid, "req_rejected_title_comment", trim( htmlspecialchars( $_POST['req_rejected_title_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_title_comment", '' );

				if ( isset( $_POST['req_rejected_description_comment'] ) )
					update_post_meta( $pid, "req_rejected_description_comment", trim( htmlspecialchars( $_POST['req_rejected_description_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_description_comment", '' );

				if ( isset( $_POST['req_rejected_tags_comment'] ) )
					update_post_meta( $pid, "req_rejected_tags_comment", trim( htmlspecialchars( $_POST['req_rejected_tags_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_tags_comment", '' );

				if ( isset( $_POST['req_rejected_category_comment'] ) )
					update_post_meta( $pid, "req_rejected_category_comment", trim( htmlspecialchars( $_POST['req_rejected_category_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_category_comment", '' );

				if ( isset( $_POST['req_rejected_deadline_comment'] ) )
					update_post_meta( $pid, "req_rejected_deadline_comment", trim( htmlspecialchars( $_POST['req_rejected_deadline_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_deadline_comment", '' );

				if ( isset( $_POST['req_rejected_budget_from_comment'] ) )
					update_post_meta( $pid, "req_rejected_budget_from_comment", trim( htmlspecialchars( $_POST['req_rejected_budget_from_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_budget_from_comment", '' );

				if ( isset( $_POST['req_rejected_budget_to_comment'] ) )
					update_post_meta( $pid, "req_rejected_budget_to_comment", trim( htmlspecialchars( $_POST['req_rejected_budget_to_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_budget_to_comment", '' );

				if ( isset( $_POST['req_rejected_attachments_comment'] ) )
					update_post_meta( $pid, "req_rejected_attachments_comment", trim( htmlspecialchars( $_POST['req_rejected_attachments_comment'] ) ) );
				else
					update_post_meta( $pid, "req_rejected_attachments_comment", '' );

			} elseif ( $post->post_type == 'offer' ) { /* OFFER */

				update_post_meta( $pid, "max_days", trim( $_POST['max_days'] ) );

				$job_cost = htmlspecialchars( $_POST['job_cost'] );

				if ( wpj_get_option( 'wpjobster_price_type' ) == "fixed_amount" ) {
					$job_cost = wpj_get_option( 'wpjobster_job_fixed_amount' );
				}

				update_post_meta( $pid, "price", $job_cost );
				update_post_meta( $pid, "price_type", $_POST['price_type'] );

			}

		}

		/* SEND EMAILS */
		if ( isset( $_REQUEST['fromadmin'] ) || isset( $_REQUEST['screen'] ) ) {

			if ( ( isset( $post->post_type ) && $post->post_type == 'job' ) || ( isset( $_REQUEST['screen'] ) && $_REQUEST['screen'] == 'edit-job' ) ) {

				if ( ( isset( $post->post_status ) && $post->post_status == 'publish' ) || ( isset( $_REQUEST['_status'] ) && $_REQUEST['_status'] == 'publish' ) ) {
					wpj_notify_user_translated( 'job_acc', $aid, [
						'##job_name##' => $post->post_title,
						'##job_link##' => urldecode( get_permalink( $pid ) )
					] );

					update_post_meta( $pid, 'under_review', '0' );

					do_action( 'wpj_after_job_published', $aid, $pid );

				} elseif ( ( isset( $post->post_status ) && $post->post_status == 'pending' ) || ( isset( $_REQUEST['_status'] ) && $_REQUEST['_status'] == 'pending' ) ) {
					wpj_notify_user_translated( 'job_decl', $aid, [
						'##job_name##' => $post->post_title
					] );

				} elseif ( ( isset( $post->post_status ) && $post->post_status == 'draft' ) || ( isset( $_REQUEST['_status'] ) && $_REQUEST['_status'] == 'draft' ) ) {
					wpj_notify_user_translated( 'job_new', $aid, [
						'##job_name##' => $post->post_title
					] );

					update_post_meta( $pid, 'under_review', '1' );

				}

			}

			if ( ( isset( $post->post_type ) && $post->post_type == 'request' ) || ( isset( $_REQUEST['screen'] ) && $_REQUEST['screen'] == 'edit-request' ) ) {

				if ( ( isset( $post->post_status ) && $post->post_status == 'publish' ) || ( isset( $_REQUEST['_status'] ) && $_REQUEST['_status'] == 'publish' ) ) {
					wpj_notify_user_translated( 'request_acc', $aid, [
						'##request_name##' => $post->post_title,
						'##request_link##' => urldecode( get_permalink( $pid ) )
					] );

					update_post_meta( $pid, 'under_review', '0' );
					update_post_meta( $pid, 'active', '1' );

					do_action( 'wpj_after_request_published', $aid, $pid );

				} elseif ( ( isset( $post->post_status ) && $post->post_status == 'pending' ) || ( isset( $_REQUEST['_status'] ) && $_REQUEST['_status'] == 'pending' ) ) {
					wpj_notify_user_translated( 'request_decl', $aid, [
						'##request_name##' => $post->post_title
					] );

					update_post_meta( $pid, 'under_review', '1' );
					update_post_meta( $pid, 'active', '0' );

				} elseif ( ( isset( $post->post_status ) && $post->post_status == 'draft' ) || ( isset( $_REQUEST['_status'] ) && $_REQUEST['_status'] == 'draft' ) ) {
					update_post_meta( $pid, 'under_review', '1' );
					update_post_meta( $pid, 'active', '0' );

				}

			}

		}

		/* CHECKOUT PAGE */
		if ( isset( $_POST['payment_instructions_title'] ) ) {
			update_post_meta( $pid, 'payment_instructions_title', $_POST['payment_instructions_title'] );
		}

		if ( isset( $_POST['payment_instructions_description'] ) ) {
			update_post_meta( $pid, 'payment_instructions_description', $_POST['payment_instructions_description'] );
		}

		/* POST NEW JOB */
		if ( wpj_get_option( 'wpjobster_packages_enabled' ) == "yes" ) {
			if ( isset( $_POST['package_name_instructions'] ) ) {
				update_post_meta( $pid, 'package_name_instructions', $_POST['package_name_instructions'] );
			}
			if ( isset( $_POST['package_description_instructions'] ) ) {
				update_post_meta( $pid, 'package_description_instructions', $_POST['package_description_instructions'] );
			}
			if ( isset( $_POST['package_max_days_instructions'] ) ) {
				update_post_meta( $pid, 'package_max_days_instructions', $_POST['package_max_days_instructions'] );
			}
			if ( isset( $_POST['package_revisions_instructions'] ) ) {
				update_post_meta( $pid, 'package_revisions_instructions', $_POST['package_revisions_instructions'] );
			}
			if ( isset( $_POST['package_price_instructions'] ) ) {
				update_post_meta( $pid, 'package_price_instructions', $_POST['package_price_instructions'] );
			}
			if ( isset( $_POST['package_cf_name_instructions'] ) ) {
				update_post_meta( $pid, 'package_cf_name_instructions', $_POST['package_cf_name_instructions'] );
			}
			if ( isset( $_POST['package_cf_checklist_instructions'] ) ) {
				update_post_meta( $pid, 'package_cf_checklist_instructions', $_POST['package_cf_checklist_instructions'] );
			}
		}

		/* PAGE ATTRIBUTES */
		if ( isset( $_POST['page_content_source'] ) ) {
			update_post_meta( $pid, 'page_content_source', $_POST['page_content_source'] );
		}

		if ( isset( $_POST['page_content_source_all'] ) && $_POST['page_content_source_all'] == 'code' ) {
			foreach ( get_pages() as $key => $page ) {
				update_post_meta( $page->ID, 'page_content_source', 'code' );
			}
		}

		if ( isset( $_POST['page_content_source_all'] ) && $_POST['page_content_source_all'] == 'page_builder' ) {
			foreach ( get_pages() as $key => $page ) {
				update_post_meta( $page->ID, 'page_content_source', 'page_builder' );
			}
		}

		delete_option( 'theme_permalinks_flushed' );
	}
}
