<?php
add_filter( 'manage_users_columns', 'wpj_admin_user_info_label' );
function wpj_admin_user_info_label( $column ) {

	unset( $column['role'] );

	$column['userlevel'] = 'User Level';

	if ( wpj_get_option( 'wpjobster_subscription_enabled' ) == 'yes' ) $column['subscription'] = 'Subscriptions';

	if ( wpj_get_option( 'wpjobster_verify_email' ) == 'yes' ) $column['emailverified'] = 'Email Verified';

	if ( wpj_get_option( 'wpjobster_verify_phone_numbers' ) == 'yes' ) $column['phoneverified'] = 'Phone Verified';

	if ( wpj_get_option( 'wpjobster_enable_badges_sale' ) == 'yes' ) $column['badge'] = 'Badges';

	if ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' ) $column['balance'] = 'Balance';

	$column['registered'] = 'Registered';

	return $column;
}

add_filter( 'manage_users_sortable_columns', 'wpj_admin_user_info_label_sortable' );
function wpj_admin_user_info_label_sortable( $columns ) {
	$column['userlevel'] = 'userlevel';

	if ( wpj_get_option( 'wpjobster_verify_email' ) == 'yes' ) $column['emailverified'] = 'emailverified';

	if ( wpj_get_option( 'wpjobster_verify_phone_numbers' ) == 'yes' ) $column['phoneverified'] = 'phoneverified';

	if ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' ) $column['balance'] = 'balance';

	$column['registered'] = 'registered';

	return $column;
}

add_action( 'pre_get_users', 'wpj_admin_user_info_value_sortable' );
function wpj_admin_user_info_value_sortable( $query ) {
	if ( 'userlevel' == $query->get( 'orderby' ) ) {
		$query->set( 'orderby', 'meta_value' );
		$query->set( 'meta_key', 'user_level' );
	}

	if ( 'emailverified' == $query->get( 'orderby' ) ) {
		$query->set( 'orderby', 'meta_value' );
		$query->set( 'meta_key', 'uz_email_verification' );
	}

	if ( 'phoneverified' == $query->get( 'orderby' ) ) {
		$query->set( 'orderby', 'meta_value' );
		$query->set( 'meta_key', 'uz_phone_verification' );
	}

	if ( 'balance' == $query->get( 'orderby' ) ) {
		$query->set( 'orderby', 'meta_value' );
		$query->set( 'meta_key', 'credits' );
	}

	if ( 'registered' == $query->get( 'orderby' ) ) {
		return wp_parse_args( [ 'registration_date' => 'registered' ], $query );
	}
}

add_action( 'manage_users_custom_column', 'wpj_admin_user_info_action', 15, 3 );
function wpj_admin_user_info_action( $val, $column_name, $user_id ) {

	switch ( $column_name ) {
		case 'userlevel':
			$val = wpj_get_user_level( $user_id ) . '<br>' . '<a href="' . get_edit_user_link( $user_id ) . '#actions">' . __( 'Edit level', 'wpjobster' ) . '</a>';
			break;

		case 'subscription':
			if ( wpj_get_option( 'wpjobster_subscription_enabled' ) == 'yes' ) {
				$subscription_level = wpj_get_active_subscription( 'subscription_level', ['user_id' => $user_id, 'subscription_status' => 'active'], 'var' );

				if ( $subscription_level ) {
					$val = substr( $subscription_level, -1 );
				} else {
					$val = "0";
				}
			}
			break;

		case 'emailverified':
			if ( wpj_get_option( 'wpjobster_verify_email' ) == 'yes' ) {
				$val = get_user_meta( $user_id, 'uz_email_verification', true ) != 1 ? __( 'No', 'wpjobster' ) . '<br>' . '<a href="' . get_bloginfo( 'url' ) . '/wp-admin/users.php?user=' . $user_id . '&action=mark_email_as_verified">' . __( 'Mark as verified', 'wpjobster' ) . '</a>' : __( 'Yes', 'wpjobster' );
			}
			break;

		case 'phoneverified':
			if ( wpj_get_option( 'wpjobster_verify_phone_numbers' ) == 'yes' ) {
				$val = get_user_meta( $user_id, 'uz_phone_verification', true ) != 1 ? __( 'No', 'wpjobster' ) . '<br>' . '<a href="' . get_bloginfo( 'url' ) . '/wp-admin/users.php?user=' . $user_id . '&action=mark_phone_as_verified">' . __( 'Mark as verified', 'wpjobster' ) . '</a>' : __( 'Yes', 'wpjobster' );
			}
			break;

		case 'badge':
			if ( wpj_get_option( 'wpjobster_enable_badges_sale' ) == 'yes' ) {
				if ( is_array( get_user_meta( $user_id, 'user_badge', true ) ) ) {
					$user_badge  = get_user_meta( $user_id, 'user_badge', true );
					$badges_data = wpj_get_badge_info();

					$badges = '';
					if ( $badges_data && $user_badge ) {
						foreach ( $user_badge as $key => $badge ) {
							if ( ! empty( $badges_data['wpj_badge_icon'][$badge] ) )
								$badges .= '<i class="' . $badges_data['wpj_badge_icon'][$badge] . ' icon"></i>';
						}
					}
				} elseif ( get_user_meta( $user_id, 'user_badge', true ) ) {
					$badges = get_user_meta( $user_id, 'user_badge', true );
				} else {
					$badges = __( 'No badges', 'wpjobster' );
				}
				$val = $badges . '<br>' . '<a href="' . get_edit_user_link( $user_id ) . '#actions">' . __( 'Edit badges', 'wpjobster' ) . '</a>';
			}
			break;

		case 'balance':
			if ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' ) {
				$val = wpj_show_price( wpj_get_user_credit( $user_id ) ) . '<br>' . '<a href="' . get_edit_user_link( $user_id ) . '#actions">' . __( 'Edit balance', 'wpjobster' ) . '</a>';
			}
			break;

		case 'registered':
			if ( get_the_author_meta( 'registered', $user_id ) )
				$val = wpj_date( wpj_get_option( 'date_format' ) . ' ' . wpj_get_option( 'time_format' ), strtotime( get_the_author_meta( 'registered', $user_id ) ) );
			else
				$val = 'NaN';
			break;

		default:
	}

	return $val;
}

add_filter( 'admin_init', 'wpj_admin_change_user_status' );
function wpj_admin_change_user_status() {

	if ( isset( $_GET['action'] ) && isset( $_GET['user'] ) ) {
		if ( $_GET['action'] == 'mark_email_as_verified' ) {
			update_user_meta( $_GET['user'], 'uz_email_verification', 1 );
		}

		if ( $_GET['action'] == 'mark_phone_as_verified' ) {
			if ( get_user_meta( $_GET['user'], 'cell_number', true ) ) {
				update_user_meta( $_GET['user'], 'uz_phone_verification', 1 );
			}
		}
	}

}

add_action( 'admin_notices', 'wpj_admin_change_user_status_notice' );
function wpj_admin_change_user_status_notice() {
	if ( isset( $_GET['action'] ) && isset( $_GET['user'] ) ) {
		if ( $_GET['action'] == 'mark_phone_as_verified' ) {
			if ( ! get_user_meta( $_GET['user'], 'cell_number', true ) ) {

				printf( '<div id="message" class="error fade">' . __( 'You must fill in the phone number field for this user before marking the phone as verified.', 'wpjobster' ) . '</div>' );

			}
		}
	}
}