<?php
class WPJInactiveUsersMenu
{
	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_action( 'admin_menu', [ $this, 'addInactiveUsersMenu' ] );
	}

	/**
	 * Register Menus
	 */
	public function addInactiveUsersMenu() {
		add_users_page(
			__( 'Inactive Users', 'wpjobster' ),
			__( 'Inactive Users', 'wpjobster' ),
			'read',
			'inactive-users',
			[$this, 'checkInactiveUsers']
		);
	}

	public function checkInactiveUsers() {
		if ( isset( $_POST['threshold_days'] ) ) {
			$inactivity_threshold_days = $_POST['threshold_days'];

		} else {
			$inactivity_threshold_days = get_option( 'wpj_inactive_users_days_number', 365 );
		
		}
		
		$threshold_timestamp = strtotime( "-{$inactivity_threshold_days} days" );
		
		$inactive_users = new WP_User_Query([
		    'fields'       => 'all',
		    'meta_key'     => 'last_user_login',
		    'meta_value'   => $threshold_timestamp,
		    'meta_compare' => '<',
		    'orderby'      => 'meta_value',
		    'order'        => 'ASC',
		    'number'       => -1
		]);

		$users = $inactive_users->get_results();

		$this->delete( $users ); ?>

		<div class="wrap">
			<h2 class="wpj-admin-title">Jobster - <?php _e( 'Inactive Users', 'wpjobster' ); ?></h2>

			<div id="usual2" class="usual wpj-admin-table-wrapper">
				<table class="widefat post" cellspacing="0">
					<thead>
						<form method="post" action="">
							<tr>
								<th style="text-align: left; width: 70%;">
									
									<?php if ( $users && ! isset( $_POST['delete_all_inactive_users'] ) ) {
										echo sprintf( __( 'The following users have been inactive on the site for at least <input style="width: 50px; text-align: center;" name="threshold_days" value="%d" /> days.', 'wpjobster' ), $inactivity_threshold_days );

									} else {
										echo sprintf( __( 'There are no users who have been inactive for more than <input style="width: 50px; text-align: center;" name="threshold_days" value="%d" /> days.', 'wpjobster' ), $inactivity_threshold_days );

									} ?>

								</th>

								<th colspan="2" style="text-align: right; width: 30%;">
									<input type="submit" class="button button-primary" name="change_days_number" title="Change days number" value="<?php _e( 'Change days number', 'wpjobster' ); ?>" />

									<input onclick="if ( confirm( 'Are you sure you want to delete all inactive users?' ) ) return true; else event.stopPropagation(); event.preventDefault();" type="submit" class="button button-primary" name="delete_all_inactive_users" title="Delete all inactive users" value="<?php _e( 'Delete all inactive users', 'wpjobster' ); ?>" />
								</th>
							</tr>
						</form>
					</thead>

					<?php if ( $users && ! isset( $_POST['delete_all_inactive_users'] ) ) { ?>

						<tbody>
							<tr>
								<td style="text-align: left;"><b><?= __( 'Usernamee', 'wpjobster' ); ?></b></td>
								<td style="text-align: center;"><b><?= __( 'Last login', 'wpjobster' ); ?></b></td>
								<td style="text-align: center;"><b><?= __( 'Action', 'wpjobster' ); ?></b></td>
							</tr>

							<?php foreach ( $users as $user ) {
								if ( isset( $_POST['user_id'] ) && $_POST['user_id'] == $user->ID ) {
									continue;
								} ?>

								<tr>
									<td style="text-align: left;"><?php echo $user->user_login; ?></td>
									<td style="text-align: center;"><?php echo wpj_get_last_visit( $user->ID ); ?></td>
									<td style="text-align: center;">
										<form method="post" action="">
											<input hidden="hidden" value="<?= $user->ID; ?>" name="user_id" />

											<input onclick="if ( confirm( 'Are you sure you want to delete this user?' ) ) return true; else event.stopPropagation(); event.preventDefault();" type="submit" class="button button-secondary" name="delete_inactive_user" title="Delete inactive user" value="<?php _e( 'Delete', 'wpjobster' ); ?>" />
										</form>
									</td>
								</tr>

							<?php } ?>

						</tbody>

					<?php } ?>

				</table>
			</div>
		</div>

	<?php }

	private function delete( $users = [] ) {
		if ( isset( $_POST['change_days_number'] ) && isset( $_POST['threshold_days'] ) ) {
			update_option( 'wpj_inactive_users_days_number', $_POST['threshold_days'] );
		}

		if ( isset( $_POST['delete_inactive_user'] ) && isset( $_POST['user_id'] ) ) {
			$user_id = $_POST['user_id'];

			wpj_delete_user_account( $user_id );
		}

		if ( isset( $_POST['delete_all_inactive_users'] ) ) {
			if ( $users ) {
				foreach ( $users as $user ) {
					wpj_delete_user_account( $user->ID );
				}
			}
		}
	}
}

add_action( 'after_setup_theme', [ 'WPJInactiveUsersMenu', 'init' ] );