<?php
/* ADDRESS */
add_filter( 'user_contactmethods', 'wpj_user_contact_details' );
function wpj_user_contact_details( $user_contact ) {
	$user_contact['user_company'] = 'Company Name';
	$user_contact['cell_number']  = 'Phone number';
	$user_contact['address']      = 'Address';
	$user_contact['city']         = 'City';
	$user_contact['state']        = 'State';
	$user_contact['zip']          = 'Zip Code';
	$user_contact['country']      = 'Country';
	$user_contact['country_code'] = 'Country Code';

	return $user_contact;
}

/* PAYMENTS */
add_action( 'show_user_profile', 'wpj_user_payment_details' );
add_action( 'edit_user_profile', 'wpj_user_payment_details' );
function wpj_user_payment_details( $user ) { ?>

	<h3><?php _e( 'Payments Info', 'wpjobster' ); ?></h3>

	<?php do_action( 'wpj_after_admin_single_user_payments_info_title' ); ?>

	<table class="form-table">
		<tr>
			<th><label for="tax_id"><?php _e( 'Tax ID', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="tax_id" id="tax_id" value="<?php echo esc_attr( get_the_author_meta( 'tax_id', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>

		<?php do_action( 'wpj_after_admin_single_user_tax_details' ); ?>

		<tr>
			<th><label for="paypal_email"><?php _e( 'Paypal Email', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="paypal_email" id="paypal_email" value="<?php echo esc_attr( get_the_author_meta( 'paypal_email', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>

		<?php do_action( 'wpj_after_admin_single_user_paypal_details' ); ?>

		<tr>
			<th><label for="payoneer_email"><?php _e( 'Payoneer Email', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="payoneer_email" id="payoneer_email" value="<?php echo esc_attr( get_the_author_meta( 'payoneer_email', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="payoneer_card"><?php _e( 'Payoneer Card', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="payoneer_card" id="payoneer_card" value="<?php echo esc_attr( get_the_author_meta( 'payoneer_card', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>

		<?php do_action( 'wpj_after_admin_single_user_payoneer_details' ); ?>

		<tr>
			<th><label for="bank_bank_name"><?php _e( 'Bank Name', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="bank_bank_name" id="bank_bank_name" value="<?php echo esc_attr( get_the_author_meta( 'bank_bank_name', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="bank_bank_address"><?php _e( 'Bank Address', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="bank_bank_address" id="bank_bank_address" value="<?php echo esc_attr( get_the_author_meta( 'bank_bank_address', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="bank_account_name"><?php _e( 'Bank Account Name', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="bank_account_name" id="bank_account_name" value="<?php echo esc_attr( get_the_author_meta( 'bank_account_name', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="bank_account_number"><?php _e( 'Bank Account Number', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="bank_account_number" id="bank_account_number" value="<?php echo esc_attr( get_the_author_meta( 'bank_account_number', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="bank_account_currency"><?php _e( 'Bank Account Currency', 'wpjobster' ); ?></label></th>
			<td><input type="text" name="bank_account_currency" id="bank_account_currency" value="<?php echo esc_attr( get_the_author_meta( 'bank_account_currency', $user->ID ) ); ?>" class="regular-text" /></td>
		</tr>
		<tr>
			<th><label for="bank_additional_info"><?php _e( 'Bank Additional Info', 'wpjobster' ); ?></label></th>
			<td><textarea rows="6" name="bank_additional_info" id="bank_additional_info" class="regular-text"><?php echo esc_attr( get_the_author_meta( 'bank_additional_info', $user->ID ) ); ?></textarea></td>
		</tr>

		<?php do_action( 'wpj_after_admin_single_user_bank_details' ); ?>

	</table>

	<?php do_action( 'wpj_after_admin_single_user_payments_info_content' );

}

add_action( 'personal_options_update', 'wpj_save_user_payment_details' );
add_action( 'edit_user_profile_update', 'wpj_save_user_payment_details' );
function wpj_save_user_payment_details( $user_id ) {
	if ( is_user_logged_in() && current_user_can( 'manage_options' ) ) {
		update_user_meta( $user_id, 'tax_id', $_POST['tax_id'] );

		update_user_meta( $user_id, 'paypal_email', $_POST['paypal_email'] );

		update_user_meta( $user_id, 'payoneer_email', $_POST['payoneer_email'] );
		update_user_meta( $user_id, 'payoneer_card', $_POST['payoneer_card'] );

		update_user_meta( $user_id, 'bank_bank_name', $_POST['bank_bank_name'] );
		update_user_meta( $user_id, 'bank_bank_address', $_POST['bank_bank_address'] );
		update_user_meta( $user_id, 'bank_account_name', $_POST['bank_account_name'] );
		update_user_meta( $user_id, 'bank_account_number', $_POST['bank_account_number'] );
		update_user_meta( $user_id, 'bank_account_currency', $_POST['bank_account_currency'] );
		update_user_meta( $user_id, 'bank_additional_info', $_POST['bank_additional_info'] );

		do_action( 'wpj_after_admin_single_user_save_payments_info' );
	}
}

/* ACTIONS */
add_action( 'show_user_profile', 'wpj_user_actions' );
add_action( 'edit_user_profile', 'wpj_user_actions' );
function wpj_user_actions( $user ) { ?>

	<h3 id="actions"><?php _e( 'Actions', 'wpjobster' ); ?></h3>

	<?php do_action( 'wpj_after_admin_single_user_action_title' ); ?>

	<table class="form-table">

		<tr>
			<th><label for="user_level"><?php _e( 'User Level', 'wpjobster' ); ?></label></th>
			<td>
				<select name="user_level">
					<option <?php if ( wpj_get_user_level( $user->ID ) == '0' ) echo 'selected="selected"'; ?> value="0"><?php _e( 'Level 0', 'wpjobster' ); ?></option>
					<option <?php if ( wpj_get_user_level( $user->ID ) == '1' ) echo 'selected="selected"'; ?> value="1"><?php _e( 'Level 1', 'wpjobster' ); ?></option>
					<option <?php if ( wpj_get_user_level( $user->ID ) == '2' ) echo 'selected="selected"'; ?> value="2"><?php _e( 'Level 2', 'wpjobster' ); ?></option>
					<option <?php if ( wpj_get_user_level( $user->ID ) == '3' ) echo 'selected="selected"'; ?> value="3"><?php _e( 'Level 3', 'wpjobster' ); ?></option>
				</select>
			</td>
		</tr>

		<?php if ( wpj_get_option( 'wpjobster_credits_enable' ) != 'no' ) { ?>

			<tr class="js-user-balance">
				<th><label for="user_balance"><?php _e( 'User Balance', 'wpjobster' ); ?></label></th>
				<td>
					<?php echo sprintf( __( 'Current balance: %s', 'wpjobster' ), wpj_show_price_classic( wpj_get_user_credit( $user->ID ), 2 ) ); ?>

					<br>

					<select class="js-user-credit-action">
						<option value="increase"><?php _e( 'Increase', 'wpjobster' ); ?></option>
						<option value="decrease"><?php _e( 'Decrease', 'wpjobster' ); ?></option>
					</select>

					<input type="text" name="amount" placeholder="<?php echo wpj_get_site_default_currency(); ?>" />

					<input class="button-secondary js-update-user-credit" type="submit" name="update_user_credit" value="<?php _e( 'Update', 'wpjobster' ); ?>" />
				</td>
			</tr>

		<?php }

		if ( wpj_get_option( 'wpjobster_enable_badges_sale' ) == 'yes' ) { ?>

			<tr>
				<th><label for="user_badge"><?php _e( 'User Badge', 'wpjobster' ); ?></label></th>
				<td>
					<?php $user_badge = get_user_meta ( $user->ID, 'user_badge', true );
					if ( $user_badge && ! is_array( $user_badge ) ) $user_badge = [ $user_badge ];

					$badges_data = wpj_get_badge_info();

					if ( $badges_data && is_array( $badges_data ) ) {
						foreach ( $badges_data['redux_repeater_data'] as $key => $badge ) { ?>

							<input <?php if ( $user_badge && in_array( $key, $user_badge ) ) echo 'checked="checked"'; ?> type="checkbox" name="badges[]" value="<?php echo $key; ?>" />&nbsp;&nbsp;<i class="<?php echo $badges_data['wpj_badge_icon'][$key]; ?> icon"></i>&nbsp;<?php echo sprintf( __( 'Badge %s (%s)', 'wpjobster' ), $key, $badges_data['wpj_badge_text'][$key] ); ?><br>

						<?php }
					} ?>

				</td>
			</tr>

		<?php } ?>

	</table>

	<?php do_action( 'wpj_after_admin_single_user_action_content', $user );

}

add_action( 'personal_options_update', 'wpj_save_user_actions' );
add_action( 'edit_user_profile_update', 'wpj_save_user_actions' );
function wpj_save_user_actions( $user_id ) {
	if ( is_user_logged_in() && current_user_can( 'manage_options' ) ) {
		// User Level
		$user_level = get_user_meta( $user_id, 'user_level', 1 );

		if ( ! $_POST['user_level'] || $_POST['user_level'] == '0' ) {
			update_user_meta( $user_id, 'user_level', '0' );
			update_user_meta( $user_id, 'date_toclear', strtotime( '+1 month', time() ) );
		}

		if ( $_POST['user_level'] == '1' ) {
			update_user_meta( $user_id, 'user_level', '1' );
			update_user_meta( $user_id, 'date_toclear', strtotime( '+1 month', time() ) );
		}

		if ( $_POST['user_level'] == '2' ) {
			update_user_meta( $user_id, 'user_level', '2' );
			update_user_meta( $user_id, 'date_toclear', strtotime( '+2 month', time() ) );
		}

		if ( $_POST['user_level'] == '3' ) {
			update_user_meta( $user_id, 'user_level', '3' );
			update_user_meta( $user_id, 'date_toclear', strtotime( '+2 month', time() ) );
		}

		if ( $_POST['user_level'] < $user_level ) {
			wpj_notify_user_translated( 'level_down', $user_id, [ '##current_level##' => $_POST['user_level'] ] );
		}

		if ( $_POST['user_level'] > $user_level ) {
			wpj_notify_user_translated( 'level_up', $user_id, [ '##current_level##' => $_POST['user_level'] ] );
		}

		wpj_do_user_level_extras_check( $user_id );

		do_action( 'wpj_after_admin_single_user_save_action', $user_id );

		// User Badge
		if ( ! empty( $_POST['badges'] ) ) {
			if ( is_array( $_POST['badges'] ) ) {
				// Insert order to database
				foreach ( $_POST['badges'] as $badge_nr ) {
					wpj_insert_badge_order(
						[
							'user_id'          => $user_id,
							'badge_nr'         => $badge_nr,
							'description'      => wpj_get_badge_info( 'wpj_badge_text', $badge_nr ),
							'icon'             => wpj_get_badge_info( 'wpj_badge_icon', $badge_nr ),
							'price'            => wpj_get_badge_info( 'wpj_badge_price', $badge_nr ),
							'min_rating'       => wpj_get_badge_info( 'wpj_badge_min_rating', $badge_nr ),
							'min_reviews'      => wpj_get_badge_info( 'wpj_badge_min_reviews', $badge_nr ),
							'date_made'        => current_time( 'timestamp', 1 ),
							'payment_date'     => current_time( 'timestamp', 1 ),
							'payment_type'     => 1,
							'payment_amount'   => wpj_get_badge_info( 'wpj_badge_price', $badge_nr ),
							'payment_currency' => wpj_get_site_currency(),
							'payment_status'   => 'completed',
							'payment_gateway'  => 'free',
							'payment_response' => 'by_admin'
						],
						[ '%d', '%d', '%s', '%s', '%f', '%d', '%d', '%d', '%d', '%d', '%f', '%s', '%s', '%s', '%s' ]
					);
				}

				// Set badges
				update_user_meta( $user_id, 'user_badge', $_POST['badges'] );
			}

		} else delete_user_meta( $user_id, 'user_badge' );
	}

}

add_action( 'wp_ajax_update_user_balance_action'       , 'wpj_update_user_balance_from_admin' );
add_action( 'wp_ajax_nopriv_update_user_balance_action', 'wpj_update_user_balance_from_admin' );
function wpj_update_user_balance_from_admin( $user_id = '', $update_action = '' ) {
	if ( is_user_logged_in() && current_user_can( 'manage_options' ) ) {
		$user_id       = WPJ_Form::post( 'user_id', $user_id );
		$update_action = WPJ_Form::post( 'update_action', $update_action );

		if ( $update_action == 'increase' && is_numeric( $_POST['amount'] ) ) {
			wpj_update_user_credit( $user_id, ( wpj_get_user_credit( $user_id ) + $_POST['amount'] ) );

			wpj_add_history_log([
				'tp'     =>'1',
				'reason' => __( 'Payment received from Site Admin', 'wpjobster' ),
				'amount' => $_POST['amount'],
				'uid'    => $user_id,
				'rid'    => 1
			]);

			wpj_notify_user_translated( 'balance_up', $user_id, [
				'##amount_updated##' => $_POST['amount']
			]);

			wpj_notify_user_translated( 'balance_admin_up', 'admin', [
				'##amount_updated##' => $_POST['amount'],
				'##username##' => wpj_get_user_display_type( $user_id )
			]);
		}

		if ( $update_action == 'decrease' && is_numeric( $_POST['amount'] ) ) {
			wpj_update_user_credit( $user_id, ( wpj_get_user_credit( $user_id ) - $_POST['amount'] ) );

			wpj_add_history_log([
				'tp'     => '0',
				'reason' => __( 'Payment withdrawn by Site Admin', 'wpjobster' ),
				'amount' => $_POST['amount'],
				'uid'    => $user_id,
				'rid'    => 2
			]);

			wpj_notify_user_translated( 'balance_down', $user_id, [
				'##amount_updated##' => $_POST['amount']
			]);

			wpj_notify_user_translated( 'balance_admin_down', 'admin', [
				'##amount_updated##' => $_POST['amount'],
				'##username##'       => wpj_get_user_display_type( $user_id )
			]);
		}

		$cr = wpj_get_user_credit( $user_id );

		if ( $cr < 0 ) {
			wpj_notify_user_translated( 'balance_negative', $user_id, [ '##amount_updated##' => $cr ] );
		}
	}

	if ( wpj_is_ajax_call() ) wp_die();
}

/* TRANSACTIONS */
add_action( 'show_user_profile', 'wpj_user_earnings_report', 11 );
add_action( 'edit_user_profile', 'wpj_user_earnings_report', 11 );
function wpj_user_earnings_report( $user ) {
	global $wpdb;

	$results = $wpdb->get_results(
		$wpdb->prepare(
			"
			SELECT tr.payedamount, tr.datemade, tr.reason, tr.oid, tr.tp
			FROM {$wpdb->prefix}job_payment_transactions tr
			WHERE tr.uid = %d
			GROUP BY tr.oid, tr.rid, tr.payedamount
			ORDER BY tr.id DESC
			",
			$user->ID
		)
	);

	if ( $results ) { ?>

		<h3 id="earnings"><?php _e( 'Transactions', 'wpjobster' ); ?></h3>

		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<th width="5%"><?php _e( 'No.', 'wpjobster' ); ?></th>
					<th width="5%"><?php _e( 'Order ID', 'wpjobster' ); ?></th>
					<th><?php _e( 'Reason', 'wpjobster' ); ?></th>
					<th width="10%"><?php _e( 'Amount', 'wpjobster' ); ?></th>
					<th width="20%"><?php _e( 'Date', 'wpjobster' ); ?></th>
				</tr>
			</thead>

			<tbody>
				<?php $cnt = 0;

				foreach ( $results as $row ) {
					$cnt++;

					if ( $row->tp == 0 ) $sign = '-';
					elseif ( $row->tp == 1 ) $sign = '+';
					else $sign = ''; ?>

					<tr>
						<th><?php echo $cnt; ?></th>
						<th><?php echo $row->oid; ?></th>
						<th><?php echo wpj_stripslashes( $row->reason ); ?></th>
						<th><?php echo $sign . wpj_deciphere_amount_classic( $row->payedamount, 1 ); ?></th>
						<th><?php echo wpj_date( 'd-M-Y H:i:s', $row->datemade ); ?></th>
					</tr>

				<?php } ?>
			</tbody>
		</table>

	<?php }
}