<?php
add_action( 'wp_ajax_nopriv_wpjobster_save_less_css_file', 'wpjobster_save_less_css_file' );
add_action( 'wp_ajax_wpjobster_save_less_css_file', 'wpjobster_save_less_css_file' );
function wpjobster_save_less_css_file() {
	$upload_dir = wp_upload_dir();

	$dirname = $upload_dir['basedir'] . '/wpjobster';

	if ( ! file_exists( $dirname ) ) wp_mkdir_p( $dirname );

	$path = $upload_dir['basedir'] . '/wpjobster/semantic.css';

	$minified = wpj_stripslashes( wpj_minify_css( $_POST['content'] ) );

	if ( $minified ) file_put_contents( $path, $minified );

	update_option( 'wpj_last_css_compiled', time() );

	wp_die();
}

add_filter( 'redux/options/jobster_design/compiler', 'wpj_save_redux_css_file', 10, 3 );
function wpj_save_redux_css_file( $options, $css, $changed_values ) {
	$upload_dir = wp_upload_dir();

	$dirname = $upload_dir['basedir'] . '/wpjobster';

	if ( ! file_exists( $dirname ) ) wp_mkdir_p( $dirname );

	$path = $upload_dir['basedir'] . '/wpjobster/redux.css';

	$minified = wpj_stripslashes( wpj_minify_css( $css ) );

	if ( $minified ) file_put_contents( $path, $minified . wpj_get_custom_css() );

	update_option( 'wpj_last_redux_css_compiled', time() );

	return $options;
}

add_filter( 'redux/options/jobster_design/compiler', 'wpj_save_redux_design_fields_structure', 10, 3 );
function wpj_save_redux_design_fields_structure( $options, $css, $changed_values ) {
	if ( class_exists( 'Redux' ) && $options ) {
		$options_structure = [];

		foreach ( $options as $option_name => $option_value ) {
			$field = Redux::get_field( 'jobster_design', $option_name );

			$options_structure[$option_name] = isset( $field['type'] ) ? $field['type'] : '';
		}

		update_option( 'jobster_design_structure', $options_structure );
	}

	return $options;
}

add_filter( 'redux/options/jobster_settings/compiler', 'wpj_save_redux_settings_fields_structure', 10, 3 );
function wpj_save_redux_settings_fields_structure( $options, $css, $changed_values ) {
	if ( class_exists( 'Redux' ) && $options ) {
		$options_structure = [];

		foreach ( $options as $option_name => $option_value ) {
			$field = Redux::get_field( 'jobster_settings', $option_name );

			$options_structure[$option_name] = isset( $field['type'] ) ? $field['type'] : '';
		}

		update_option( 'jobster_settings_structure', $options_structure );
	}

	return $options;
}