<?php // Jobster Design

add_action( 'after_setup_theme', function() {

	if ( class_exists( 'Redux' ) ) {
		$jobster_design = wpj_get_design_option();

		$opt_name = "jobster_design";
		$theme    = wp_get_theme();

		$args = [
			'opt_name'           => $opt_name,

			'display_name'       => $theme->get( 'Name' ),
			'display_version'    => $theme->get( 'Version' ),
			'intro_text'         => '<p>' . __( 'After you finish editing and saving the settings, please press the <b>Save and Exit</b> button to exit the settings editing mode. If you leave the site in edit mode, performance will be affected and pages will have a harder time loading.', 'wpjobster' ) . '</p>',

			'menu_type'          => 'menu',
			'menu_title'         => __( 'Jobster Design', 'wpjobster' ),
			'menu_icon'          => 'dashicons-admin-customizer',
			'allow_sub_menu'     => true,

			'page_title'         => __( 'Jobster Design', 'wpjobster' ),
			'page_priority'      => 3,
			'page_parent'        => 'themes.php',
			'page_permissions'   => 'manage_options',
			'page_icon'          => get_template_directory_uri() . '/assets/images/logo/logo.png',
			'page_slug'          => 'jobster-design',

			'admin_bar'          => true,
			'admin_bar_icon'     => 'dashicons-admin-customizer',
			'admin_bar_priority' => 32,

			'footer_credit'      => ! empty( $jobster_design['copyright_text'] ) ? $jobster_design['copyright_text'] : sprintf( __( '&copy; %d wpjobster.com', 'wpjobster' ), date( 'Y' ) ),

			'dev_mode'           => false,
			'show_import_export' => is_demo_admin() ? false : true,

			'search'             => true,
			'default_show'       => true
		];
		Redux::set_args( $opt_name, $args );

		Redux::set_extensions( $opt_name, get_template_directory() . '/vendor/redux/repeater' ); /* add repeater extension */
		Redux::set_extensions( $opt_name, get_template_directory() . '/vendor/redux/accordion' ); /* add accordion extension */
		Redux::set_extensions( $opt_name, get_template_directory() . '/vendor/redux/box_shadow' ); /* add box_shadow extension */

		$jobster_design = [
			'general' => array(
				'childs' => array(
					'main'    => array( 'order' => '01a', 'path' => '' ),
					'colours' => array( 'order' => '02a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '01a',
			),
			'header' => array(
				'childs' => array(
					'main'         => array( 'order' => '01a', 'path' => '' ),
					'logo'         => array( 'order' => '02a', 'path' => '' ),
					'search'       => array( 'order' => '03a', 'path' => '' ),
					'language'     => array( 'order' => '04a', 'path' => '' ),
					'currency'     => array( 'order' => '05a', 'path' => '' ),
					'notify'       => array( 'order' => '06a', 'path' => '' ),
					'balance'      => array( 'order' => '07a', 'path' => '' ),
					'menu'         => array( 'order' => '08a', 'path' => '' ),
					'auth-buttons' => array( 'order' => '09a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '02a',
			),
			'footer' => array(
				'childs' => array(
					'main'          => array( 'order' => '01a', 'path' => '' ),
					'logo'          => array( 'order' => '02a', 'path' => '' ),
					'cards'         => array( 'order' => '03a', 'path' => '' ),
					'social-media'  => array( 'order' => '04a', 'path' => '' ),
					'currency'      => array( 'order' => '05a', 'path' => '' ),
					'scroll-to-top' => array( 'order' => '06a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '03a',
			),
			'typography' => array(
				'childs' => array(
					'main'     => array( 'order' => '01a', 'path' => '' ),
					'elements' => array( 'order' => '02a', 'path' => '' ),
					'headings' => array( 'order' => '03a', 'path' => '' ),
					'header'   => array( 'order' => '04a', 'path' => '' ),
					'footer'   => array( 'order' => '05a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '04a',
			),
			'elements' => array(
				'childs' => array(
					'main'         => array( 'order' => '01a', 'path' => '' ),
					'form'         => array( 'order' => '02a', 'path' => '' ),
					'load-more'    => array( 'order' => '03a', 'path' => '' ),
					'blog'         => array( 'order' => '04a', 'path' => '' ),
					'notify'       => array( 'order' => '05a', 'path' => '' ),
					'job'          => array( 'order' => '06a', 'path' => '' ),
					'request'      => array( 'order' => '07a', 'path' => '' ),
					'user'         => array( 'order' => '08a', 'path' => '' ),
					'user-account' => array( 'order' => '09a', 'path' => '' )
				),
				'path'  => '',
				'order' => '05a',
			),
			'chat' => array(
				'childs' => array(
					'main'               => array( 'order' => '01a', 'path' => '' ),
					'sidebar-anchor'     => array( 'order' => '02a', 'path' => '' ),
					'sidebar-responsive' => array( 'order' => '03a', 'path' => '' ),
					'sidebar-body'       => array( 'order' => '04a', 'path' => '' ),
					'sidebar-footer'     => array( 'order' => '05a', 'path' => '' ),
					'box-head'           => array( 'order' => '06a', 'path' => '' ),
					'box-body'           => array( 'order' => '07a', 'path' => '' ),
					'box-footer'         => array( 'order' => '08a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '06a',
			),
			'performance' => array(
				'childs' => array(),
				'path'   => '',
				'order'  => '07a',
			),
			'design-map' => array(
				'childs' => array(),
				'path'   => '',
				'order'  => '08a',
			)
		];

		$jobster_design = apply_filters( 'wpj_admin_design_items_filter', $jobster_design );
		$jobster_design = wpj_sort_array_by_key( $jobster_design, SORT_ASC, 'order' );

		foreach ( $jobster_design as $slug => $menu ) {
			if ( ! empty ( $menu['childs'] ) ) {
				$childs = wpj_sort_array_by_key( $menu['childs'], SORT_ASC, 'order' );
				
				foreach ( $childs as $child_slug => $child_menu ) {
					$menu_url[] = $child_menu['path'] ? $child_menu['path'] : get_template_directory() . '/admin/jobster-design/' . $slug . '/' . $child_slug . '.php';
				}

			} else {
				$menu_url[] = $menu['path'] ? $menu['path'] : get_template_directory() . '/admin/jobster-design/' . $slug . '.php';

			}
		}

		foreach ( $menu_url as $m_inc ) { include_once ( $m_inc ); }

	}

});