<?php
/**
 * Merlin WP configuration file.
 *
 * @package   Merlin WP
 * @version   @@pkg.version
 * @link      https://merlinwp.com/
 * @author    Rich Tabor, from ThemeBeans.com & the team at ProteusThemes.com
 * @copyright Copyright (c) 2018, Merlin WP of Inventionn LLC
 * @license   Licensed GPLv3 for Open Source Use
 */

if ( ! class_exists( 'Merlin' ) ) return;

/**
 * Set directory locations, text strings, and settings.
 */

$wizard = new Merlin(

	$config = [
		'directory'            => 'vendor/merlin', // Location / directory where Merlin WP is placed in your theme.
		'merlin_url'           => 'wpjobster-install', // The wp-admin page slug where Merlin WP loads.
		'parent_slug'          => 'themes.php', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://codex.wordpress.org/child_themes', // URL for the 'child-action-link'.
		'dev_mode'             => false, // Enable development mode for testing.
		'license_step'         => true, // EDD license activation step.
		'license_required'     => false, // Require the license activation step.
		'license_help_url'     => '', // URL for the 'license-tooltip'.
		'edd_remote_api_url'   => 'https://wpjobster.com', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => get_option( 'theme_license_type' ) . ' License', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => 'wpjobster', // EDD_Theme_Updater_Admin item_slug.
		'ready_big_button_url' => get_bloginfo( 'url' ), // Link for the big button on the ready step.
	],
	$strings = [
		'admin-menu'               => esc_html__( 'Theme Setup', 'wpjobster' ),
		'title%s%s%s%s'            => esc_html__( '%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'wpjobster' ), /* tab title */
		'return-to-dashboard'      => esc_html__( 'Return to the dashboard', 'wpjobster' ), /* bottom link */
		'ignore'                   => '',

		/* Buttons Label */
		'btn-skip'                 => esc_html__( 'Skip', 'wpjobster' ),
		'btn-next'                 => esc_html__( 'Next', 'wpjobster' ),
		'btn-start'                => esc_html__( 'Start', 'wpjobster' ),
		'btn-no'                   => esc_html__( 'Cancel', 'wpjobster' ),
		'btn-plugins-install'      => esc_html__( 'Next', 'wpjobster' ),
		'btn-child-install'        => esc_html__( 'Next', 'wpjobster' ),
		'btn-content-install'      => esc_html__( 'Next', 'wpjobster' ),
		'btn-import'               => esc_html__( 'Next', 'wpjobster' ),
		'btn-license-activate'     => esc_html__( 'Next', 'wpjobster' ),
		'btn-license-skip'         => esc_html__( 'Activate Later', 'wpjobster' ),

		/* Welcome TAB */
		'welcome-header%s'         => esc_html__( 'Welcome to %s Marketplace Theme!', 'wpjobster' ),
		'welcome-header-success%s' => esc_html__( 'Hi. Welcome back!', 'wpjobster' ),
		'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import demo content. It is optional & should take only a few minutes.', 'wpjobster' ),
		'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'wpjobster' ),

		/* Child Theme TAB */
		'child-header'             => esc_html__( 'Install Child Theme', 'wpjobster' ),
		'child-header-success'     => esc_html__( 'You\'re good to go!', 'wpjobster' ),
		'child'                    => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'wpjobster' ),
		'child-success%s'          => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'wpjobster' ),
		'child-action-link'        => esc_html__( 'Learn about child themes', 'wpjobster' ),
		'child-json-success%s'     => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'wpjobster' ),
		'child-json-already%s'     => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'wpjobster' ),

		/* License TAB */
		'license-header%s'         => esc_html__( 'Activate %s', 'wpjobster' ),
		'license-header-success%s' => esc_html__( '%s is Activated', 'wpjobster' ),
		'license%s'                => esc_html__( 'Enter your license key to enable remote updates and theme support.', 'wpjobster' ),
		'license-label'            => esc_html__( 'License key', 'wpjobster' ),
		'license-success%s'        => esc_html__( 'The theme is already registered, so you can go to the next step!', 'wpjobster' ),
		'license-json-success%s'   => esc_html__( 'Your theme is activated! Remote updates and theme support are enabled.', 'wpjobster' ),
		'license-tooltip'          => esc_html__( 'Need help?', 'wpjobster' ),

		/* Plugins TAB */
		'plugins-header'           => esc_html__( 'Install Plugins', 'wpjobster' ),
		'plugins-header-success'   => esc_html__( 'You\'re up to speed!', 'wpjobster' ),
		'plugins'                  => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.', 'wpjobster' ),
		'plugins-success%s'        => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'wpjobster' ),
		'plugins-action-link'      => esc_html__( 'Advanced', 'wpjobster' ),

		/* Demo Content TAB */
		'import-header'            => esc_html__( 'Import Content', 'wpjobster' ),
		'import'                   => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.', 'wpjobster' ),
		'import-action-link'       => esc_html__( 'Advanced', 'wpjobster' ),

		/* Ready TAB */
		'ready-header'             => esc_html__( 'All done. Have fun!', 'wpjobster' ),
		'ready%s'                  => esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.', 'wpjobster' ),
		'ready-action-link'        => esc_html__( 'More Options', 'wpjobster' ),
		'ready-big-button'         => esc_html__( 'View your website', 'wpjobster' ),
		'ready-link-1'             => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'admin.php?page=jobster-design' ), esc_html__( 'Start Design Customizing', 'wpjobster' ) ),
		'ready-link-2'             => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'admin.php?page=jobster-settings' ), esc_html__( 'Start Settings Customizing', 'wpjobster' ) ),
		'ready-link-3'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wpjobster.com/help/', esc_html__( 'Get Theme Support', 'wpjobster' ) )
	]
);

include_once get_template_directory() . '/admin/first-run/merlin/child-theme.php'; /* child theme */
include_once get_template_directory() . '/admin/first-run/merlin/license.php'; /* license */
include_once get_template_directory() . '/admin/first-run/merlin/plugin-install.php'; /* plugins list */
include_once get_template_directory() . '/admin/first-run/merlin/demo-content.php'; /* demo content */

// Import database //
if ( get_option( 'sql_imported' ) != 'done' ) {
	include_once get_template_directory() . '/admin/first-run/sql.php';
	update_option( 'sql_imported', 'done' );
}

// Import htaccess //
if ( get_option( 'htaccess_imported' ) != 'done' ) {
	include_once get_template_directory() . '/admin/first-run/htaccess.php';
	update_option( 'htaccess_imported', 'done' );
}

// Import emails //
if ( get_option( 'emails_imported' ) != 'done' && get_option( 'wpjobster_skip_migration' ) == 1 ) {
	include_once get_template_directory() . '/admin/first-run/emails.php';
	update_option( 'emails_imported', 'done' );
}

// Import sms //
if ( get_option( 'sms_imported' ) != 'done' && get_option( 'wpjobster_skip_migration' ) == 1 ) {
	include_once get_template_directory() . '/admin/first-run/sms.php';
	update_option( 'sms_imported', 'done' );
}

// Save fields structure
if ( get_option( 'structure_imported' ) != 'done' ) {
	include_once get_template_directory() . '/admin/first-run/structure.php';
	update_option( 'structure_imported', 'done' );
}

// Update database //
include_once get_template_directory() . '/admin/first-run/import.php';
include_once get_template_directory() . '/admin/first-run/change-options.php';
include_once get_template_directory() . '/admin/first-run/change-metas.php';

// Notices
include_once get_template_directory() . '/admin/first-run/notices.php';