<?php

class WPJOptionsSettingsMenu
{
	const menuSettingsId      = 'jobster-settings';
	const menuDesignId        = 'jobster-design';
	const menuOrdersId        = 'jobster-orders';
	const menuMessagesId      = 'jobster-messages';
	const menuNotificationsId = 'jobster-notifications';

	public function getSettingsId() {
		return self::menuSettingsId;
	}

	public function getDesignId() {
		return self::menuDesignId;
	}

	public function getOrdersId() {
		return self::menuOrdersId;
	}

	public function getMessagesId() {
		return self::menuMessagesId;
	}

	public function getNotificationsId() {
		return self::menuNotificationsId;
	}

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_action( 'current_screen', [ $this, 'refreshPageAfterReduxActivation' ] );

		add_action( 'admin_menu', [ $this, 'addLeftBarMenus' ] );
		add_action( 'admin_bar_menu', [ $this, 'addTopBarMenus' ], 32, 1 );
	}

	/**
	 * Register Menus
	 */
	public function addLeftBarMenus() {
		if ( ! is_plugin_active( 'redux-framework/redux-framework.php' ) ) {
			// Settings
			add_menu_page(
				esc_html__( 'Jobster Settings', 'wpjobster' ),
				esc_html__( 'Jobster Settings', 'wpjobster' ),
				'manage_options',
				$this->getSettingsId(),
				[ $this, 'loadLeftBarMenusContent' ],
				'dashicons-admin-tools',
				2
			);

			// Design
			add_menu_page(
				esc_html__( 'Jobster Design', 'wpjobster' ),
				esc_html__( 'Jobster Design', 'wpjobster' ),
				'manage_options',
				$this->getDesignId(),
				[ $this, 'loadLeftBarMenusContent' ],
				'dashicons-admin-customizer',
				3
			);
		}

		// Orders
		add_menu_page(
			esc_html__( 'Orders', 'wpjobster' ),
			esc_html__( 'Orders', 'wpjobster' ),
			'manage_options',
			$this->getOrdersId(),
			'wpj_display_order_page_content',
			'dashicons-cart',
			35
		);

			// Resolution center
			add_submenu_page(
				$this->getOrdersId(),
				esc_html__( 'Resolution Center', 'wpjobster' ),
				esc_html__( 'Resolution Center', 'wpjobster' ) . '<span class="count_arbitration"></span>',
				'manage_options', 'jobster-resolution-center',
				'wpj_display_resolution_center_page_content'
			);

			// Transactions
			add_submenu_page(
				$this->getOrdersId(),
				esc_html__( 'Transactions', 'wpjobster' ),
				esc_html__( 'Transactions', 'wpjobster' ),
				'manage_options',
				'jobster-transactions',
				'wpj_display_transactions_page_content'
			);

			// Summary
			add_submenu_page(
				$this->getOrdersId(),
				esc_html__( 'Summary', 'wpjobster' ),
				esc_html__( 'Summary', 'wpjobster' ),
				'manage_options', 'jobster-summary',
				'wpj_display_summary_page_content'
			);

		// Messages
		add_menu_page(
			esc_html__( 'Messages', 'wpjobster' ),
			esc_html__( 'Messages', 'wpjobster' ),
			'manage_options',
			'jobster-messages',
			'wpj_display_private_messages_page_content',
			'dashicons-email-alt',
			36
		);

		// Notifications
		add_menu_page(
			esc_html__( 'Notifications', 'wpjobster' ),
			esc_html__( 'Notifications', 'wpjobster' ),
			'manage_options',
			'jobster-notifications',
			'wpj_display_notifications_page_content',
			'dashicons-bell',
			36
		);
	}

	public function loadLeftBarMenusContent() {
		$path_plugin_url = WP_PLUGIN_DIR . '/redux-framework/redux-framework.php';

		if ( file_exists( $path_plugin_url ) ) {
			echo '<div class="notice notice-warning is-dismissible">';
				echo '<p>' . __( 'Entering settings editing mode...', 'wpjobster' ) . '</p>';
			echo '</div>';

			activate_plugin( 'redux-framework/redux-framework.php' );

		} else {
			echo '<div class="notice notice-error is-dismissible">';
				echo '<p>' . __( 'To change the settings you need to install Redux plugin because the theme use this plugin to edit the settings. Please install it and keep it disabled because it will automatically activate when you are in the settings editing pages and will automatically deactivate when you leave the settings editing pages.', 'wpjobster' ) . '</p>';
				echo '<p><a class="button action" href="' . admin_url( 'plugins.php?page=tgmpa-install-plugins' ) . '">' . __( 'Go to Required Plugins', 'wpjobster' ) . '</a></p>';
			echo '</div>';

		}
	}

	public function addTopBarMenus( $admin_bar ) {
		$admin_bar->add_menu( [
			'id'    => $this->getSettingsId(),
			'title' => '<span class="ab-icon dashicons-admin-tools"></span>' . __( 'Jobster Settings', 'wpjobster' ),
			'href'  => get_admin_url() . 'admin.php?page=' . $this->getSettingsId(),
			'meta'  => array( 'title' => __( 'Settings', 'wpjobster' ) )
		]);

		$admin_bar->add_menu( [
			'id'    => $this->getDesignId(),
			'title' => '<span class="ab-icon dashicons-admin-customizer"></span>' . __( 'Jobster Design', 'wpjobster' ),
			'href'  => get_admin_url() . 'admin.php?page=' . $this->getDesignId(),
			'meta'  => array( 'title' => __( 'Design', 'wpjobster' ) )
		]);

		$admin_bar->add_menu( [
			'id'    => $this->getOrdersId(),
			'title' => '<span class="ab-icon dashicons-cart"></span>' . __( 'Orders', 'wpjobster' ),
			'href'  => get_admin_url() . 'admin.php?page=' . $this->getOrdersId(),
			'meta'  => array( 'title' => __( 'Orders', 'wpjobster' ) )
		]);

		$admin_bar->add_menu( [
			'id'    => $this->getMessagesId(),
			'title' => '<span class="ab-icon dashicons-email-alt"></span>' . __( 'Messages', 'wpjobster' ),
			'href'  => get_admin_url() . 'admin.php?page=' . $this->getMessagesId(),
			'meta'  => array( 'title' => __( 'Messages', 'wpjobster' ) )
		]);

		$admin_bar->add_menu( [
			'id'    => $this->getNotificationsId(),
			'title' => '<span class="ab-icon dashicons-bell"></span>' . __( 'Notifications', 'wpjobster' ),
			'href'  => get_admin_url() . 'admin.php?page=' . $this->getNotificationsId(),
			'meta'  => array( 'title' => __( 'Notifications', 'wpjobster' ) )
		]);
	}

	public function refreshPageAfterReduxActivation() {
		$screen = get_current_screen();

		if ( isset( $screen->base ) ) {
			$path_plugin_url = WP_PLUGIN_DIR . '/redux-framework/redux-framework.php';

			if ( file_exists( $path_plugin_url ) ) {
				if ( 'toplevel_page_jobster-settings' === $screen->base || 'toplevel_page_jobster-design' === $screen->base ) {
					if ( ! is_plugin_active( 'redux-framework/redux-framework.php' ) ) {
						header( "Refresh:0" );
					}
				}
			}
		}
	}
}

add_action( 'after_setup_theme', [ 'WPJOptionsSettingsMenu', 'init' ] );