<?php // Jobster Settings

add_action( 'after_setup_theme', function() {

	if ( class_exists( 'Redux' ) ) {
		$jobster_design = wpj_get_design_option();

		$opt_name  = 'jobster_settings';
		$theme     = wp_get_theme();

		$args = [
			'opt_name'           => $opt_name,

			'display_name'       => $theme->get( 'Name' ),
			'display_version'    => $theme->get( 'Version' ),
			'intro_text'         => '<p>' . __( 'After you finish editing and saving the settings, please press the <b>Save and Exit</b> button to exit the settings editing mode. If you leave the site in edit mode, performance will be affected and pages will have a harder time loading.', 'wpjobster' ) . '</p>',

			'menu_type'          => 'menu',
			'menu_title'         => __( 'Jobster Settings', 'wpjobster' ),
			'menu_icon'          => 'dashicons-admin-tools',
			'allow_sub_menu'     => true,

			'page_title'         => __( 'Jobster Settings', 'wpjobster' ),
			'page_priority'      => 2,
			'page_parent'        => 'themes.php',
			'page_permissions'   => 'manage_options',
			'page_icon'          => get_template_directory_uri() . '/assets/images/logo/logo.png',
			'page_slug'          => 'jobster-settings',

			'admin_bar'          => true,
			'admin_bar_icon'     => 'dashicons-admin-tools',
			'admin_bar_priority' => 31,

			'footer_credit'      => ! empty( $jobster_design['copyright_text'] ) ? $jobster_design['copyright_text'] : sprintf( __( '&copy; %d wpjobster.com', 'wpjobster' ), date( 'Y' ) ),

			'dev_mode'           => false,
			'show_import_export' => is_demo_admin() ? false : true,

			'search'             => true,
			'default_show'       => true
		];
		Redux::set_args( $opt_name, $args );

		Redux::set_extensions( $opt_name, get_template_directory() . '/vendor/redux/repeater' ); /* add repeater extension */
		Redux::set_extensions( $opt_name, get_template_directory() . '/vendor/redux/accordion' ); /* add accordion extension */

		$jobster_settings = [
			'general' => array(
				'childs' => array(
					'main'           => array( 'order' => '01a', 'path' => '' ),
					'job'            => array( 'order' => '02a', 'path' => '' ),
					'request'        => array( 'order' => '03a', 'path' => '' ),
					'user'           => array( 'order' => '04a', 'path' => '' ),
					'authentication' => array( 'order' => '05a', 'path' => '' ),
					'order'          => array( 'order' => '06a', 'path' => '' ),
					'search'         => array( 'order' => '07a', 'path' => '' ),
					'level'          => array( 'order' => '08a', 'path' => '' ),
					'blog'           => array( 'order' => '09a', 'path' => '' ),
					'cron'           => array( 'order' => '10a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '01a',
			),
			'character' => array(
				'childs' => array(
					'main'   => array( 'order' => '01a', 'path' => '' ),
					'filter' => array( 'order' => '02a', 'path' => '' ),
					'limit'  => array( 'order' => '03a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '02a',
			),
			'feature' => array(
				'childs' => array(
					'main'                => array( 'order' => '01a', 'path' => '' ),
					'fees-charged'        => array( 'order' => '02a', 'path' => '' ),
					'job-package'         => array( 'order' => '03a', 'path' => '' ),
					'tip'                 => array( 'order' => '04a', 'path' => '' ),
					'extra-service'       => array( 'order' => '05a', 'path' => '' ),
					'extra-fast-delivery' => array( 'order' => '06a', 'path' => '' ),
					'active-jobs'         => array( 'order' => '07a', 'path' => '' ),
					'additional-revision' => array( 'order' => '08a', 'path' => '' ),
					'job-multiple'        => array( 'order' => '09a', 'path' => '' ),
					'extra-multiple'      => array( 'order' => '10a', 'path' => '' ),
					'video-multiple'      => array( 'order' => '11a', 'path' => '' ),
					'profile-label'       => array( 'order' => '12a', 'path' => '' ),
					'icon-url'            => array( 'order' => '13a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '03a',
			),
			'pricing' => array(
				'childs' => array(
					'main'     => array( 'order' => '01a', 'path' => '' ),
					'currency' => array( 'order' => '02a', 'path' => '' ),
					'fee'      => array( 'order' => '03a', 'path' => '' ),
					'limit'    => array( 'order' => '04a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '04a',
			),
			'page' => array(
				'childs' => array(
					'main'       => array( 'order' => '01a', 'path' => '' ),
					'assignment' => array( 'order' => '02a', 'path' => '' ),
					'permalink'  => array( 'order' => '03a', 'path' => '' ),
					'redirects'  => array( 'order' => '04a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '05a',
			),
			'notify' => array(
				'childs' => array(
					'main'        => array( 'order' => '01a', 'path' => '' ),
					'language'    => array( 'order' => '02a', 'path' => '' ),
					'sms-gateway' => array( 'order' => '03a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '06a',
			),
			'payment-type' => array(
				'childs' => array(
					'main'         => array( 'order' => '01a', 'path' => '' ),
					'job'          => array( 'order' => '02a', 'path' => '' ),
					'featured'     => array( 'order' => '03a', 'path' => '' ),
					'topup'        => array( 'order' => '04a', 'path' => '' ),
					'withdrawal'   => array( 'order' => '05a', 'path' => '' ),
					'badge'        => array( 'order' => '06a', 'path' => '' ),
					'subscription' => array( 'order' => '07a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '07a',
			),
			'payment-gateways' => array(
				'childs' => array(
					'main'         => array( 'order' => '01a', 'path' => '' ),
					'cod'          => array( 'order' => '03a', 'path' => '' ),
					'banktransfer' => array( 'order' => '04a', 'path' => '' ),
				),
				'path'  => '',
				'order' => '08a',
			),
			'extensions' => array(
				'childs' => array(
					'main' => array( 'order' => '01a', 'path' => '' ),
				),
				'path'   => '',
				'order'  => '09a',
			),
			'tracking' => array(
				'childs' => array(),
				'path'   => '',
				'order'  => '10a',
			),
			'changelog' => array(
				'childs' => array(),
				'path'   => '',
				'order'  => '11a',
			),
			'info' => array(
				'childs' => array(),
				'path'   => '',
				'order'  => '12a',
			),
			'map' => array(
				'childs' => array(),
				'path'   => '',
				'order'  => '13a',
			)
		];

		$jobster_settings = apply_filters( 'wpj_admin_settings_items_filter', $jobster_settings );

		if ( count( $jobster_settings['extensions']['childs'] ) == 1 && empty( $jobster_settings['extensions']['childs']['main']['path'] ) )
			unset( $jobster_settings['extensions'] );

		$jobster_settings = wpj_sort_array_by_key( $jobster_settings, SORT_ASC, 'order' );

		$menu_info = [];

		foreach ( $jobster_settings as $slug => $menu ) {
			if ( ! empty ( $menu['childs'] ) ) {
				$childs = wpj_sort_array_by_key( $menu['childs'], SORT_ASC, 'order' );

				foreach ( $childs as $child_slug => $child_menu ) {
					$menu_info[$slug . '_' . $child_slug]['file_path']    = $child_menu['path'] ? $child_menu['path'] : get_template_directory() . '/admin/jobster-settings/' . $slug . '-settings/' . $child_slug . '.php';
					$menu_info[$slug . '_' . $child_slug]['settings_var'] = $child_slug == 'main' ? str_replace( '-', '_', $slug ) . '_settings_array' : str_replace( '-', '_', $slug ) . '_' . str_replace( '-', '_', $child_slug ) . '_settings_array';
				}

			} else {
				$menu_info[$slug]['file_path']    = $menu['path'] ? $menu['path'] : get_template_directory() . '/admin/jobster-settings/' . $slug . '.php';
				$menu_info[$slug]['settings_var'] = $slug . '_settings_array';

			}
		}

		$post_max_size = floatval( preg_replace( '/[^0-9]/', '', ini_get( 'post_max_size' ) ) );

		foreach ( $menu_info as $mi ) {
			if ( isset( $mi['file_path'] ) ) include_once ( $mi['file_path'] );
			if ( isset( ${$mi['settings_var']} ) ) Redux::setSection( $opt_name, ${$mi['settings_var']} );
		}
	}

});