// LESS COMPILER
function wpj_compile_theme_colours() {
	var lessCode = '';
	var xmlhttp  = new XMLHttpRequest();

	jQuery( '.compiler-colours-btn' ).text( 'Please wait...' );

	jQuery( '<span class="spinner compiler-colours-spinner" style="visibility: visible; float: left;"></span>' ).insertAfter( '.compiler-colours-btn' );

	jQuery( '.wpj-less-logger' ).remove();

	jQuery( '<div class="wpj-less-logger"><div>Compilation begins...</div></div>' ).insertAfter( jQuery( '#jobster_design-wpj_compile_theme_colours' ).find( '.description.field-desc' ) );

	xmlhttp.onreadystatechange = function() {
		if ( xmlhttp.status == 200 && xmlhttp.readyState == 4 ) {
			var options = {}

			lessCode = xmlhttp.responseText;

			less.render( lessCode, options )
				.then(
					function ( output ) {
						jQuery( document ).ready( function( $ ) {
							$.ajax({
								type: "POST",
								url : wpj_vars.ajaxurl,
								data: {
									action : 'wpjobster_save_less_css_file',
									content: output.css,
								},
								success: function ( msg ) {
									jQuery( '.compiler-colours-spinner' ).remove();

									jQuery( '.compiler-colours-btn' ).text( 'Compile colours' );

									$( '.wpj-less-logger' ).append( '<div>COMPILATION COMPLETED</div>' );
									$( '.wpj-less-logger' ).scrollTop( $( '.wpj-less-logger' )[0].scrollHeight );
								}
							});
						});
					},
					function ( error ) {
						jQuery( document ).ready( function( $ ) {
							jQuery( '.compiler-colours-spinner' ).remove();

							jQuery( '.compiler-colours-btn' ).text( 'Compile colours' );

							$( '.wpj-less-logger' ).append( '<div>' + error + '</div>' );
							$( '.wpj-less-logger' ).scrollTop( $( '.wpj-less-logger' )[0].scrollHeight );
						});
					}
				);

			less.logger.addListener({
				debug: function ( msg ) {
					jQuery( '.wpj-less-logger' ).append( '<div>' + msg + '...</div>' );
					jQuery( '.wpj-less-logger' ).scrollTop( jQuery( '.wpj-less-logger' )[0].scrollHeight );
				},
				info: function ( msg ) {
					jQuery( '.wpj-less-logger' ).append( '<div>' + msg + '...</div>' );
					jQuery( '.wpj-less-logger' ).scrollTop( jQuery( '.wpj-less-logger' )[0].scrollHeight );
				},
				warn: function ( msg ) {
					jQuery( '.wpj-less-logger' ).append( '<div>' + msg + '...</div>' );
					jQuery( '.wpj-less-logger' ).scrollTop( jQuery( '.wpj-less-logger' )[0].scrollHeight );
				},
				error: function ( msg ) {
					jQuery( '.wpj-less-logger' ).append( '<div>' + msg + '...</div>' );
					jQuery( '.wpj-less-logger' ).scrollTop( jQuery( '.wpj-less-logger' )[0].scrollHeight );
				}
			});
		}
	};

	xmlhttp.open( "GET", wpj_vars.semantic_file_url, true );
	xmlhttp.send();
}