jQuery( document ).ready( function( $ ) {

	// E-MAIL/SMS SETTINGS
	if ( $.fn.accordion ) {
		$( '.ui.accordion' ).accordion();
	}

	if ( $( '.js-notifications' )[0] && wpj_vars.allow_html_emails )
		wpj_initialize_tinymce( $( '#' + $( '.acc-nav' ).find( '.menu.active' ).find( '.item.active' ).attr( 'data-item' ) ).find( 'textarea' ) );

	$( '.acc-nav .item' ).on( 'click', function( e ) {
		e.preventDefault();

		$( '.acc-nav .item' ).removeClass( 'active' );
		$( '.hidden-tab' ).removeClass( 'active' );
		$( this ).addClass( 'active' );
		$( '#' + $( this ).data( 'item' ) ).addClass( 'active' );

		history.pushState( null, null, $( this ).attr( 'href' ) );

		if ( $( this ).parents( '#notifications' )[0] && wpj_vars.allow_html_emails ) {
			wpj_initialize_tinymce( $( '#' + $( this ).data( 'item' ) ).find( 'textarea' ) );
		}
	});

});

/* INITIALIZE TINYMCE */
function wpj_initialize_tinymce( wrapper_id ) {
	wrapper_id.each( function() {
		tinyMCE.init({
			mode                  : "specific_textareas",
			editor_selector       : jQuery( this ).attr( 'name' ),
			plugins               : 'paste directionality fullscreen image link media charmap hr lists charmap wordpress textcolor',

			menubar: false,

			toolbar: [
				'formatselect fontselect fontsizeselect | removeformat | numlist bullist | outdent indent',
				'bold italic underline strikethrough superscript subscript wp_code | forecolor backcolor | alignleft aligncenter alignright alignjustify | rtl',
				'undo redo | copy cut paste | wp_add_media image media | link unlink | charmap fullscreen',
			],

			height                : 200,
			document_base_url     : wpj_vars.site_URL + '/',
			convert_urls          : true,
			relative_urls         : false,
			remove_script_host    : false,
			force_br_newlines     : true,
			force_p_newlines      : true,
			remove_linebreaks     : false,
			convert_newlines_to_br: true,
		});
	});
}