jQuery( document ).ready( function( $ ) {

	// NEW ARBITRATION NOTIFY
	if ( wpj_vars.arbitration_number && wpj_vars.arbitration_number != 0 ) {
		if ( $( '.count_arbitration' )[0] ) {
			$( '.count_arbitration' ).addClass( 'update-plugins' ).addClass( 'count-' + wpj_vars.arbitration_number );
			$( '.count_arbitration' ).html( '<span class="plugin-count">' + parseInt( wpj_vars.arbitration_number ) + '</span>' );
			if ( $( '.count_arbitration' ).parents( 'li' ).hasClass( 'current' ) ) {
				$( 'li.current' ).find( 'a.current' ).addClass( 'wp-has-current-submenu' );
			}
		}
	}

	// DELETE REVIEW
	$( document ).on( 'click', '#delete_review', function() {

		var id = $( this ).attr( 'data-id' );

		$.ajax({
			type: "POST",
			url: wpj_vars.ajaxurl,
			data: {
				action: 'delete_review',
				id    : id
			},
			success: function( msg ) {
				// Refresh div content
				refreshContent( '.order-single-page' );
			}
		});
	});

	// DELETE REVIEW RESPONSE
	$( document ).on( 'click', '#delete_review_response', function() {

		var id = $( this ).attr( 'data-id' );

		$.ajax({
			type: "POST",
			url: wpj_vars.ajaxurl,
			data: {
				action: 'delete_review_response',
				id    : id
			},
			success: function( msg ) {
				// Refresh div content
				refreshContent( '.order-single-page' );
			}
		});
	});

	// DELETE TRANSACTION MESSAGE
	$( document ).on( 'click', '#delete_order_message', function() {

		var id = $( this ).attr( 'data-id' );

		$.ajax({
			type: "POST",
			url: wpj_vars.ajaxurl,
			data: {
				action: 'delete_transaction_message',
				id    : id
			},
			success: function( msg ) {
				// Refresh div content
				refreshContent( '.order-single-page' );
			}
		});
	});

	// SET ORDER ARBITRATION
	$( document ).on( 'click', '.js-complete-arbitration', function() {
		$( this ).find( 'i' ).attr( 'class', 'disabled circle notch icon' );

		var id = $( this ).attr( 'data-id' );
		var action = $( this ).attr( 'data-action' );
		$.ajax({
			type: "POST",
			url: wpj_vars.ajaxurl,
			data: "arbitration_id=" + id + "&arbitration_for=" + action + "&message=" + $( this ).parents( 'tr' ).find( 'textarea' ).val(),
			success: function( msg ) {
				location.reload();
			}
		});
	});

	/* MARK AUTOMATICALLY AS COMPLETED */
	$( document ).on( 'click', '.mark-order-completed', function( e ) {
		e.preventDefault();

		var gateway = $( this ).attr( 'class' ).split( ' ' ).pop();
		gateway = gateway[0].toUpperCase() + gateway.slice( 1 );

		$( this ).parents( 'tr' ).find( 'input[type="checkbox"]' ).prop( 'checked', true );

		$( '#process' + gateway + 'PayRequest' ).trigger( 'click' );
	});

});